/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.gen.tree;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import lotr.common.world.gen.tree.ExtendedTrunkPlacer;
import lotr.common.world.gen.tree.LOTRTrunkPlacers;
import net.minecraft.block.BlockState;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.trunkplacer.TrunkPlacerType;

public class FangornTrunkPlacer
extends ExtendedTrunkPlacer {
    protected static final Codec<FangornTrunkPlacer> CODEC = RecordCodecBuilder.create(instance -> FangornTrunkPlacer.baseCodecWithWood(instance).apply((Applicative)instance, FangornTrunkPlacer::new));
    private final boolean generateLeaves = true;

    protected FangornTrunkPlacer(int baseHeight, int heightRandA, int heightRandB, Optional<BlockStateProvider> woodProvider, Optional<BlockStateProvider> strippedLogProvider, Optional<BlockStateProvider> branchProvider) {
        super(baseHeight, heightRandA, heightRandB, woodProvider, strippedLogProvider, branchProvider);
    }

    public FangornTrunkPlacer(int baseHeight, int heightRandA, int heightRandB, BlockState wood, BlockState strippedLog) {
        this(baseHeight, heightRandA, heightRandB, Optional.of(new SimpleBlockStateProvider(wood)), Optional.of(new SimpleBlockStateProvider(strippedLog)), Optional.empty());
    }

    protected TrunkPlacerType<?> func_230381_a_() {
        return LOTRTrunkPlacers.FANGORN_TRUNK_PLACER;
    }

    public List<FoliagePlacer.Foliage> func_230382_a_(IWorldGenerationReader world, Random rand, int trunkHeight, BlockPos basePos, Set<BlockPos> trunk, MutableBoundingBox bb, BaseTreeFeatureConfig config) {
        int trunkRadiusMin = (int)((float)trunkHeight * 0.125f);
        int trunkRadiusMax = trunkRadiusMin + 4;
        int xSlope = MathHelper.func_76136_a((Random)rand, (int)4, (int)10) * (rand.nextBoolean() ? -1 : 1);
        int zSlope = MathHelper.func_76136_a((Random)rand, (int)4, (int)10) * (rand.nextBoolean() ? -1 : 1);
        ArrayList<FoliagePlacer.Foliage> foliage = new ArrayList<FoliagePlacer.Foliage>();
        BlockPos.Mutable offsetCentrePos = new BlockPos.Mutable().func_189533_g((Vector3i)basePos);
        HashSet<BlockPos> strippedLogTrunkPositions = new HashSet<BlockPos>();
        BlockPos.Mutable movingPos = new BlockPos.Mutable();
        for (int y = 0; y < trunkHeight; ++y) {
            float heightF = (float)y / (float)trunkHeight;
            int width = trunkRadiusMax - (int)(heightF * (float)(trunkRadiusMax - trunkRadiusMin));
            for (int x = -width; x <= width; ++x) {
                for (int z = -width; z <= width; ++z) {
                    movingPos.func_189533_g((Vector3i)offsetCentrePos).func_196234_d(x, y, z);
                    if (x * x + z * z >= width * width) continue;
                    if (this.placeStrippedLog(world, rand, (BlockPos)movingPos, trunk, bb, config, Direction.Axis.Y)) {
                        strippedLogTrunkPositions.add(movingPos.func_185334_h());
                    }
                    if (y != 0) continue;
                    LOTRTrunkPlacers.setGrassToDirt(world, movingPos.func_177977_b());
                    BlockPos.Mutable woodBelowPos = new BlockPos.Mutable().func_189533_g((Vector3i)movingPos.func_177977_b());
                    int woodBelow = 0;
                    int maxWoodBelow = 6 + rand.nextInt(5);
                    while (woodBelowPos.func_177956_o() >= 0 && this.placeStrippedLog(world, rand, (BlockPos)woodBelowPos, trunk, bb, config, Direction.Axis.Y)) {
                        strippedLogTrunkPositions.add(woodBelowPos.func_185334_h());
                        LOTRTrunkPlacers.setGrassToDirt(world, woodBelowPos.func_177977_b());
                        woodBelowPos.func_189536_c(Direction.DOWN);
                        if (++woodBelow <= maxWoodBelow) continue;
                    }
                }
            }
            if (y % xSlope == 0) {
                if (xSlope > 0) {
                    offsetCentrePos.func_189536_c(Direction.EAST);
                } else if (xSlope < 0) {
                    offsetCentrePos.func_189536_c(Direction.WEST);
                }
            }
            if (y % zSlope != 0) continue;
            if (zSlope > 0) {
                offsetCentrePos.func_189536_c(Direction.SOUTH);
                continue;
            }
            if (zSlope >= 0) continue;
            offsetCentrePos.func_189536_c(Direction.NORTH);
        }
        Predicate<BlockState> notWood = state -> !state.func_235714_a_((ITag)BlockTags.field_200031_h);
        block4: for (BlockPos strippedPos : strippedLogTrunkPositions) {
            for (Direction checkDir : Direction.values()) {
                if (!world.func_217375_a(strippedPos.func_177972_a(checkDir), notWood)) continue;
                world.func_180501_a(strippedPos, ((BlockStateProvider)this.woodProvider.get()).func_225574_a_(rand, strippedPos), 19);
                continue block4;
            }
        }
        int angle = 0;
        while (angle < 360) {
            float angleR = (float)Math.toRadians(angle += 10 + rand.nextInt(20));
            float sin = MathHelper.func_76126_a((float)angleR);
            float cos = MathHelper.func_76134_b((float)angleR);
            int boughLength = 12 + rand.nextInt(10);
            int boughThickness = Math.round((float)boughLength / 25.0f * 1.5f);
            int boughBaseHeight = MathHelper.func_76141_d((float)((float)trunkHeight * (0.9f + rand.nextFloat() * 0.1f)));
            int boughHeight = 3 + rand.nextInt(4);
            for (int l = 0; l < boughLength; ++l) {
                int x = Math.round(cos * (float)l);
                int z = Math.round(sin * (float)l);
                int y = boughBaseHeight + Math.round((float)l / (float)boughLength * (float)boughHeight);
                int range = boughThickness - Math.round((float)l / (float)boughLength * (float)boughThickness * 0.5f);
                for (int x1 = -range; x1 <= range; ++x1) {
                    for (int y1 = -range; y1 <= range; ++y1) {
                        for (int z1 = -range; z1 <= range; ++z1) {
                            movingPos.func_189533_g((Vector3i)offsetCentrePos).func_196234_d(x + x1, y + y1, z + z1);
                            this.placeWood(world, rand, (BlockPos)movingPos, trunk, bb, config, Direction.Axis.Y);
                        }
                    }
                }
                int branch_angle = angle + rand.nextInt(360);
                float branch_angleR = (float)Math.toRadians(branch_angle);
                float branch_sin = MathHelper.func_76126_a((float)branch_angleR);
                float branch_cos = MathHelper.func_76134_b((float)branch_angleR);
                int branchLength = 7 + rand.nextInt(6);
                int branchHeight = rand.nextInt(6);
                for (int l1 = 0; l1 < branchLength; ++l1) {
                    int x1 = x + Math.round(branch_cos * (float)l1);
                    int z1 = z + Math.round(branch_sin * (float)l1);
                    int y1 = y + Math.round((float)l1 / (float)branchLength * (float)branchHeight);
                    for (int y2 = 0; y2 >= -1; --y2) {
                        movingPos.func_189533_g((Vector3i)offsetCentrePos).func_196234_d(x1, y1 + y2, z1);
                        this.placeWood(world, rand, (BlockPos)movingPos, trunk, bb, config, Direction.Axis.Y);
                    }
                    if (l1 != branchLength - 1) continue;
                    BlockPos foliagePos = offsetCentrePos.func_185334_h().func_177982_a(x1, y1, z1);
                    foliage.add(new FoliagePlacer.Foliage(foliagePos, 0, false));
                }
            }
        }
        return foliage;
    }
}

