/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.gen.tree;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Random;
import java.util.Set;
import lotr.common.block.HangingWebBlock;
import lotr.common.init.LOTRBiomes;
import lotr.common.init.LOTRBlocks;
import lotr.common.world.biome.MirkwoodBiome;
import lotr.common.world.gen.tree.LOTRTreeDecorators;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.treedecorator.TreeDecorator;
import net.minecraft.world.gen.treedecorator.TreeDecoratorType;

public class MirkOakWebsDecorator
extends TreeDecorator {
    public static final Codec<MirkOakWebsDecorator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("only_in_mirkwood").orElse((Object)false).forGetter(deco -> deco.mirkwoodOnly), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").forGetter(deco -> Float.valueOf(deco.prob)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("per_block_chance").forGetter(deco -> Float.valueOf(deco.perBlockChance)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("double_web_chance").forGetter(deco -> Float.valueOf(deco.doubleWebChance))).apply((Applicative)instance, MirkOakWebsDecorator::new));
    private final boolean mirkwoodOnly;
    private final float prob;
    private final float perBlockChance;
    private final float doubleWebChance;

    public MirkOakWebsDecorator(boolean flag, float f, float perBlock, float doubleWeb) {
        this.mirkwoodOnly = flag;
        this.prob = f;
        this.perBlockChance = perBlock;
        this.doubleWebChance = doubleWeb;
    }

    protected TreeDecoratorType<?> func_230380_a_() {
        return LOTRTreeDecorators.MIRK_OAK_WEBS;
    }

    public void func_225576_a_(ISeedReader world, Random rand, List<BlockPos> trunk, List<BlockPos> leaves, Set<BlockPos> decoSet, MutableBoundingBox bb) {
        boolean doDecorate;
        boolean bl = doDecorate = rand.nextFloat() < this.prob;
        if (doDecorate && this.mirkwoodOnly) {
            BlockPos centralBasePos = new BlockPos((bb.field_78897_a + bb.field_78893_d) / 2, bb.field_78895_b, (bb.field_78896_c + bb.field_78892_f) / 2);
            doDecorate &= LOTRBiomes.getWrapperFor(world.func_226691_t_(centralBasePos), (IWorld)world) instanceof MirkwoodBiome;
        }
        if (doDecorate) {
            for (BlockPos leavesPos : leaves) {
                boolean placeDouble;
                BlockPos webPos;
                if (!(rand.nextFloat() < this.perBlockChance) || !world.func_175623_d(webPos = leavesPos.func_177977_b())) continue;
                BlockState baseWebState = ((Block)LOTRBlocks.HANGING_WEB.get()).func_176223_P();
                BlockPos belowWebPos = webPos.func_177977_b();
                boolean bl2 = placeDouble = rand.nextFloat() < this.doubleWebChance && world.func_175623_d(belowWebPos);
                if (placeDouble) {
                    BlockState topWebState = (BlockState)baseWebState.func_206870_a(HangingWebBlock.WEB_TYPE, (Comparable)((Object)HangingWebBlock.Type.DOUBLE_TOP));
                    BlockState bottomWebState = (BlockState)baseWebState.func_206870_a(HangingWebBlock.WEB_TYPE, (Comparable)((Object)HangingWebBlock.Type.DOUBLE_BOTTOM));
                    this.func_227423_a_((IWorldWriter)world, webPos, topWebState, decoSet, bb);
                    this.func_227423_a_((IWorldWriter)world, belowWebPos, bottomWebState, decoSet, bb);
                } else {
                    BlockState webState = (BlockState)baseWebState.func_206870_a(HangingWebBlock.WEB_TYPE, (Comparable)((Object)HangingWebBlock.Type.SINGLE));
                    this.func_227423_a_((IWorldWriter)world, webPos, webState, decoSet, bb);
                }
                world.func_180495_p(webPos).func_235734_a_((IWorld)world, webPos, 3);
            }
        }
    }
}

