/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.gen.tree;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import lotr.common.world.gen.tree.ExtendedTrunkPlacer;
import lotr.common.world.gen.tree.LOTRTrunkPlacers;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.trunkplacer.TrunkPlacerType;

public class PartyTrunkPlacer
extends ExtendedTrunkPlacer {
    protected static final Codec<PartyTrunkPlacer> CODEC = RecordCodecBuilder.create(instance -> PartyTrunkPlacer.baseCodecWithWood(instance).apply((Applicative)instance, PartyTrunkPlacer::new));

    protected PartyTrunkPlacer(int baseHeight, int heightRandA, int heightRandB, Optional<BlockStateProvider> woodProvider, Optional<BlockStateProvider> strippedLogProvider, Optional<BlockStateProvider> branchProvider) {
        super(baseHeight, heightRandA, heightRandB, woodProvider, strippedLogProvider, branchProvider);
    }

    public PartyTrunkPlacer(int baseHeight, int heightRandA, int heightRandB, BlockState wood, BlockState branch) {
        this(baseHeight, heightRandA, heightRandB, Optional.of(new SimpleBlockStateProvider(wood)), Optional.empty(), Optional.of(new SimpleBlockStateProvider(branch)));
    }

    protected TrunkPlacerType<?> func_230381_a_() {
        return LOTRTrunkPlacers.PARTY_TRUNK_PLACER;
    }

    public List<FoliagePlacer.Foliage> func_230382_a_(IWorldGenerationReader world, Random rand, int trunkHeight, BlockPos basePos, Set<BlockPos> trunk, MutableBoundingBox bb, BaseTreeFeatureConfig config) {
        ArrayList<FoliagePlacer.Foliage> foliage = new ArrayList<FoliagePlacer.Foliage>();
        int trunkWidth = 1;
        boolean flag = true;
        float trunkPitch = (float)Math.toRadians(MathHelper.func_151240_a((Random)rand, (float)65.0f, (float)90.0f));
        float trunkYaw = (float)Math.toRadians(rand.nextFloat() * 360.0f);
        BlockPos.Mutable movingPos = new BlockPos.Mutable();
        for (int y = 0; y < trunkHeight; ++y) {
            BlockPos offsetCentrePos = this.getOffsetCentrePos(basePos, y, trunkPitch, trunkYaw);
            for (int x = -trunkWidth; x <= trunkWidth; ++x) {
                for (int z = -trunkWidth; z <= trunkWidth; ++z) {
                    movingPos.func_239621_a_((Vector3i)offsetCentrePos, x, 0, z);
                    this.placeWood(world, rand, (BlockPos)movingPos, trunk, bb, config, Direction.Axis.Y);
                    if (y != 0) continue;
                    LOTRTrunkPlacers.setGrassToDirt(world, movingPos.func_177977_b());
                    BlockPos.Mutable woodBelowPos = new BlockPos.Mutable().func_189533_g((Vector3i)movingPos.func_177977_b());
                    int woodBelow = 0;
                    int maxWoodBelow = 6 + rand.nextInt(3);
                    while (woodBelowPos.func_177956_o() >= 0 && this.placeWood(world, rand, (BlockPos)woodBelowPos, trunk, bb, config, Direction.Axis.Y)) {
                        LOTRTrunkPlacers.setGrassToDirt(world, woodBelowPos.func_177977_b());
                        woodBelowPos.func_189536_c(Direction.DOWN);
                        if (++woodBelow <= maxWoodBelow) continue;
                    }
                }
            }
        }
        int angle = 0;
        while (angle < 360) {
            float angleR = (float)Math.toRadians(angle += 30 + rand.nextInt(35));
            float sin = MathHelper.func_76126_a((float)angleR);
            float cos = MathHelper.func_76134_b((float)angleR);
            int boughLength = 6 + rand.nextInt(6);
            int boughThickness = Math.round((float)boughLength * 0.05f);
            int boughBaseHeight = MathHelper.func_76141_d((float)(MathHelper.func_151240_a((Random)rand, (float)0.65f, (float)0.95f) * (float)trunkHeight));
            int boughHeight = 2 + rand.nextInt(4);
            BlockPos offsetCentrePos = this.getOffsetCentrePos(basePos, boughBaseHeight, trunkPitch, trunkYaw);
            for (int l = 0; l < boughLength; ++l) {
                int x = Math.round(cos * (float)l);
                int z = Math.round(sin * (float)l);
                int y = Math.round((float)l / (float)boughLength * (float)boughHeight);
                int range = boughThickness - Math.round((float)l / (float)boughLength * (float)boughThickness * 0.5f);
                for (int x1 = -range; x1 <= range; ++x1) {
                    for (int y1 = -range; y1 <= range; ++y1) {
                        for (int z1 = -range; z1 <= range; ++z1) {
                            movingPos.func_189533_g((Vector3i)offsetCentrePos).func_196234_d(x + x1, y + y1, z + z1);
                            this.placeWood(world, rand, (BlockPos)movingPos, trunk, bb, config, Direction.Axis.Y);
                        }
                    }
                }
                int branch_angle = angle + MathHelper.func_76136_a((Random)rand, (int)-60, (int)60);
                float branch_angleR = (float)Math.toRadians(branch_angle);
                float branch_sin = MathHelper.func_76126_a((float)branch_angleR);
                float branch_cos = MathHelper.func_76134_b((float)branch_angleR);
                int branchLength = 5 + rand.nextInt(4);
                int branchHeight = rand.nextInt(4);
                for (int l1 = 0; l1 < branchLength; ++l1) {
                    int x1 = x + Math.round(branch_cos * (float)l1);
                    int z1 = z + Math.round(branch_sin * (float)l1);
                    int y1 = y + Math.round((float)l1 / (float)branchLength * (float)branchHeight);
                    for (int y2 = 0; y2 >= 0; --y2) {
                        movingPos.func_189533_g((Vector3i)offsetCentrePos).func_196234_d(x1, y1 + y2, z1);
                        this.placeLogWithAxis(world, rand, (BlockPos)movingPos, trunk, bb, config, Direction.func_176733_a((double)branch_angle).func_176746_e().func_176740_k());
                    }
                    if (l1 != branchLength - 1 && rand.nextInt(6) != 0) continue;
                    int size = rand.nextInt(6) == 0 ? 1 : 0;
                    foliage.add(new FoliagePlacer.Foliage(offsetCentrePos.func_185334_h().func_177982_a(x1, y1 + 1, z1), size, false));
                }
            }
        }
        foliage.add(new FoliagePlacer.Foliage(this.getOffsetCentrePos(basePos, trunkHeight, trunkPitch, trunkYaw), 1, false));
        int roots = 5 + rand.nextInt(5);
        for (int l = 0; l < roots; ++l) {
            int rootUpY = 0 + rand.nextInt(4);
            BlockPos.Mutable rootPos = new BlockPos.Mutable().func_189533_g((Vector3i)this.getOffsetCentrePos(basePos, rootUpY, trunkPitch, trunkYaw));
            int rootLength = 2 + rand.nextInt(4);
            Direction rootDir = Direction.Plane.HORIZONTAL.func_179518_a(rand);
            rootPos.func_189534_c(rootDir, trunkWidth + 1);
            rootPos.func_189534_c(rootDir.func_176746_e(), MathHelper.func_76136_a((Random)rand, (int)(-trunkWidth), (int)trunkWidth));
            for (int l1 = 0; l1 < rootLength; ++l1) {
                BlockPos.Mutable dropDownPos = new BlockPos.Mutable().func_189533_g((Vector3i)rootPos);
                int woodDropped = 0;
                int maxDropped = 5;
                while (dropDownPos.func_177956_o() >= 0) {
                    boolean placedBlock;
                    BlockPos checkAbovePos = dropDownPos.func_177984_a();
                    boolean branch = woodDropped <= 1 && !world.func_217375_a(checkAbovePos, AbstractBlock.AbstractBlockState::func_200132_m);
                    boolean bl = placedBlock = branch ? this.placeBranch(world, rand, (BlockPos)dropDownPos, trunk, bb, config) : this.placeWood(world, rand, (BlockPos)dropDownPos, trunk, bb, config, Direction.Axis.Y);
                    if (!placedBlock) break;
                    if (!branch) {
                        LOTRTrunkPlacers.setGrassToDirt(world, dropDownPos.func_177977_b());
                    }
                    dropDownPos.func_189536_c(Direction.DOWN);
                    if (++woodDropped <= 5) continue;
                    break;
                }
                rootPos.func_189536_c(Direction.DOWN);
                if (!rand.nextBoolean()) continue;
                rootPos.func_189536_c(rootDir);
            }
        }
        return foliage;
    }

    private BlockPos getOffsetCentrePos(BlockPos basePos, int trunkHeightHere, float trunkPitch, float trunkYaw) {
        float upFrac = MathHelper.func_76126_a((float)trunkPitch) * (float)trunkHeightHere;
        float outFrac = MathHelper.func_76134_b((float)trunkPitch) * (float)trunkHeightHere;
        int offX = Math.round(outFrac * MathHelper.func_76134_b((float)trunkYaw));
        int offZ = Math.round(outFrac * MathHelper.func_76126_a((float)trunkYaw));
        return basePos.func_177982_a(offX, Math.round(upFrac), offZ);
    }

    private boolean isSolidWood(BlockState state) {
        return state.func_200132_m() && state.func_235714_a_((ITag)BlockTags.field_200031_h);
    }
}

