/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.gen.tree;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.IntPredicate;
import lotr.common.LOTRLog;
import lotr.common.world.gen.tree.LOTRTreeDecorators;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.World;
import net.minecraft.world.gen.treedecorator.TreeDecorator;
import net.minecraft.world.gen.treedecorator.TreeDecoratorType;
import net.minecraftforge.common.ToolType;

public class PineStripDecorator
extends TreeDecorator {
    public static final Codec<PineStripDecorator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").forGetter(deco -> Float.valueOf(deco.prob)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("strip_begin_height_fraction").forGetter(deco -> Float.valueOf(deco.stripBeginHeightFraction)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("strip_complete_height_fraction").forGetter(deco -> Float.valueOf(deco.stripCompleteHeightFraction))).apply((Applicative)instance, PineStripDecorator::new));
    private final float prob;
    private final float stripBeginHeightFraction;
    private final float stripCompleteHeightFraction;

    public PineStripDecorator(float f, float s0, float s1) {
        this.prob = f;
        this.stripBeginHeightFraction = s0;
        this.stripCompleteHeightFraction = s1;
    }

    protected TreeDecoratorType<?> func_230380_a_() {
        return LOTRTreeDecorators.PINE_STRIP;
    }

    public void func_225576_a_(ISeedReader world, Random rand, List<BlockPos> trunk, List<BlockPos> leaves, Set<BlockPos> decoSet, MutableBoundingBox bb) {
        if (rand.nextFloat() < this.prob) {
            int trunkBase = trunk.get(0).func_177956_o();
            int trunkHeight = trunk.size();
            int stripBeginY = Math.round((float)trunkHeight * this.stripBeginHeightFraction);
            int stripCompleteY = Math.round((float)trunkHeight * this.stripCompleteHeightFraction);
            IntPredicate stripTest = y -> {
                int yRel = y - trunkBase;
                if (yRel < stripBeginY) {
                    return false;
                }
                if (yRel >= stripCompleteY) {
                    return true;
                }
                return rand.nextFloat() < (float)(yRel - stripBeginY + 1) / (float)(stripCompleteY - stripBeginY + 1);
            };
            this.stripWood(world, trunk, stripTest, bb);
            this.stripWood(world, decoSet, stripTest, bb);
        }
    }

    private void stripWood(ISeedReader world, Collection<BlockPos> posCollection, IntPredicate stripTest, MutableBoundingBox bb) {
        HashSet temp = new HashSet();
        for (BlockPos pos : posCollection) {
            if (!stripTest.test(pos.func_177956_o())) continue;
            BlockState state = world.func_180495_p(pos);
            try {
                BlockState strippedState = state.getToolModifiedState((World)world.func_201672_e(), pos, null, ItemStack.field_190927_a, ToolType.AXE);
                if (strippedState == null) continue;
                this.func_227423_a_((IWorldWriter)world, pos, strippedState, temp, bb);
            }
            catch (Exception e) {
                LOTRLog.error("PineStripDecorator caught an exception while trying to obtain the stripped state of blockstate %s - not altering the blockstate", state.toString());
                e.printStackTrace();
            }
        }
    }
}

