/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.map;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import lotr.common.LOTRLog;
import lotr.common.block.CustomWaypointMarkerBlock;
import lotr.common.block.LOTRBlockMaterial;
import lotr.common.data.LOTRLevelData;
import lotr.common.init.LOTRBlocks;
import lotr.common.init.LOTRDimensions;
import lotr.common.init.LOTRTags;
import lotr.common.tileentity.CustomWaypointMarkerTileEntity;
import lotr.common.util.LOTRUtil;
import lotr.common.util.UsernameHelper;
import lotr.common.world.map.AbstractCustomWaypoint;
import lotr.common.world.map.CustomWaypoint;
import lotr.common.world.map.MapSettingsManager;
import lotr.common.world.map.MapWaypoint;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FireBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.FilledMapItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.state.properties.Half;
import net.minecraft.state.properties.SlabType;
import net.minecraft.state.properties.StairsShape;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.MapData;

public class CustomWaypointStructureHandler {
    public static final CustomWaypointStructureHandler INSTANCE = new CustomWaypointStructureHandler();
    private static final int SPAWN_EXCLUSION_RADIUS = 500;
    private static final int MAP_WAYPOINT_EXCLUSION_RADIUS = 200;
    private Map<UUID, BlockPos> playersClickedOnBlocksToCreate = new HashMap<UUID, BlockPos>();
    private Map<UUID, Long> playersSentProtectionMessageTimes = new HashMap<UUID, Long>();
    private static final int PROTECTION_MESSAGE_INTERVAL_MILLIS = 3000;

    private CustomWaypointStructureHandler() {
    }

    public boolean isFocalPoint(World world, BlockPos focalPos) {
        if (this.isCorrectDimension(world)) {
            return this.isValidCentrepiece(world, focalPos);
        }
        return false;
    }

    public boolean isFocalPointOfCompletableStructure(ServerWorld world, BlockPos focalPos) {
        return this.isFocalPointOfCompletableStructure(world, focalPos, text -> {});
    }

    public boolean isFocalPointOfCompletableStructure(ServerWorld world, BlockPos focalPos, Consumer<ITextComponent> messageCallback) {
        if (this.isTooCloseToExistingCustomWaypoint((World)world, focalPos, true)) {
            messageCallback.accept((ITextComponent)new TranslationTextComponent("chat.lotr.cwp.structure.tooClose.otherCustomWaypoint"));
            return false;
        }
        if (this.isTooCloseToSpawnOrMapWaypoint(world, focalPos, messageCallback)) {
            return false;
        }
        if (this.isFocalPointOfValidStructure((World)world, focalPos, messageCallback)) {
            return this.hasValidMapOnFocalPoint((World)world, focalPos, messageCallback);
        }
        return false;
    }

    private boolean isFocalPointOfValidStructure(World world, BlockPos focalPos, Consumer<ITextComponent> messageCallback) {
        if (this.isFocalPoint(world, focalPos)) {
            List<BlockPos> boundsToCheckEmpty = this.streamPositionsInBoundingBox(focalPos).collect(Collectors.toList());
            boundsToCheckEmpty.remove(focalPos);
            if (!(this.testForBlock(world, focalPos.func_177984_a(), boundsToCheckEmpty, this::isValidPillar) && this.testForBlock(world, focalPos.func_177977_b(), boundsToCheckEmpty, this::isValidPillar) && this.testForBlock(world, focalPos.func_177979_c(2), boundsToCheckEmpty, this::isValidPillar))) {
                messageCallback.accept((ITextComponent)new TranslationTextComponent("chat.lotr.cwp.structure.invalid.pillar"));
                return false;
            }
            if (!this.testForBlock(world, focalPos.func_177981_b(2), boundsToCheckEmpty, this::isValidTopLight)) {
                messageCallback.accept((ITextComponent)new TranslationTextComponent("chat.lotr.cwp.structure.invalid.light"));
                return false;
            }
            BlockPos buttressCentre = focalPos.func_177979_c(2);
            if (!(this.testForBlock(world, buttressCentre.func_177978_c(), boundsToCheckEmpty, this.testValidButtress(Direction.SOUTH)) && this.testForBlock(world, buttressCentre.func_177968_d(), boundsToCheckEmpty, this.testValidButtress(Direction.NORTH)) && this.testForBlock(world, buttressCentre.func_177976_e(), boundsToCheckEmpty, this.testValidButtress(Direction.EAST)) && this.testForBlock(world, buttressCentre.func_177974_f(), boundsToCheckEmpty, this.testValidButtress(Direction.WEST)))) {
                messageCallback.accept((ITextComponent)new TranslationTextComponent("chat.lotr.cwp.structure.invalid.buttress"));
                return false;
            }
            BlockPos crownCentre = focalPos.func_177981_b(1);
            if (!(this.testForBlock(world, crownCentre.func_177978_c(), boundsToCheckEmpty, this.testValidCrown(Direction.SOUTH)) && this.testForBlock(world, crownCentre.func_177968_d(), boundsToCheckEmpty, this.testValidCrown(Direction.NORTH)) && this.testForBlock(world, crownCentre.func_177976_e(), boundsToCheckEmpty, this.testValidCrown(Direction.EAST)) && this.testForBlock(world, crownCentre.func_177974_f(), boundsToCheckEmpty, this.testValidCrown(Direction.WEST)))) {
                messageCallback.accept((ITextComponent)new TranslationTextComponent("chat.lotr.cwp.structure.invalid.crown"));
                return false;
            }
            boolean validBase = this.streamPositionsInSolidBase(focalPos).allMatch(pos -> this.isValidBase(world, (BlockPos)pos));
            if (!validBase) {
                messageCallback.accept((ITextComponent)new TranslationTextComponent("chat.lotr.cwp.structure.invalid.base"));
                return false;
            }
            List boundsNotEmpty = boundsToCheckEmpty.stream().filter(pos -> !this.isEmptyBlockForBounds(world, (BlockPos)pos)).collect(Collectors.toList());
            if (!boundsNotEmpty.isEmpty()) {
                messageCallback.accept((ITextComponent)new TranslationTextComponent("chat.lotr.cwp.structure.invalid.notEmpty", new Object[]{boundsNotEmpty.size()}));
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean isCorrectDimension(World world) {
        return LOTRDimensions.isDimension(world, LOTRDimensions.MIDDLE_EARTH_WORLD_KEY);
    }

    private boolean isTooCloseToSpawnOrMapWaypoint(ServerWorld world, BlockPos focalPos, Consumer<ITextComponent> messageCallback) {
        BlockPos spawnPoint = LOTRDimensions.getDimensionSpawnPoint(world);
        if (focalPos.func_218141_a((Vector3i)spawnPoint, 500.0)) {
            messageCallback.accept((ITextComponent)new TranslationTextComponent("chat.lotr.cwp.structure.tooClose.spawn"));
            return true;
        }
        List mapWaypointsTooClose = MapSettingsManager.sidedInstance((IWorldReader)world).getCurrentLoadedMap().getWaypoints().stream().filter(wp -> {
            double dz;
            double dx = wp.getWorldX() - focalPos.func_177958_n();
            double dSq = dx * dx + (dz = (double)(wp.getWorldZ() - focalPos.func_177952_p())) * dz;
            return dSq < 40000.0;
        }).collect(Collectors.toList());
        if (!mapWaypointsTooClose.isEmpty()) {
            messageCallback.accept((ITextComponent)new TranslationTextComponent("chat.lotr.cwp.structure.tooClose.mapWaypoint", new Object[]{((MapWaypoint)mapWaypointsTooClose.get(0)).getDisplayName()}));
            return true;
        }
        return false;
    }

    private boolean isTooCloseToExistingCustomWaypoint(World world, BlockPos pos, boolean checkPosWithWaypointBounds) {
        MutableBoundingBox thisBb = checkPosWithWaypointBounds ? this.getBoundingBoxForProtection(pos) : new MutableBoundingBox((Vector3i)pos, (Vector3i)pos);
        int maxWaypointBoundsRange = 2;
        int chunkX0 = thisBb.field_78897_a - maxWaypointBoundsRange >> 4;
        int chunkX1 = thisBb.field_78893_d + maxWaypointBoundsRange >> 4;
        int chunkZ0 = thisBb.field_78896_c - maxWaypointBoundsRange >> 4;
        int chunkZ1 = thisBb.field_78892_f + maxWaypointBoundsRange >> 4;
        for (int chunkX = chunkX0; chunkX <= chunkX1; ++chunkX) {
            for (int chunkZ = chunkZ0; chunkZ <= chunkZ1; ++chunkZ) {
                Chunk chunk = world.func_212866_a_(chunkX, chunkZ);
                for (Map.Entry entry : chunk.func_177434_r().entrySet()) {
                    BlockState state;
                    Direction markerFacing;
                    BlockPos markerFocalPos;
                    MutableBoundingBox existingWaypointBb;
                    BlockPos tePos = (BlockPos)entry.getKey();
                    TileEntity te = (TileEntity)entry.getValue();
                    if (!(te instanceof CustomWaypointMarkerTileEntity) || !(existingWaypointBb = this.getBoundingBoxForProtection(markerFocalPos = tePos.func_177972_a((markerFacing = (Direction)(state = world.func_180495_p(tePos)).func_177229_b((Property)CustomWaypointMarkerBlock.FACING)).func_176734_d()))).func_78884_a(thisBb)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean hasValidMapOnFocalPoint(World world, BlockPos focalPos, Consumer<ITextComponent> messageCallback) {
        return this.getValidMapOnFocalPoint(world, focalPos, messageCallback).isPresent();
    }

    private Optional<ItemFrameEntity> getValidMapOnFocalPoint(World world, BlockPos focalPos, Consumer<ITextComponent> messageCallback) {
        List attachedFrames = world.func_175647_a(ItemFrameEntity.class, new AxisAlignedBB(focalPos).func_186662_g(1.0), frame -> CustomWaypointStructureHandler.getItemFrameSupportPos(frame).equals((Object)focalPos));
        if (attachedFrames.isEmpty()) {
            messageCallback.accept((ITextComponent)new TranslationTextComponent("chat.lotr.cwp.structure.frame"));
            return Optional.empty();
        }
        if ((attachedFrames = attachedFrames.stream().filter(frame -> frame.func_82335_i().func_77973_b() == Items.field_151098_aY).collect(Collectors.toList())).isEmpty()) {
            messageCallback.accept((ITextComponent)new TranslationTextComponent("chat.lotr.cwp.structure.map.required"));
            return Optional.empty();
        }
        if ((attachedFrames = attachedFrames.stream().filter(frame -> this.doesMapIncludePosition(world, this.getMapDataFromFrame((ItemFrameEntity)frame), focalPos)).collect(Collectors.toList())).isEmpty()) {
            messageCallback.accept((ITextComponent)new TranslationTextComponent("chat.lotr.cwp.structure.map.wrongArea"));
            return Optional.empty();
        }
        if ((attachedFrames = attachedFrames.stream().filter(frame -> this.isMapScaleLargeEnough(this.getMapDataFromFrame((ItemFrameEntity)frame))).collect(Collectors.toList())).isEmpty()) {
            messageCallback.accept((ITextComponent)new TranslationTextComponent("chat.lotr.cwp.structure.map.tooSmall"));
            return Optional.empty();
        }
        if ((attachedFrames = attachedFrames.stream().filter(frame -> this.isMapSufficientlyExplored(this.getMapDataFromFrame((ItemFrameEntity)frame))).collect(Collectors.toList())).isEmpty()) {
            messageCallback.accept((ITextComponent)new TranslationTextComponent("chat.lotr.cwp.structure.map.notExplored"));
            return Optional.empty();
        }
        return Optional.of(attachedFrames.get(0));
    }

    public static BlockPos getItemFrameSupportPos(ItemFrameEntity frame) {
        return frame.func_174857_n().func_177972_a(frame.func_174811_aO().func_176734_d());
    }

    private Stream<BlockPos> streamPositionsInBoundingBox(BlockPos focalPos) {
        return BlockPos.func_229383_a_((MutableBoundingBox)this.getMainBoundingBox(focalPos)).map(BlockPos::func_185334_h);
    }

    private Stream<BlockPos> streamPositionsInSolidBase(BlockPos focalPos) {
        return BlockPos.func_229383_a_((MutableBoundingBox)this.getSolidBaseBoundingBox(focalPos)).map(BlockPos::func_185334_h);
    }

    private MutableBoundingBox getMainBoundingBox(BlockPos focalPos) {
        int x = focalPos.func_177958_n();
        int y = focalPos.func_177956_o();
        int z = focalPos.func_177952_p();
        return new MutableBoundingBox(x - 2, y - 2, z - 2, x + 2, y + 2, z + 2);
    }

    private MutableBoundingBox getSolidBaseBoundingBox(BlockPos focalPos) {
        int baseY = focalPos.func_177956_o() - 3;
        int x = focalPos.func_177958_n();
        int z = focalPos.func_177952_p();
        return new MutableBoundingBox(x - 2, baseY, z - 2, x + 2, baseY, z + 2);
    }

    private MutableBoundingBox getBoundingBoxForProtection(BlockPos focalPos) {
        MutableBoundingBox bb = this.getMainBoundingBox(focalPos);
        bb.func_78888_b(this.getSolidBaseBoundingBox(focalPos));
        ++bb.field_78894_e;
        return bb;
    }

    private boolean testForBlock(World world, BlockPos pos, List<BlockPos> boundsToCheckEmpty, BiPredicate<World, BlockPos> tester) {
        if (tester.test(world, pos)) {
            boundsToCheckEmpty.remove(pos);
            return true;
        }
        return false;
    }

    private boolean isValidCentrepiece(World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        return state.func_235714_a_(LOTRTags.Blocks.CUSTOM_WAYPOINT_CENTERPIECES);
    }

    private boolean isValidPillar(World world, BlockPos pos) {
        return this.isValidBase(world, pos);
    }

    private boolean isValidTopLight(World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        if (state.getLightValue((IBlockReader)world, pos) >= 8) {
            return true;
        }
        BlockPos abovePos = pos.func_177984_a();
        BlockState aboveState = world.func_180495_p(abovePos);
        return aboveState.func_177230_c() == state.func_177230_c() && aboveState.getLightValue((IBlockReader)world, abovePos) >= 8;
    }

    private BiPredicate<World, BlockPos> testValidButtress(Direction facing) {
        return (world, pos) -> {
            BlockState state = world.func_180495_p(pos);
            if (this.isValidStoneOrSimilarMaterial(state) && state.func_177230_c() instanceof StairsBlock) {
                return state.func_177229_b((Property)StairsBlock.field_176309_a) == facing && state.func_177229_b((Property)StairsBlock.field_176308_b) == Half.BOTTOM && state.func_177229_b((Property)StairsBlock.field_176310_M) == StairsShape.STRAIGHT;
            }
            return this.testSidewaysStoneSlab(facing).test((World)world, (BlockPos)pos);
        };
    }

    private BiPredicate<World, BlockPos> testSidewaysStoneSlab(Direction facing) {
        return (world, pos) -> {
            Optional<Property> optAxialSlabProperty;
            BlockState state = world.func_180495_p(pos);
            if (this.isValidStoneOrSimilarMaterial(state) && state.func_177230_c() instanceof SlabBlock && (optAxialSlabProperty = state.func_235904_r_().stream().filter(property -> {
                if (property.func_177699_b() == Direction.Axis.class) {
                    Collection propertyValues = property.func_177700_c();
                    return propertyValues.contains(Direction.Axis.X) && propertyValues.contains(Direction.Axis.Z);
                }
                return false;
            }).findFirst()).isPresent()) {
                Property axialSlabProperty = optAxialSlabProperty.get();
                SlabType expectedSlabType = facing.func_176743_c() == Direction.AxisDirection.NEGATIVE ? SlabType.BOTTOM : SlabType.TOP;
                return state.func_177229_b(axialSlabProperty) == facing.func_176740_k() && state.func_177229_b((Property)SlabBlock.field_196505_a) == expectedSlabType;
            }
            return false;
        };
    }

    private BiPredicate<World, BlockPos> testValidCrown(Direction facing) {
        return (world, pos) -> this.isEmptyBlockForBounds((World)world, (BlockPos)pos) || this.testSidewaysStoneSlab(facing).test((World)world, (BlockPos)pos) || this.testSidewaysHangingTrapdoor(facing).test((World)world, (BlockPos)pos);
    }

    private BiPredicate<World, BlockPos> testSidewaysHangingTrapdoor(Direction facing) {
        return (world, pos) -> {
            BlockState state = world.func_180495_p(pos);
            if (state.func_177230_c() instanceof TrapDoorBlock) {
                return state.func_177229_b((Property)TrapDoorBlock.field_185512_D) == facing.func_176734_d() && (Boolean)state.func_177229_b((Property)TrapDoorBlock.field_176283_b) != false;
            }
            return false;
        };
    }

    private boolean isValidBase(World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        return this.isValidStoneOrSimilarMaterial(state) && state.func_200015_d((IBlockReader)world, pos);
    }

    private boolean isValidStoneOrSimilarMaterial(BlockState state) {
        Material material = state.func_185904_a();
        if (material == Material.field_151576_e || material == LOTRBlockMaterial.ICE_BRICK || material == LOTRBlockMaterial.SNOW_BRICK) {
            return true;
        }
        Block block = state.func_177230_c();
        return block == Blocks.field_189880_di;
    }

    private boolean isEmptyBlockForBounds(World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        return state.func_204520_s().func_206886_c() == Fluids.field_204541_a && state.func_196951_e((IBlockReader)world, pos).func_197766_b() && !(state.func_177230_c() instanceof FireBlock);
    }

    private MapData getMapDataFromFrame(ItemFrameEntity frame) {
        return FilledMapItem.func_219994_a((ItemStack)frame.func_82335_i(), (World)frame.field_70170_p);
    }

    private boolean doesMapIncludePosition(World world, MapData mapData, BlockPos pos) {
        if (LOTRDimensions.isDimension(world, (RegistryKey<World>)mapData.field_76200_c)) {
            int scaleFactor = 1 << mapData.field_76197_d;
            int halfMapWidth = 64;
            return Math.abs(pos.func_177958_n() - mapData.field_76201_a) <= (halfMapWidth *= scaleFactor) && Math.abs(pos.func_177952_p() - mapData.field_76199_b) <= halfMapWidth;
        }
        return false;
    }

    private boolean isMapScaleLargeEnough(MapData mapData) {
        return mapData.field_76197_d >= 1;
    }

    private boolean isMapSufficientlyExplored(MapData mapData) {
        int counted = 0;
        int empty = 0;
        for (byte c : mapData.field_76198_e) {
            ++counted;
            if (c != 0) continue;
            ++empty;
        }
        float emptyFraction = (float)empty / (float)counted;
        return emptyFraction < 0.05f;
    }

    public void setPlayerClickedOnBlockToCreate(PlayerEntity player, BlockPos pos) {
        this.playersClickedOnBlocksToCreate.put(player.func_110124_au(), pos.func_185334_h());
    }

    public BlockPos getPlayerClickedOnBlockToCreate(PlayerEntity player) {
        return this.playersClickedOnBlocksToCreate.get(player.func_110124_au());
    }

    public void clearPlayerClickedOnBlockToCreate(PlayerEntity player) {
        this.playersClickedOnBlocksToCreate.remove(player.func_110124_au());
    }

    public void completeStructureWithCreatedWaypoint(PlayerEntity player, CustomWaypoint waypoint) {
        World world = player.field_70170_p;
        BlockPos waypointPos = waypoint.getPosition();
        Optional<ItemFrameEntity> frameOpt = this.getValidMapOnFocalPoint(world, waypointPos, text -> {});
        if (frameOpt.isPresent()) {
            ItemFrameEntity frame = frameOpt.get();
            BlockPos offsetPos = frame.func_174857_n();
            Direction frameDir = frame.func_174811_aO();
            world.func_175656_a(offsetPos, (BlockState)((Block)LOTRBlocks.CUSTOM_WAYPOINT_MARKER.get()).func_176223_P().func_206870_a((Property)CustomWaypointMarkerBlock.FACING, (Comparable)frameDir));
            TileEntity te = world.func_175625_s(offsetPos);
            if (te instanceof CustomWaypointMarkerTileEntity) {
                CustomWaypointMarkerTileEntity marker = (CustomWaypointMarkerTileEntity)te;
                marker.absorbItemFrame(frame);
                marker.setWaypointReference(waypoint);
                this.spawnParticles(world, waypointPos);
            } else {
                LOTRLog.error("Player %s created a custom waypoint at (%s) - but somehow the tile entity was not created!", UsernameHelper.getRawUsername(player), waypointPos);
            }
        } else {
            LOTRLog.warn("Player %s created a custom waypoint at (%s) where a valid item frame should exist, but didn't!", UsernameHelper.getRawUsername(player), waypointPos);
        }
    }

    private void spawnParticles(World world, BlockPos waypointPos) {
        if (world instanceof ServerWorld) {
            ServerWorld sWorld = (ServerWorld)world;
            this.streamPositionsInSolidBase(waypointPos).forEach(pos -> {
                BlockPos abovePos = pos.func_177984_a();
                if (world.func_175623_d(abovePos)) {
                    int count = 0;
                    double speed = 0.12;
                    sWorld.func_195598_a((IParticleData)ParticleTypes.field_197598_I, (double)abovePos.func_177958_n() + 0.5, (double)abovePos.func_177956_o() + 0.1, (double)abovePos.func_177952_p() + 0.5, count, 0.0, 1.0, 0.0, speed);
                }
            });
        }
    }

    public void updateWaypointStructure(PlayerEntity player, CustomWaypoint waypoint) {
        World world = player.field_70170_p;
        BlockPos waypointPos = waypoint.getPosition();
        CustomWaypointMarkerTileEntity marker = this.getAdjacentWaypointMarker(world, waypointPos, waypoint);
        if (marker != null) {
            marker.updateWaypointReference(waypoint);
            this.spawnParticles(world, waypointPos);
        } else {
            LOTRLog.error("Player %s tried to update a custom waypoint at (%s) - but somehow the tile entity does not exist!", UsernameHelper.getRawUsername(player), waypointPos);
        }
    }

    public void adoptWaypointStructure(PlayerEntity player, CustomWaypoint waypoint) {
        World world = player.field_70170_p;
        BlockPos waypointPos = waypoint.getPosition();
        this.spawnParticles(world, waypointPos);
    }

    public boolean hasAdjacentWaypointMarker(World world, BlockPos focalPos) {
        return this.getAdjacentWaypointMarker(world, focalPos, null) != null;
    }

    public CustomWaypointMarkerTileEntity getAdjacentWaypointMarker(World world, BlockPos focalPos, @Nullable AbstractCustomWaypoint waypointToValidate) {
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            TileEntity te;
            BlockPos offsetPos = focalPos.func_177972_a(dir);
            BlockState state = world.func_180495_p(offsetPos);
            if (state.func_177230_c() != LOTRBlocks.CUSTOM_WAYPOINT_MARKER.get() || !((te = world.func_175625_s(offsetPos)) instanceof CustomWaypointMarkerTileEntity)) continue;
            CustomWaypointMarkerTileEntity marker = (CustomWaypointMarkerTileEntity)te;
            if (waypointToValidate != null && !marker.matchesWaypointReference(waypointToValidate)) continue;
            return marker;
        }
        return null;
    }

    public boolean isCompletedWaypointStillValidStructure(World world, BlockPos focalPos) {
        return this.isFocalPointOfValidStructure(world, focalPos, text -> {});
    }

    public boolean isProtectedByWaypointStructure(World world, BlockPos pos, PlayerEntity player) {
        if (!player.field_71075_bZ.field_75098_d && this.isProtectedByWaypointStructure(world, pos)) {
            long lastMessagedTime;
            long currentTime = System.currentTimeMillis();
            if (currentTime - (lastMessagedTime = this.playersSentProtectionMessageTimes.getOrDefault(player.func_110124_au(), 0L).longValue()) >= 3000L) {
                LOTRUtil.sendMessage(player, (ITextComponent)new TranslationTextComponent("chat.lotr.cwp.protected"));
                this.playersSentProtectionMessageTimes.put(player.func_110124_au(), currentTime);
            }
            if (player instanceof ServerPlayerEntity) {
                ServerPlayerEntity serverPlayer = (ServerPlayerEntity)player;
                serverPlayer.func_71120_a((Container)serverPlayer.field_71069_bz);
            }
            return true;
        }
        return false;
    }

    public boolean isProtectedByWaypointStructure(World world, BlockPos pos) {
        return this.isTooCloseToExistingCustomWaypoint(world, pos, false);
    }

    public boolean checkCompletedWaypointHasMarkerAndHandleIfNot(World world, AbstractCustomWaypoint waypoint, PlayerEntity player) {
        BlockPos waypointPos = waypoint.getPosition();
        CustomWaypointMarkerTileEntity marker = this.getAdjacentWaypointMarker(world, waypointPos, waypoint);
        if (marker == null) {
            waypoint.removeFromPlayerData(player);
            LOTRUtil.sendMessage(player, (ITextComponent)new TranslationTextComponent("chat.lotr.cwp.missing", new Object[]{waypoint.getDisplayName()}).func_240699_a_(TextFormatting.RED));
            return false;
        }
        return true;
    }

    public boolean destroyCustomWaypointMarkerAndRemoveFromPlayerData(World world, CustomWaypoint waypoint, PlayerEntity player, boolean destroyWholeStructure) {
        BlockPos waypointPos = waypoint.getPosition();
        CustomWaypointMarkerTileEntity marker = this.getAdjacentWaypointMarker(world, waypointPos, waypoint);
        if (marker != null) {
            if (LOTRLevelData.sidedInstance((IWorldReader)world).getData(player).getFastTravelData().removeCustomWaypoint(world, waypoint)) {
                world.func_175656_a(marker.func_174877_v(), Blocks.field_150350_a.func_176223_P());
                if (destroyWholeStructure) {
                    Stream.concat(this.streamPositionsInBoundingBox(waypointPos).filter(pos -> !world.func_175623_d(pos)), this.streamPositionsInSolidBase(waypointPos).filter(pos -> world.field_73012_v.nextInt(4) == 0)).forEach(pos -> this.destroyBlockWithDrops(world, (BlockPos)pos, player));
                }
                return true;
            }
            return false;
        }
        LOTRLog.warn("Tried to destroy a custom waypoint %s for player %s at (%s) but no matching marker block was found", waypoint.getRawName(), UsernameHelper.getRawUsername(player), waypointPos);
        return false;
    }

    private boolean destroyBlockWithDrops(World world, BlockPos pos, PlayerEntity player) {
        BlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        TileEntity te = world.func_175625_s(pos);
        boolean canHarvest = true;
        boolean removed = state.removedByPlayer(world, pos, player, canHarvest, world.func_204610_c(pos));
        if (removed) {
            state.func_177230_c().func_176206_d((IWorld)world, pos, state);
            block.func_180657_a(world, player, pos, state, te, ItemStack.field_190927_a);
        }
        return removed;
    }

    @Nullable
    public BlockPos findRandomTravelPositionForCompletedWaypoint(World world, AbstractCustomWaypoint waypoint, PlayerEntity player) {
        BlockPos waypointPos = waypoint.getPosition();
        if (!this.checkCompletedWaypointHasMarkerAndHandleIfNot(world, waypoint, player)) {
            LOTRLog.warn("Player %s tried to travel to a custom waypoint (%s, %s) that isn't a complete structure!", UsernameHelper.getRawUsername(player), waypoint.getRawName(), waypointPos);
            return null;
        }
        List safePositions = this.streamPositionsInBoundingBox(waypointPos).filter(pos -> {
            BlockPos belowPos = pos.func_177977_b();
            return world.func_180495_p(pos.func_177977_b()).func_224755_d((IBlockReader)world, belowPos, Direction.UP) && this.isEmptyBlockForBounds(world, (BlockPos)pos) && this.isEmptyBlockForBounds(world, pos.func_177984_a());
        }).collect(Collectors.toList());
        if (safePositions.isEmpty()) {
            LOTRLog.warn("Player %s tried to travel to a custom waypoint (%s, %s) but couldn't find any safe positions!", UsernameHelper.getRawUsername(player), waypoint.getRawName(), waypointPos);
            return waypointPos;
        }
        return (BlockPos)safePositions.get(world.field_73012_v.nextInt(safePositions.size()));
    }
}

