/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.map;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import lotr.common.LOTRLog;
import lotr.common.world.map.GeneratedRoadPoint;
import lotr.common.world.map.MapSettings;
import lotr.common.world.map.Road;
import lotr.common.world.map.RoadPoint;
import lotr.common.world.map.RoadPointCache;
import lotr.common.world.map.RoadSection;
import lotr.common.world.map.RouteRoadPoint;

public class RoadCurveGenerator {
    private static final float ROAD_LENGTH_FACTOR = 1.0f;

    public static List<RoadSection> generateSplines(MapSettings map, Road road, List<RouteRoadPoint> controlPoints, RoadPointCache roadPointCache) {
        if (controlPoints.isEmpty() || controlPoints.size() == 1) {
            LOTRLog.warn("Road %s has only %d control points - a road requires at least 2!", road.getName(), controlPoints.size());
            return ImmutableList.of();
        }
        if (controlPoints.size() == 2) {
            RouteRoadPoint p1 = controlPoints.get(0);
            RouteRoadPoint p2 = controlPoints.get(1);
            double dx = p2.getMapX() - p1.getMapX();
            double dz = p2.getMapZ() - p1.getMapZ();
            int roadLength = map.mapToWorldDistance(Math.sqrt(dx * dx + dz * dz));
            int numPoints = Math.round((float)roadLength * 1.0f);
            GeneratedRoadPoint[] points = new GeneratedRoadPoint[numPoints];
            for (int l = 0; l < numPoints; ++l) {
                GeneratedRoadPoint point;
                double t = (double)l / (double)numPoints;
                points[l] = point = new GeneratedRoadPoint(map, road, p1.getMapX() + dx * t, p1.getMapZ() + dz * t);
                roadPointCache.add(point);
            }
            RoadSection section = new RoadSection(road, p1, p2, points);
            return Arrays.asList(section);
        }
        int length = controlPoints.size();
        double[] x = new double[length];
        double[] z = new double[length];
        for (int i = 0; i < length; ++i) {
            x[i] = controlPoints.get(i).getMapX();
            z[i] = controlPoints.get(i).getMapZ();
        }
        double[][] controlX = RoadCurveGenerator.calculateControlPoints(x);
        double[][] controlZ = RoadCurveGenerator.calculateControlPoints(z);
        int numControlPoints = controlX[0].length;
        GeneratedRoadPoint[] controlPoints1 = new GeneratedRoadPoint[numControlPoints];
        GeneratedRoadPoint[] controlPoints2 = new GeneratedRoadPoint[numControlPoints];
        for (int i = 0; i < numControlPoints; ++i) {
            GeneratedRoadPoint p1 = new GeneratedRoadPoint(map, road, controlX[0][i], controlZ[0][i]);
            GeneratedRoadPoint p2 = new GeneratedRoadPoint(map, road, controlX[1][i], controlZ[1][i]);
            controlPoints1[i] = p1;
            controlPoints2[i] = p2;
        }
        RoadSection[] sections = new RoadSection[length - 1];
        for (int i = 0; i < sections.length; ++i) {
            RouteRoadPoint p1 = controlPoints.get(i);
            RouteRoadPoint p2 = controlPoints.get(i + 1);
            GeneratedRoadPoint cp1 = controlPoints1[i];
            GeneratedRoadPoint cp2 = controlPoints2[i];
            double dx = p2.getMapX() - p1.getMapX();
            double dz = p2.getMapZ() - p1.getMapZ();
            int roadLength = map.mapToWorldDistance(Math.sqrt(dx * dx + dz * dz));
            int numPoints = Math.round((float)roadLength * 1.0f);
            GeneratedRoadPoint[] points = new GeneratedRoadPoint[numPoints];
            for (int l = 0; l < numPoints; ++l) {
                GeneratedRoadPoint point;
                double t = (double)l / (double)numPoints;
                points[l] = point = RoadCurveGenerator.bezier(map, road, p1, cp1, cp2, p2, t);
                roadPointCache.add(point);
            }
            sections[i] = new RoadSection(road, p1, p2, points);
        }
        return Arrays.asList(sections);
    }

    private static GeneratedRoadPoint lerp(MapSettings map, Road road, RoadPoint a, RoadPoint b, double t) {
        double x = a.getMapX() + (b.getMapX() - a.getMapX()) * t;
        double z = a.getMapZ() + (b.getMapZ() - a.getMapZ()) * t;
        return new GeneratedRoadPoint(map, road, x, z);
    }

    private static GeneratedRoadPoint bezier(MapSettings map, Road road, RoadPoint a, RoadPoint b, RoadPoint c, RoadPoint d, double t) {
        GeneratedRoadPoint ab = RoadCurveGenerator.lerp(map, road, a, b, t);
        GeneratedRoadPoint bc = RoadCurveGenerator.lerp(map, road, b, c, t);
        GeneratedRoadPoint cd = RoadCurveGenerator.lerp(map, road, c, d, t);
        GeneratedRoadPoint abbc = RoadCurveGenerator.lerp(map, road, ab, bc, t);
        GeneratedRoadPoint bccd = RoadCurveGenerator.lerp(map, road, bc, cd, t);
        return RoadCurveGenerator.lerp(map, road, abbc, bccd, t);
    }

    private static double[][] calculateControlPoints(double[] src) {
        int i;
        int length = src.length - 1;
        double[] p1 = new double[length];
        double[] p2 = new double[length];
        double[] a = new double[length];
        double[] b = new double[length];
        double[] c = new double[length];
        double[] r = new double[length];
        a[0] = 0.0;
        b[0] = 2.0;
        c[0] = 1.0;
        r[0] = src[0] + 2.0 * src[1];
        for (i = 1; i < length - 1; ++i) {
            a[i] = 1.0;
            b[i] = 4.0;
            c[i] = 1.0;
            r[i] = 4.0 * src[i] + 2.0 * src[i + 1];
        }
        a[length - 1] = 2.0;
        b[length - 1] = 7.0;
        c[length - 1] = 0.0;
        r[length - 1] = 8.0 * src[length - 1] + src[length];
        for (i = 1; i < length; ++i) {
            double m = a[i] / b[i - 1];
            b[i] = b[i] - m * c[i - 1];
            r[i] = r[i] - m * r[i - 1];
        }
        p1[length - 1] = r[length - 1] / b[length - 1];
        for (i = length - 2; i >= 0; --i) {
            double p;
            p1[i] = p = (r[i] - c[i] * p1[i + 1]) / b[i];
        }
        for (i = 0; i < length - 1; ++i) {
            p2[i] = 2.0 * src[i + 1] - p1[i + 1];
        }
        p2[length - 1] = 0.5 * (src[length] + p1[length - 1]);
        return new double[][]{p1, p2};
    }
}

