/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.map;

import javax.annotation.Nullable;
import lotr.common.world.map.SelectableMapObject;
import lotr.common.world.map.WaypointNetworkType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;

public interface Waypoint
extends SelectableMapObject {
    public String getRawName();

    public ITextComponent getDisplayName();

    @Nullable
    public ITextComponent getDisplayLore();

    @Nullable
    public ITextComponent getDisplayOwnership();

    public double getMapX();

    public double getMapZ();

    @Override
    public int getWorldX();

    @Override
    public int getWorldZ();

    default public ITextComponent getCoordsText() {
        return new TranslationTextComponent("gui.lotr.map.coords", new Object[]{this.getWorldX(), this.getWorldZ()});
    }

    default public double getDistanceFromPlayer(PlayerEntity player) {
        Vector3d playerPos = player.func_213303_ch();
        double x = (double)this.getWorldX() + 0.5;
        double z = (double)this.getWorldZ() + 0.5;
        Vector3d pos = new Vector3d(x, playerPos.field_72448_b, z);
        return pos.func_72438_d(playerPos);
    }

    @Nullable
    public BlockPos getTravelPosition(ServerWorld var1, PlayerEntity var2);

    default public boolean verifyFastTravellable(ServerWorld world, PlayerEntity player) {
        return true;
    }

    public boolean hasPlayerUnlocked(PlayerEntity var1);

    public ITextComponent getNotUnlockedMessage(PlayerEntity var1);

    public boolean isCustom();

    public boolean isSharedCustom();

    public boolean isSharedHidden();

    public WaypointDisplayState getDisplayState(@Nullable PlayerEntity var1);

    public WaypointNetworkType<?> getNetworkType();

    @Override
    default public int getMapIconWidth() {
        return 6;
    }

    public static enum WaypointDisplayState {
        HIDDEN(0, 0),
        STANDARD(0, 200),
        STANDARD_LOCKED(6, 200),
        STANDARD_LOCKED_TO_ENEMIES(12, 200),
        STANDARD_CONQUERED(18, 200),
        CUSTOM(24, 200),
        CUSTOM_LOCKED(30, 200),
        SHARED_CUSTOM(36, 200),
        SHARED_CUSTOM_LOCKED(42, 200);

        public final int iconU;
        public final int iconV;
        public final int highlightIconU;
        public final int highlightIconV;

        private WaypointDisplayState(int u, int v) {
            this.iconU = u;
            this.iconV = v;
            this.highlightIconU = this.iconU;
            this.highlightIconV = this.iconV + 6;
        }

        public boolean isHidden() {
            return this == HIDDEN;
        }
    }
}

