/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.map;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import lotr.common.data.LOTRPlayerData;
import lotr.common.world.map.AdoptedCustomWaypoint;
import lotr.common.world.map.CustomWaypoint;
import lotr.common.world.map.MapWaypoint;
import lotr.common.world.map.Waypoint;
import net.minecraft.network.PacketBuffer;

public class WaypointNetworkType<T extends Waypoint> {
    private static final Map<Integer, WaypointNetworkType> TYPES = new HashMap<Integer, WaypointNetworkType>();
    public static final WaypointNetworkType<MapWaypoint> MAP = WaypointNetworkType.registerType(MapWaypoint::writeIdentification, MapWaypoint::readFromIdentification);
    public static final WaypointNetworkType<CustomWaypoint> CUSTOM = WaypointNetworkType.registerType(CustomWaypoint::writeIdentification, CustomWaypoint::readFromIdentification);
    public static final WaypointNetworkType<AdoptedCustomWaypoint> ADOPTED_CUSTOM = WaypointNetworkType.registerType(AdoptedCustomWaypoint::writeIdentification, AdoptedCustomWaypoint::readFromIdentification);
    private final int typeId;
    private final BiConsumer<PacketBuffer, T> identificationWriter;
    private final BiFunction<PacketBuffer, LOTRPlayerData, T> identificationReader;

    private static final <T extends Waypoint> WaypointNetworkType<T> registerType(BiConsumer<PacketBuffer, T> writer, BiFunction<PacketBuffer, LOTRPlayerData, T> reader) {
        int nextTypeId = TYPES.size();
        if (nextTypeId > 255) {
            throw new IllegalStateException("No more waypoint type IDs available!");
        }
        WaypointNetworkType<T> type = new WaypointNetworkType<T>(nextTypeId, writer, reader);
        TYPES.put(nextTypeId, type);
        return type;
    }

    private WaypointNetworkType(int id, BiConsumer<PacketBuffer, T> writer, BiFunction<PacketBuffer, LOTRPlayerData, T> reader) {
        this.typeId = id;
        this.identificationWriter = writer;
        this.identificationReader = reader;
    }

    public static void writeIdentification(PacketBuffer buf, Waypoint waypoint) {
        WaypointNetworkType<?> type = waypoint.getNetworkType();
        buf.writeByte(waypoint.getNetworkType().typeId);
        type.identificationWriter.accept(buf, (PacketBuffer)waypoint);
    }

    public static Waypoint readFromIdentification(PacketBuffer buf, LOTRPlayerData pd) {
        int typeId = buf.readByte() & 0xFF;
        WaypointNetworkType type = TYPES.get(typeId);
        if (type == null) {
            throw new IllegalStateException("Networking error - packet received unknown waypoint type ID " + typeId);
        }
        return (Waypoint)type.identificationReader.apply(buf, pd);
    }
}

