/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.spawning;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import lotr.common.LOTRLog;
import lotr.common.fac.FactionPointer;
import lotr.common.fac.FactionSettings;
import lotr.common.world.spawning.NPCSpawnEntry;
import lotr.common.world.spawning.NPCSpawnList;
import lotr.common.world.spawning.NPCSpawnSettings;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BiomeNPCSpawnList {
    private final ResourceLocation biomeName;
    private final List<FactionContainer> factionContainers;
    private final List<FactionPointer> presentFactions;
    private static final double DEFAULT_NPC_DENSITY = 1.0;
    private final double npcDensity;
    private static final boolean DEFAULT_ALLOW_DARKNESS_SPAWNS_IN_DAYTIME = false;
    private final boolean allowDarknessSpawnsInDaytime;
    private static final double DEFAULT_CONQUEST_GAIN_RATE = 1.0;
    private final double conquestGainRate;

    private BiomeNPCSpawnList(ResourceLocation biomeName, List<FactionContainer> factionContainers, double npcDensity, boolean allowDarknessSpawnsInDaytime, double conquestGainRate) {
        this.biomeName = biomeName;
        this.factionContainers = factionContainers;
        this.presentFactions = factionContainers.stream().map(FactionContainer::getFaction).distinct().collect(Collectors.toList());
        this.npcDensity = npcDensity;
        this.allowDarknessSpawnsInDaytime = allowDarknessSpawnsInDaytime;
        this.conquestGainRate = conquestGainRate;
    }

    public static BiomeNPCSpawnList createDefaultEmptyList(ResourceLocation biomeName) {
        return new BiomeNPCSpawnList(biomeName, (List<FactionContainer>)ImmutableList.of(), 1.0, false, 1.0);
    }

    public double getNPCDensity() {
        return this.npcDensity;
    }

    public boolean allowsDarknessSpawnsInDaytime() {
        return this.allowDarknessSpawnsInDaytime;
    }

    public boolean isFactionPresent(FactionPointer fac) {
        return this.presentFactions.contains(fac);
    }

    public NPCSpawnEntry.EntryInContext getRandomSpawnEntry(Random rand, World world, BlockPos pos) {
        int totalWeight = 0;
        HashMap<FactionContainer, Integer> cachedFacWeights = new HashMap<FactionContainer, Integer>();
        HashMap<FactionContainer, Float> cachedConqStrengths = new HashMap<FactionContainer, Float>();
        for (FactionContainer cont : this.factionContainers) {
            float conq;
            int weight;
            if (cont.isEmpty() || (weight = cont.getFactionWeight(conq = 0.0f)) <= 0) continue;
            totalWeight += weight;
            cachedFacWeights.put(cont, weight);
            cachedConqStrengths.put(cont, Float.valueOf(conq));
        }
        if (totalWeight > 0) {
            FactionContainer chosenFacContainer = null;
            boolean isConquestSpawn = false;
            int w = rand.nextInt(totalWeight);
            for (FactionContainer cont : this.factionContainers) {
                int facWeight;
                if (cont.isEmpty() || !cachedFacWeights.containsKey(cont) || (w -= (facWeight = ((Integer)cachedFacWeights.get(cont)).intValue())) >= 0) continue;
                chosenFacContainer = cont;
                if (facWeight <= cont.baseWeight) break;
                isConquestSpawn = rand.nextFloat() < (float)(facWeight - cont.baseWeight) / (float)facWeight;
                break;
            }
            if (chosenFacContainer != null) {
                float conq = ((Float)cachedConqStrengths.get(chosenFacContainer)).floatValue();
                SpawnListContainer spawnList = chosenFacContainer.getRandomSpawnList(rand, conq);
                if (spawnList == null || spawnList.spawnList == null) {
                    LOTRLog.error("WARNING anticipating NPE in biome %s, faction %s", this.biomeName, chosenFacContainer.getFaction().getName());
                }
                NPCSpawnEntry entry = spawnList.spawnList.getRandomSpawnEntry(rand);
                return new NPCSpawnEntry.EntryInContext(entry, isConquestSpawn);
            }
        }
        return null;
    }

    public List<NPCSpawnEntry> getAllSpawnEntries(World world) {
        ArrayList<NPCSpawnEntry> spawns = new ArrayList<NPCSpawnEntry>();
        for (FactionContainer facCont : this.factionContainers) {
            if (facCont.isEmpty()) continue;
            for (SpawnListContainer listCont : facCont.spawnLists) {
                NPCSpawnList list = listCont.spawnList;
                spawns.addAll(list.getReadOnlyList());
            }
        }
        return spawns;
    }

    public boolean containsEntityClassByDefault(Class<? extends Entity> desiredClass, World world) {
        for (FactionContainer facCont : this.factionContainers) {
            if (facCont.isEmpty() || facCont.isConquestOnlyFaction()) continue;
            for (SpawnListContainer listCont : facCont.spawnLists) {
                NPCSpawnList list = listCont.spawnList;
                for (NPCSpawnEntry e : list.getReadOnlyList()) {
                    if (!e.getAllPossibleTypes().anyMatch(entityType -> {
                        Entity proxyEntity = entityType.func_200721_a(world);
                        return desiredClass.isAssignableFrom(proxyEntity.getClass());
                    })) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static class SpawnListContainer {
        private final NPCSpawnList spawnList;
        private final int weight;
        private final float conquestThreshold = -1.0f;

        private SpawnListContainer(NPCSpawnList list, int w) {
            this.spawnList = list;
            this.weight = w;
        }

        public static SpawnListContainer read(NPCSpawnSettings spawnSettings, ResourceLocation resourceName, FactionPointer faction, JsonObject json) {
            ResourceLocation listName = new ResourceLocation(json.get("list").getAsString());
            NPCSpawnList list = spawnSettings.getSpawnListByName(listName);
            if (list == null) {
                LOTRLog.warn("Error loading biome NPC spawn list for %s - nonexistent NPC spawn list '%s' within faction spawn list %s", resourceName, listName, faction.getName());
                return null;
            }
            int weight = json.get("weight").getAsInt();
            return new SpawnListContainer(list, weight);
        }

        public boolean canSpawnAtConquestLevel(float conq) {
            return conq > -1.0f;
        }

        public boolean isConquestOnly() {
            return false;
        }
    }

    public static class FactionContainer {
        private final FactionPointer theConquestFaction;
        private final int baseWeight;
        private final List<SpawnListContainer> spawnLists;
        private static final float DEFAULT_CONQUEST_SENSITIVITY = 1.0f;
        private final float conquestSensitivity = 1.0f;

        private FactionContainer(FactionPointer fac, int w, List<SpawnListContainer> lists) {
            this.theConquestFaction = fac;
            this.baseWeight = w;
            this.spawnLists = lists;
        }

        public static FactionContainer read(NPCSpawnSettings spawnSettings, FactionSettings factionSettings, ResourceLocation resourceName, JsonObject json) {
            FactionPointer faction = FactionPointer.of(new ResourceLocation(json.get("faction").getAsString()));
            if (factionSettings.getFactionByPointer(faction) == null) {
                LOTRLog.warn("Error loading biome NPC spawn list for %s - nonexistent faction '%s'", resourceName, faction.getName());
                return null;
            }
            int baseWeight = json.get("base_weight").getAsInt();
            ArrayList<SpawnListContainer> spawnLists = new ArrayList<SpawnListContainer>();
            JsonArray spawnListsArray = json.get("lists").getAsJsonArray();
            for (JsonElement elem : spawnListsArray) {
                try {
                    SpawnListContainer spawnList = SpawnListContainer.read(spawnSettings, resourceName, faction, elem.getAsJsonObject());
                    if (spawnList == null) continue;
                    spawnLists.add(spawnList);
                }
                catch (Exception e) {
                    LOTRLog.warn("Error loading a spawn list within faction spawn list %s in biome NPC spawn list for %s", faction.getName(), resourceName);
                    e.printStackTrace();
                }
            }
            return new FactionContainer(faction, baseWeight, spawnLists);
        }

        public boolean isEmpty() {
            return this.spawnLists.isEmpty();
        }

        public FactionPointer getFaction() {
            return this.theConquestFaction;
        }

        public boolean isConquestOnlyFaction() {
            return this.baseWeight <= 0;
        }

        public int getFactionWeight(float conq) {
            if (conq > 0.0f) {
                float conqFactor = conq * 0.2f * 1.0f;
                return this.baseWeight + Math.round(conqFactor);
            }
            return this.baseWeight;
        }

        public SpawnListContainer getRandomSpawnList(Random rand, float conq) {
            int totalWeight = 0;
            for (SpawnListContainer cont : this.spawnLists) {
                if (!cont.canSpawnAtConquestLevel(conq)) continue;
                totalWeight += cont.weight;
            }
            if (totalWeight > 0) {
                SpawnListContainer chosenList = null;
                int w = rand.nextInt(totalWeight);
                for (SpawnListContainer cont : this.spawnLists) {
                    if (!cont.canSpawnAtConquestLevel(conq) || (w -= cont.weight) >= 0) continue;
                    chosenList = cont;
                    break;
                }
                return chosenList;
            }
            return null;
        }
    }

    public static class PreLoaded {
        private final ResourceLocation biomeName;
        private final ResourceLocation parentName;
        private final List<FactionContainer> factionContainers;
        private final Double npcDensity;
        private final Boolean allowDarknessSpawnsInDaytime;
        private final Double conquestGainRate;

        private PreLoaded(ResourceLocation biomeName, ResourceLocation parentName, List<FactionContainer> factionContainers, Double npcDensity, Boolean allowDarknessSpawnsInDaytime, Double conquestGainRate) {
            this.biomeName = biomeName;
            this.parentName = parentName;
            this.factionContainers = factionContainers;
            this.npcDensity = npcDensity;
            this.allowDarknessSpawnsInDaytime = allowDarknessSpawnsInDaytime;
            this.conquestGainRate = conquestGainRate;
        }

        public static PreLoaded read(NPCSpawnSettings spawnSettings, FactionSettings factionSettings, ResourceLocation resourceName, JsonObject json) {
            ResourceLocation parentName = null;
            if (json.has("parent") && (parentName = new ResourceLocation(json.get("parent").getAsString())).equals((Object)resourceName)) {
                LOTRLog.warn("Error loading biome NPC spawn list for %s - cannot be its own parent!");
                return null;
            }
            ArrayList<FactionContainer> factionSpawnLists = null;
            if (json.has("faction_spawn_lists")) {
                factionSpawnLists = new ArrayList<FactionContainer>();
                JsonArray factionSpawnListsArray = json.get("faction_spawn_lists").getAsJsonArray();
                for (JsonElement elem : factionSpawnListsArray) {
                    try {
                        FactionContainer factionSpawnList = FactionContainer.read(spawnSettings, factionSettings, resourceName, elem.getAsJsonObject());
                        if (factionSpawnList == null) continue;
                        factionSpawnLists.add(factionSpawnList);
                    }
                    catch (Exception e) {
                        LOTRLog.warn("Error loading a faction spawn list in biome NPC spawn list for %s", resourceName);
                        e.printStackTrace();
                    }
                }
            }
            Double npcDensity = null;
            if (json.has("npc_density")) {
                npcDensity = json.get("npc_density").getAsDouble();
            }
            Boolean allowDarknessSpawnsInDaytime = null;
            if (json.has("allow_darkness_spawns_in_daytime")) {
                allowDarknessSpawnsInDaytime = json.get("allow_darkness_spawns_in_daytime").getAsBoolean();
            }
            Double conquestGainRate = null;
            if (json.has("conquest_gain_rate")) {
                conquestGainRate = json.get("conquest_gain_rate").getAsDouble();
            }
            return new PreLoaded(resourceName, parentName, factionSpawnLists, npcDensity, allowDarknessSpawnsInDaytime, conquestGainRate);
        }

        public BiomeNPCSpawnList resolveParentAndFinaliseAfterLoad(Map<ResourceLocation, PreLoaded> allLoadedLists) {
            List<FactionContainer> final_factionContainers = this.factionContainers;
            Double final_npcDensity = this.npcDensity;
            Boolean final_allowDarknessSpawnsInDaytime = this.allowDarknessSpawnsInDaytime;
            Double final_conquestGainRate = this.conquestGainRate;
            if (this.parentName != null) {
                PreLoaded parent = allLoadedLists.get(this.parentName);
                if (parent == null) {
                    LOTRLog.warn("Error loading biome NPC spawn list %s - parent '%s' could not be resolved", this.biomeName, this.parentName);
                    return null;
                }
                if (!PreLoaded.checkForNoCircularInheritance(this, allLoadedLists)) {
                    return null;
                }
                final_factionContainers = PreLoaded.inheritFromParent(final_factionContainers, parent.factionContainers);
                final_npcDensity = PreLoaded.inheritFromParent(final_npcDensity, parent.npcDensity);
                final_allowDarknessSpawnsInDaytime = PreLoaded.inheritFromParent(final_allowDarknessSpawnsInDaytime, parent.allowDarknessSpawnsInDaytime);
                final_conquestGainRate = PreLoaded.inheritFromParent(final_conquestGainRate, parent.conquestGainRate);
            }
            final_factionContainers = PreLoaded.fallbackIfNull(final_factionContainers, new ArrayList());
            final_npcDensity = PreLoaded.fallbackIfNull(final_npcDensity, 1.0);
            final_allowDarknessSpawnsInDaytime = PreLoaded.fallbackIfNull(final_allowDarknessSpawnsInDaytime, false);
            final_conquestGainRate = PreLoaded.fallbackIfNull(final_conquestGainRate, 1.0);
            return new BiomeNPCSpawnList(this.biomeName, final_factionContainers, final_npcDensity, final_allowDarknessSpawnsInDaytime, final_conquestGainRate);
        }

        private static boolean checkForNoCircularInheritance(PreLoaded loader, Map<ResourceLocation, PreLoaded> allLoadedLists) {
            HashSet<ResourceLocation> inheritanceTrail = new HashSet<ResourceLocation>();
            PreLoaded current = loader;
            while (current != null) {
                if (inheritanceTrail.contains(current.biomeName)) {
                    LOTRLog.warn("Error loading biome NPC spawn list %s - circular reference somewhere in 'parent' trail! Terminated at file %s, depth %d", loader.biomeName, current.biomeName, inheritanceTrail.size());
                    return false;
                }
                inheritanceTrail.add(current.biomeName);
                current = current.parentName != null ? allLoadedLists.get(current.parentName) : null;
            }
            return true;
        }

        private static <T> T inheritFromParent(T ownValue, T parentValue) {
            return ownValue != null ? ownValue : parentValue;
        }

        private static <T> T fallbackIfNull(T ownValue, T defaultValue) {
            return ownValue != null ? ownValue : defaultValue;
        }
    }
}

