/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.spawning;

import java.util.List;
import java.util.Random;
import java.util.stream.Stream;
import net.minecraft.entity.EntityType;
import net.minecraft.util.WeightedRandom;

public interface NPCEntityTypeProvider {
    public EntityType<?> getTypeToSpawn(Random var1);

    public Stream<EntityType<?>> getAllPossibleTypes();

    public static class MixedEntry
    extends WeightedRandom.Item {
        public final EntityType<?> entityType;

        public MixedEntry(EntityType<?> entityType, int weight) {
            super(weight);
            this.entityType = entityType;
        }
    }

    public static class Mixed
    implements NPCEntityTypeProvider {
        private final List<MixedEntry> mixedEntries;

        public Mixed(List<MixedEntry> mixedEntries) {
            this.mixedEntries = mixedEntries;
        }

        @Override
        public EntityType<?> getTypeToSpawn(Random rand) {
            return ((MixedEntry)WeightedRandom.func_76271_a((Random)rand, this.mixedEntries)).entityType;
        }

        @Override
        public Stream<EntityType<?>> getAllPossibleTypes() {
            return this.mixedEntries.stream().map(e -> e.entityType);
        }
    }

    public static class Single
    implements NPCEntityTypeProvider {
        private final EntityType<?> type;

        public Single(EntityType<?> type) {
            this.type = type;
        }

        @Override
        public EntityType<?> getTypeToSpawn(Random rand) {
            return this.type;
        }

        @Override
        public Stream<EntityType<?>> getAllPossibleTypes() {
            return Stream.of(this.type);
        }
    }
}

