/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.spawning;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Random;
import java.util.stream.Stream;
import lotr.common.LOTRLog;
import lotr.common.entity.npc.data.NPCEntitySettingsManager;
import lotr.common.world.spawning.NPCEntityTypeProvider;
import net.minecraft.entity.EntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.MathHelper;

public class NPCSpawnEntry
extends WeightedRandom.Item {
    private final NPCEntityTypeProvider typeProvider;
    private final int minCount;
    private final int maxCount;

    private NPCSpawnEntry(NPCEntityTypeProvider typeProvider, int weight, int min, int max) {
        super(weight);
        this.typeProvider = typeProvider;
        this.minCount = min;
        this.maxCount = max;
    }

    public static NPCSpawnEntry read(ResourceLocation resourceName, JsonObject json) {
        NPCEntityTypeProvider typeProvider = null;
        if (json.has("entity_type")) {
            String typeName = json.get("entity_type").getAsString();
            ResourceLocation typeNameRes = new ResourceLocation(typeName);
            EntityType<?> entityType = NPCEntitySettingsManager.lookupEntityTypeByName(typeNameRes);
            if (entityType == null) {
                LOTRLog.warn("Failed to load an entry within NPC spawn list %s - nonexistent single entity type %s", resourceName, typeName);
                return null;
            }
            typeProvider = new NPCEntityTypeProvider.Single(entityType);
        } else if (json.has("mixed_entity_types")) {
            ArrayList<NPCEntityTypeProvider.MixedEntry> mixedTypeEntries = new ArrayList<NPCEntityTypeProvider.MixedEntry>();
            JsonArray mixedEntityTypes = json.get("mixed_entity_types").getAsJsonArray();
            for (JsonElement elem : mixedEntityTypes) {
                JsonObject singleTypeJson = elem.getAsJsonObject();
                String typeName = singleTypeJson.get("entity_type").getAsString();
                ResourceLocation typeNameRes = new ResourceLocation(typeName);
                EntityType<?> entityType = NPCEntitySettingsManager.lookupEntityTypeByName(typeNameRes);
                if (entityType == null) {
                    LOTRLog.warn("Failed to load an entry within NPC spawn list %s - nonexistent entity type %s in mixed_entity_types", resourceName, typeName);
                    return null;
                }
                int weight = singleTypeJson.get("weight").getAsInt();
                mixedTypeEntries.add(new NPCEntityTypeProvider.MixedEntry(entityType, weight));
            }
            typeProvider = new NPCEntityTypeProvider.Mixed(mixedTypeEntries);
        } else {
            LOTRLog.warn("Failed to load NPC spawn entry in list %s - found neither a single entity_type nor a mixed_entity_types array", resourceName);
            return null;
        }
        int weight = json.get("weight").getAsInt();
        int minCount = json.get("min_count").getAsInt();
        int maxCount = json.get("max_count").getAsInt();
        return new NPCSpawnEntry(typeProvider, weight, minCount, maxCount);
    }

    private int getRandomGroupSize(Random rand) {
        return MathHelper.func_76136_a((Random)rand, (int)this.minCount, (int)this.maxCount);
    }

    public Stream<EntityType<?>> getAllPossibleTypes() {
        return this.typeProvider.getAllPossibleTypes();
    }

    public static class EntryInContext {
        private final NPCSpawnEntry spawnEntry;
        private final boolean isConquestSpawn;

        public EntryInContext(NPCSpawnEntry entry, boolean conquest) {
            this.spawnEntry = entry;
            this.isConquestSpawn = conquest;
        }

        public int getRandomGroupSize(Random rand) {
            return this.spawnEntry.getRandomGroupSize(rand);
        }

        public EntityType<?> getTypeToSpawn(Random rand) {
            return this.spawnEntry.typeProvider.getTypeToSpawn(rand);
        }

        public boolean isConquestSpawn() {
            return this.isConquestSpawn;
        }
    }
}

