/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.world.spawning;

import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Collectors;
import lotr.common.LOTRLog;
import lotr.common.entity.npc.NPCEntity;
import lotr.common.init.LOTRDimensions;
import lotr.common.world.spawning.BiomeNPCSpawnList;
import lotr.common.world.spawning.NPCSpawnEntry;
import lotr.common.world.spawning.NPCSpawnSettingsManager;
import net.minecraft.block.BlockState;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.spawner.WorldEntitySpawner;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;

public class RenewedNPCSpawner {
    private static final Map<RegistryKey<World>, RenewedNPCSpawner> PER_WORLD_SPAWNERS = new HashMap<RegistryKey<World>, RenewedNPCSpawner>();
    private final RegistryKey<World> dimension;
    private long lastCycleTime;
    private static final long SPAWN_CYCLE_INTERVAL = 20L;
    private final List<ChunkPos> spawnableChunks = new ArrayList<ChunkPos>();
    private static final int SPAWNABLE_CHUNK_RADIUS = 7;
    private static final double AVG_NPCS_PER_CHUNK = 0.51;

    private RenewedNPCSpawner(RegistryKey<World> dimension) {
        this.dimension = dimension;
    }

    public static RenewedNPCSpawner getForWorld(ServerWorld world) {
        return PER_WORLD_SPAWNERS.computeIfAbsent((RegistryKey<World>)world.func_234923_W_(), RenewedNPCSpawner::new);
    }

    public void runSpawning(ServerWorld world) {
        if (!world.func_82736_K().func_223586_b(GameRules.field_223601_d)) {
            return;
        }
        world.func_217381_Z().func_76320_a("lotrNpcSpawning");
        long worldTime = world.func_82737_E();
        this.lastCycleTime = Math.min(this.lastCycleTime, worldTime);
        if (worldTime - this.lastCycleTime >= 20L) {
            this.runSpawnCycle(world);
            this.lastCycleTime = worldTime;
        }
        world.func_217381_Z().func_76319_b();
    }

    private void runSpawnCycle(ServerWorld world) {
        block1: {
            List<ChunkPos> chunks = this.gatherSpawnableChunks(world);
            double sumDensity = chunks.stream().collect(Collectors.summingDouble(chunk -> this.getNPCDensityCapForChunk(world, (ChunkPos)chunk)));
            int cap = (int)(sumDensity * 0.51);
            double count = Streams.stream((Iterable)world.func_241136_z_()).filter(this::includeInNPCCount).map(e -> (NPCEntity)e).collect(Collectors.summingDouble(NPCEntity::getSpawnCountWeight));
            if (!(count < (double)cap)) break block1;
            Collections.shuffle(chunks);
            Random rand = world.field_73012_v;
            for (ChunkPos chunkPos : chunks) {
                if ((count += this.performSpawningInChunk(world, chunkPos, rand)) >= (double)cap) break;
            }
        }
    }

    private boolean includeInNPCCount(Entity e) {
        return e.func_70089_S() && e instanceof NPCEntity;
    }

    private List<ChunkPos> gatherSpawnableChunks(ServerWorld world) {
        this.spawnableChunks.clear();
        ServerChunkProvider scp = world.func_72863_F();
        for (ServerPlayerEntity player : world.func_217369_A()) {
            int chunkX = MathHelper.func_76128_c((double)(player.func_226277_ct_() / 16.0));
            int chunkZ = MathHelper.func_76128_c((double)(player.func_226281_cx_() / 16.0));
            for (int dx = -7; dx <= 7; ++dx) {
                for (int dz = -7; dz <= 7; ++dz) {
                    ChunkPos chunkPos = new ChunkPos(chunkX + dx, chunkZ + dz);
                    if (this.spawnableChunks.contains(chunkPos) || !scp.func_222865_a(chunkPos)) continue;
                    this.spawnableChunks.add(chunkPos);
                }
            }
        }
        return this.spawnableChunks;
    }

    private double getNPCDensityCapForChunk(ServerWorld world, ChunkPos chunkPos) {
        Random rand = world.field_73012_v;
        int x = MathHelper.func_76136_a((Random)rand, (int)chunkPos.func_180334_c(), (int)chunkPos.func_180332_e());
        int z = MathHelper.func_76136_a((Random)rand, (int)chunkPos.func_180333_d(), (int)chunkPos.func_180330_f());
        int y = world.func_181545_F();
        return this.getNPCDensityForBiome(world, world.func_226691_t_(new BlockPos(x, y, z)));
    }

    private double getNPCDensityForBiome(ServerWorld world, Biome biome) {
        return NPCSpawnSettingsManager.getSpawnsForBiome(biome, (IWorld)world).getNPCDensity();
    }

    private double performSpawningInChunk(ServerWorld world, ChunkPos chunkPos, Random rand) {
        double addedSpawnCountWeight = 0.0;
        BlockPos pos = RenewedNPCSpawner.getRandomSpawnPositionInChunk(world, chunkPos, rand);
        if (pos.func_177956_o() >= 1) {
            int y = pos.func_177956_o();
            BlockState state = world.func_180495_p(pos);
            if (!state.func_215686_e((IBlockReader)world, pos)) {
                BlockPos.Mutable movingPos = new BlockPos.Mutable();
                boolean j = false;
                int groups = 3;
                block0: for (int l = 0; l < groups; ++l) {
                    int x = pos.func_177958_n();
                    int z = pos.func_177952_p();
                    int range = 5;
                    boolean yRange = false;
                    int rangeP1 = 6;
                    boolean yRangeP1 = true;
                    NPCSpawnEntry.EntryInContext spawnEntryInstance = RenewedNPCSpawner.getRandomSpawnListEntry((World)world, pos);
                    if (spawnEntryInstance == null) continue;
                    ILivingEntityData entityGroupData = null;
                    boolean isConquestSpawn = spawnEntryInstance.isConquestSpawn();
                    int groupSize = spawnEntryInstance.getRandomGroupSize(rand);
                    int spawnedInGroup = 0;
                    int attempts = groupSize * 8;
                    for (int a = 0; a < attempts; ++a) {
                        NPCEntity entity;
                        EntityType<?> typeToSpawn;
                        double distSqToPlayer;
                        movingPos.func_181079_c(x += rand.nextInt(6) - rand.nextInt(6), y += rand.nextInt(1) - rand.nextInt(1), z += rand.nextInt(6) - rand.nextInt(6));
                        double xd = (double)x + 0.5;
                        double zd = (double)z + 0.5;
                        PlayerEntity closestPlayer = world.func_217366_a(xd, (double)y, zd, -1.0, false);
                        if (closestPlayer == null || !RenewedNPCSpawner.isSuitableSpawnLocation(world, chunkPos, movingPos, distSqToPlayer = closestPlayer.func_70092_e(xd, (double)y, zd)) || !RenewedNPCSpawner.canNPCSpawnAtLocation(world, typeToSpawn = spawnEntryInstance.getTypeToSpawn(rand), movingPos, distSqToPlayer) || (entity = RenewedNPCSpawner.tryCreateNPC(world, typeToSpawn)) == null) continue;
                        entity.func_70012_b(xd, y, zd, rand.nextFloat() * 360.0f, 0.0f);
                        int canSpawn = ForgeHooks.canEntitySpawn((MobEntity)entity, (IWorld)world, (double)xd, (double)y, (double)zd, null, (SpawnReason)SpawnReason.NATURAL);
                        if (canSpawn == -1 || canSpawn != 1 && !RenewedNPCSpawner.canNPCSpawnNormally(world, entity, distSqToPlayer)) continue;
                        if (!ForgeEventFactory.doSpecialSpawn((MobEntity)entity, (World)world, (float)((float)xd), (float)y, (float)((float)zd), null, (SpawnReason)SpawnReason.NATURAL)) {
                            entityGroupData = entity.func_213386_a((IServerWorld)world, world.func_175649_E(entity.func_233580_cy_()), SpawnReason.NATURAL, entityGroupData, null);
                        }
                        world.func_242417_l((Entity)entity);
                        addedSpawnCountWeight += entity.getSpawnCountWeight();
                        if (++spawnedInGroup >= groupSize || spawnedInGroup >= ForgeEventFactory.getMaxSpawnPackSize((MobEntity)entity) || entity.func_204209_c(spawnedInGroup)) continue block0;
                    }
                }
            }
        }
        return addedSpawnCountWeight;
    }

    private static BlockPos getRandomSpawnPositionInChunk(ServerWorld world, ChunkPos chunkPos, Random rand) {
        int x = MathHelper.func_76136_a((Random)rand, (int)chunkPos.func_180334_c(), (int)chunkPos.func_180332_e());
        int z = MathHelper.func_76136_a((Random)rand, (int)chunkPos.func_180333_d(), (int)chunkPos.func_180330_f());
        int topY = world.func_201676_a(Heightmap.Type.WORLD_SURFACE, x, z) + 1;
        int y = rand.nextInt(topY + 1);
        return new BlockPos(x, y, z);
    }

    private static NPCSpawnEntry.EntryInContext getRandomSpawnListEntry(World world, BlockPos pos) {
        Random rand = world.field_73012_v;
        Biome biome = world.func_226691_t_(pos);
        BiomeNPCSpawnList spawnList = NPCSpawnSettingsManager.getSpawnsForBiome(biome, (IWorld)world);
        return spawnList.getRandomSpawnEntry(rand, world, pos);
    }

    private static boolean isSuitableSpawnLocation(ServerWorld world, ChunkPos mainChunkPos, BlockPos.Mutable pos, double distSqToPlayer) {
        double playerAndSpawnExclusionRange = 24.0;
        if (distSqToPlayer <= 576.0) {
            return false;
        }
        if (LOTRDimensions.getDimensionSpawnPoint(world).func_218137_a((IPosition)Vector3d.func_237492_c_((Vector3i)pos), 24.0)) {
            return false;
        }
        ChunkPos chunkPosAtBlock = new ChunkPos((BlockPos)pos);
        return Objects.equals(chunkPosAtBlock, mainChunkPos) || world.func_72863_F().func_222865_a(chunkPosAtBlock);
    }

    private static boolean canNPCSpawnAtLocation(ServerWorld world, EntityType<?> type, BlockPos.Mutable pos, double distSqToPlayer) {
        double despawnDist = type.func_220339_d().func_233671_f_();
        if (!type.func_225437_d() && distSqToPlayer > despawnDist * despawnDist) {
            return false;
        }
        if (type.func_200720_b()) {
            EntitySpawnPlacementRegistry.PlacementType placementType = EntitySpawnPlacementRegistry.func_209344_a(type);
            if (!WorldEntitySpawner.func_209382_a((EntitySpawnPlacementRegistry.PlacementType)placementType, (IWorldReader)world, (BlockPos)pos, type)) {
                return false;
            }
            if (!EntitySpawnPlacementRegistry.func_223515_a(type, (IServerWorld)world, (SpawnReason)SpawnReason.NATURAL, (BlockPos)pos, (Random)world.field_73012_v)) {
                return false;
            }
            return world.func_226664_a_(type.func_220328_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5));
        }
        return false;
    }

    private static NPCEntity tryCreateNPC(ServerWorld world, EntityType<?> type) {
        try {
            Entity entity = type.func_200721_a((World)world);
            if (!(entity instanceof NPCEntity)) {
                throw new IllegalStateException("LOTR mob spawner trying to spawn a non-NPC: " + Registry.field_212629_r.func_177774_c(type));
            }
            return (NPCEntity)entity;
        }
        catch (Exception e) {
            e.printStackTrace();
            LOTRLog.warn("Failed to create spawned NPC", e);
            return null;
        }
    }

    private static boolean canNPCSpawnNormally(ServerWorld world, NPCEntity entity, double distSqToPlayer) {
        double despawnDist = entity.func_200600_R().func_220339_d().func_233671_f_();
        if (distSqToPlayer > despawnDist * despawnDist && entity.func_213397_c(distSqToPlayer)) {
            return false;
        }
        return entity.func_213380_a((IWorld)world, SpawnReason.NATURAL) && entity.func_205019_a((IWorldReader)world);
    }
}

