/*
 * Decompiled with CFR 0.152.
 */
package lotr.curuquesta.condition;

import io.netty.buffer.ByteBuf;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lotr.curuquesta.SpeechbankContextProvider;
import lotr.curuquesta.condition.SpeechbankCondition;
import lotr.curuquesta.condition.predicate.ComplexPredicateParsers;
import lotr.curuquesta.condition.predicate.PredicateParser;

public class EnumSpeechbankCondition<E extends Enum<E>, C extends SpeechbankContextProvider>
extends SpeechbankCondition<E, C> {
    private final E[] enumValues;

    public EnumSpeechbankCondition(String conditionName, E[] enumValues, Function<C, E> valueFromContext, PredicateParser<E> predicateParser) {
        super(conditionName, valueFromContext, predicateParser);
        this.enumValues = enumValues;
    }

    public EnumSpeechbankCondition(String conditionName, E[] enumValues, Function<C, E> valueFromContext) {
        this(conditionName, (Enum[])enumValues, valueFromContext, ComplexPredicateParsers.logicalOrOfValues(s -> EnumSpeechbankCondition.parseEnum((Enum[])enumValues, (String)s)));
    }

    public static <E extends Enum<E>, C extends SpeechbankContextProvider> EnumSpeechbankCondition<E, C> enumWithComparableExpressions(String conditionName, E[] enumValues, Function<C, E> valueFromContext) {
        return new EnumSpeechbankCondition(conditionName, enumValues, valueFromContext, ComplexPredicateParsers.logicalExpressionOfComparableSubpredicates(s -> EnumSpeechbankCondition.parseEnum((Enum[])enumValues, (String)s)));
    }

    private static <E extends Enum> E parseEnum(E[] enumValues, String s) {
        return (E)Stream.of(enumValues).filter(e -> e.name().equalsIgnoreCase(s)).findFirst().orElseThrow(() -> {
            String errorMsg = String.format("No such value '%s' in enum - acceptable values are [%s]", s, Stream.of(enumValues).map(e -> e.name().toLowerCase()).collect(Collectors.joining(", ")));
            return new IllegalArgumentException(errorMsg);
        });
    }

    @Override
    public boolean isValidValue(E value) {
        return value != null;
    }

    @Override
    protected void writeValue(E value, ByteBuf buf) {
        buf.writeInt(((Enum)value).ordinal());
    }

    @Override
    protected E readValue(ByteBuf buf) {
        int ordinal = buf.readInt();
        if (ordinal < 0 || ordinal >= this.enumValues.length) {
            ordinal = 0;
        }
        return this.enumValues[ordinal];
    }
}

