/*
 * Decompiled with CFR 0.152.
 */
package lotr.curuquesta.condition;

import io.netty.buffer.ByteBuf;
import java.util.function.Function;
import lotr.curuquesta.SpeechbankContextProvider;
import lotr.curuquesta.condition.SpeechbankCondition;
import lotr.curuquesta.condition.predicate.ComplexPredicateParsers;
import lotr.curuquesta.condition.predicate.PredicateParser;

public class FloatSpeechbankCondition<C extends SpeechbankContextProvider>
extends SpeechbankCondition<Float, C> {
    public FloatSpeechbankCondition(String conditionName, Function<C, Float> valueFromContext, PredicateParser<Float> predicateParser) {
        super(conditionName, valueFromContext, predicateParser);
    }

    public FloatSpeechbankCondition(String conditionName, Function<C, Float> valueFromContext) {
        this(conditionName, valueFromContext, ComplexPredicateParsers.logicalExpressionOfComparableSubpredicates(Float::parseFloat));
    }

    @Override
    public boolean isValidValue(Float value) {
        return value != null;
    }

    @Override
    protected void writeValue(Float value, ByteBuf buf) {
        buf.writeFloat(value.floatValue());
    }

    @Override
    protected Float readValue(ByteBuf buf) {
        return Float.valueOf(buf.readFloat());
    }
}

