/*
 * Decompiled with CFR 0.152.
 */
package lotr.curuquesta.condition;

import io.netty.buffer.ByteBuf;
import java.util.function.Function;
import lotr.curuquesta.SpeechbankContextProvider;
import lotr.curuquesta.condition.SpeechbankCondition;
import lotr.curuquesta.condition.predicate.ComplexPredicateParsers;
import lotr.curuquesta.condition.predicate.PredicateParser;

public class IntegerSpeechbankCondition<C extends SpeechbankContextProvider>
extends SpeechbankCondition<Integer, C> {
    public IntegerSpeechbankCondition(String conditionName, Function<C, Integer> valueFromContext, PredicateParser<Integer> predicateParser) {
        super(conditionName, valueFromContext, predicateParser);
    }

    public IntegerSpeechbankCondition(String conditionName, Function<C, Integer> valueFromContext) {
        this(conditionName, valueFromContext, ComplexPredicateParsers.logicalExpressionOfComparableSubpredicates(Integer::parseInt));
    }

    @Override
    public boolean isValidValue(Integer value) {
        return value != null;
    }

    @Override
    protected void writeValue(Integer value, ByteBuf buf) {
        buf.writeInt(value.intValue());
    }

    @Override
    protected Integer readValue(ByteBuf buf) {
        return buf.readInt();
    }
}

