/*
 * Decompiled with CFR 0.152.
 */
package lotr.curuquesta.structure;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import lotr.curuquesta.SpeechbankContext;
import lotr.curuquesta.SpeechbankContextProvider;
import lotr.curuquesta.structure.SpeechbankEntry;

public class Speechbank<C extends SpeechbankContextProvider> {
    private final String speechbankName;
    private final List<SpeechbankEntry<C>> entries;

    public Speechbank(String speechbankName, List<SpeechbankEntry<C>> entries) {
        this.speechbankName = speechbankName;
        this.entries = entries;
    }

    public static <C extends SpeechbankContextProvider> Speechbank<C> getFallbackSpeechbank(String name, List<String> fallbackMessages) {
        return new Speechbank<C>(name, ImmutableList.of(new SpeechbankEntry(ImmutableSet.of(), fallbackMessages)));
    }

    public String getRandomSpeech(SpeechbankContext<C> context, Random rand) {
        List<String> matchingLines = this.filterMatchingLines(context);
        if (matchingLines.isEmpty()) {
            return String.format("Speechbank %s found no lines that satisfy the current context!", this.speechbankName);
        }
        String line = matchingLines.get(rand.nextInt(matchingLines.size()));
        line = this.fillAllVariablesInLine(line, context);
        return line;
    }

    private List<String> filterMatchingLines(SpeechbankContext<C> context) {
        return this.entries.stream().filter(e -> e.doesContextSatisfyConditions(context)).flatMap(SpeechbankEntry::streamLines).collect(Collectors.toList());
    }

    private String fillAllVariablesInLine(String line, SpeechbankContext<C> context) {
        String[] callback = new String[]{line};
        context.forEachReplaceableVariable((variable, value) -> {
            callback[0] = variable.fillMatchesInSpeechLine(callback[0], (String)value);
        });
        return callback[0];
    }

    public List<SpeechbankEntry<C>> getEntriesView() {
        return new ArrayList<SpeechbankEntry<C>>(this.entries);
    }
}

