/*
 * Decompiled with CFR 0.152.
 */
package net.richardsprojects.lotrcompanions;

import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.richardsprojects.lotrcompanions.client.ContainerScreenHelper;
import net.richardsprojects.lotrcompanions.client.eventhandlers.RenderHealthbars;
import net.richardsprojects.lotrcompanions.client.render.HiredBreeGuardRenderer;
import net.richardsprojects.lotrcompanions.client.render.HiredGondorSoldierRenderer;
import net.richardsprojects.lotrcompanions.container.CompanionsContainers;
import net.richardsprojects.lotrcompanions.core.PacketHandler;
import net.richardsprojects.lotrcompanions.eventhandlers.ForgeEntityEvents;
import net.richardsprojects.lotrcompanions.eventhandlers.LOTRFastTravelEventHandler;
import net.richardsprojects.lotrcompanions.item.LOTRCItems;
import net.richardsprojects.lotrcompanions.npcs.LOTRCNpcs;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="lotrcompanions")
public class LOTRCompanions {
    public static final boolean LOW_HEALTH_FOOD = true;
    public static final boolean FRIENDLY_FIRE_PLAYER = true;
    public static final boolean FALL_DAMAGE = true;
    public static final int BASE_HEALTH = 30;
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String MOD_ID = "lotrcompanions";
    public static final boolean FRIENDLY_FIRE_COMPANIONS = false;
    public static UUID usersUUID = null;
    public static final boolean HIRED_UNITS_PARITICIPATE_PVP = false;
    public static IEventBus eventBus;

    public LOTRCompanions() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register(ForgeEntityEvents.class);
        MinecraftForge.EVENT_BUS.register(LOTRFastTravelEventHandler.class);
        eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        LOTRCItems.ITEMS.register(eventBus);
        eventBus.register((Object)this);
        CompanionsContainers.register();
        eventBus.addListener(this::registerScreens);
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> this::setupClient);
        PacketHandler.register();
    }

    private void registerScreens(FMLClientSetupEvent event) {
        ContainerScreenHelper.registerScreens();
    }

    private void setupClient() {
        MinecraftForge.EVENT_BUS.register(RenderHealthbars.class);
        String userUUIDString = Minecraft.func_71410_x().func_110432_I().func_148255_b();
        if (!userUUIDString.equals("")) {
            userUUIDString = LOTRCompanions.addDashesToUUID(userUUIDString);
        }
        try {
            usersUUID = UUID.fromString(userUUIDString);
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
        }
    }

    private static String addDashesToUUID(String uuid) {
        return uuid.replaceFirst("(\\p{XDigit}{8})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}+)", "$1-$2-$3-$4-$5");
    }

    @SubscribeEvent
    public void setupClientRendering(FMLClientSetupEvent event) {
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)LOTRCNpcs.HIRED_GONDOR_SOLDIER.get()), HiredGondorSoldierRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)LOTRCNpcs.HIRED_BREE_GUARD.get()), HiredBreeGuardRenderer::new);
    }
}

