/*
 * Decompiled with CFR 0.152.
 */
package net.richardsprojects.lotrcompanions.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.richardsprojects.lotrcompanions.client.ColorHelper;
import net.richardsprojects.lotrcompanions.client.render.BarRendererHelper;

public class CompanionHpBar {
    private static final float HEALTHBAR_OPACITY = 0.8f;
    private static final float BACKGROUND_RED = 0.0f;
    private static final float BACKGROUND_GREEN = 0.0f;
    private static final float BACKGROUND_BLUE = 0.0f;
    private static final int TEXT_POS_X = 0;
    private static final int TEXT_POS_Y = 0;
    private static final int HB_POS_X_OFFSET = 0;
    private static final int HB_POS_Y_OFFSET = 0;
    private static final int HB_POS_X = -50;
    private static final int HB_POS_Y = 20;
    private static final int HB_WIDTH = 100;
    private static final int HB_HEIGHT = 9;
    private static final float HB_GREEN_R = 0.33333334f;
    private static final float HB_GREEN_G = 1.0f;
    private static final float HB_GREEN_B = 0.33333334f;
    private static final float HB_YELLOW_R = 1.0f;
    private static final float HB_YELLOW_G = 1.0f;
    private static final float HB_YELLOW_B = 0.33333334f;
    private static final float HB_RED_R = 1.0f;
    private static final float HB_RED_G = 0.33333334f;
    private static final float HB_RED_B = 0.33333334f;

    public static void draw(LivingEntity entity, float textScale, MatrixStack matrixStackIn, FontRenderer font) {
        float vit = entity.func_110138_aP();
        float hp = entity.func_110143_aJ();
        float hpWidth = (float)(-font.func_78256_a((int)hp + "/" + (int)vit)) / 2.0f;
        RenderSystem.enableDepthTest();
        RenderSystem.defaultBlendFunc();
        matrixStackIn.func_227860_a_();
        ResourceLocation bar = new ResourceLocation("lotrcompanions", "textures/gui/healthbar.png");
        matrixStackIn.func_227861_a_(0.0, 0.0, 0.0);
        matrixStackIn.func_227862_a_(1.0f, 1.0f, 1.0f);
        BarRendererHelper.bind(bar);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        int endOfHealth = (int)Math.ceil(100.0 * (double)(hp / vit));
        if (endOfHealth >= 80) {
            RenderSystem.color4f((float)0.33333334f, (float)1.0f, (float)0.33333334f, (float)0.8f);
        } else if (endOfHealth >= 40) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)0.33333334f, (float)0.8f);
        } else {
            RenderSystem.color4f((float)1.0f, (float)0.33333334f, (float)0.33333334f, (float)0.8f);
        }
        BarRendererHelper.blit(matrixStackIn, -50, 20, 0, 19, endOfHealth, 9);
        if (endOfHealth < 100) {
            matrixStackIn.func_227861_a_(0.0, 0.0, 0.0);
            matrixStackIn.func_227862_a_(1.0f, 1.0f, 1.0f);
            BarRendererHelper.bind(bar);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.color4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.8f);
            BarRendererHelper.blit(matrixStackIn, -50 + endOfHealth, 20, 0, 19, 100 - endOfHealth, 9);
        }
        matrixStackIn.func_227861_a_(0.0, 0.0, -0.01);
        matrixStackIn.func_227861_a_(0.0, 0.0, -0.03);
        matrixStackIn.func_227862_a_(textScale, textScale, 1.0f);
        int color = ColorHelper.ARGB32.color(255, 255, 255, 255);
        BarRendererHelper.drawString(matrixStackIn, font, (int)hp + "/" + (int)vit, (int)hpWidth, 20, color, false);
        RenderSystem.disableBlend();
        matrixStackIn.func_227865_b_();
        RenderSystem.disableDepthTest();
    }
}

