/*
 * Decompiled with CFR 0.152.
 */
package net.richardsprojects.lotrcompanions.container;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import lotr.common.entity.npc.NPCEntity;
import lotr.common.item.SpearItem;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShieldItem;
import net.minecraft.item.SwordItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.richardsprojects.lotrcompanions.container.CompanionsContainers;
import net.richardsprojects.lotrcompanions.npcs.HiredUnitHelper;

public class CompanionEquipmentContainer
extends Container
implements IContainerListener {
    private Slot[] armorSlots = new Slot[4];
    private Slot mainHand;
    private Slot offHand;
    private int entityId;
    public static final ResourceLocation EMPTY_ARMOR_SLOT_HELMET = new ResourceLocation("item/empty_armor_slot_helmet");
    public static final ResourceLocation EMPTY_ARMOR_SLOT_CHESTPLATE = new ResourceLocation("item/empty_armor_slot_chestplate");
    public static final ResourceLocation EMPTY_ARMOR_SLOT_LEGGINGS = new ResourceLocation("item/empty_armor_slot_leggings");
    public static final ResourceLocation EMPTY_ARMOR_SLOT_BOOTS = new ResourceLocation("item/empty_armor_slot_boots");
    public static final ResourceLocation EMPTY_ARMOR_SLOT_SHIELD = new ResourceLocation("item/empty_armor_slot_shield");
    private static final ResourceLocation[] TEXTURE_EMPTY_SLOTS = new ResourceLocation[]{EMPTY_ARMOR_SLOT_BOOTS, EMPTY_ARMOR_SLOT_LEGGINGS, EMPTY_ARMOR_SLOT_CHESTPLATE, EMPTY_ARMOR_SLOT_HELMET};
    private static final EquipmentSlotType[] SLOT_IDS = new EquipmentSlotType[]{EquipmentSlotType.HEAD, EquipmentSlotType.CHEST, EquipmentSlotType.LEGS, EquipmentSlotType.FEET};
    private static final int[] yPos = new int[]{31, 49, 67, 85};
    private NPCEntity companion;
    private PlayerEntity player;
    private final World level;
    public static final ITextComponent CONTAINER_TITLE = new TranslationTextComponent("container.lotrcompanions.equipment");
    Inventory tempInventory;

    public CompanionEquipmentContainer(int p_39230_, PlayerInventory playerInventory, PacketBuffer extraData) {
        super((ContainerType)CompanionsContainers.COMPANION_EQUIPMENT_CONTAINER.get(), p_39230_);
        CompoundNBT nbt = extraData.func_244273_m();
        this.entityId = nbt.func_74762_e("entityId");
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        ListNBT list = nbt.func_150295_c("equipment", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT node = list.func_150305_b(i);
            if (node == null) continue;
            ItemStack item = ItemStack.func_199557_a((CompoundNBT)node.func_74775_l("item"));
            items.add(item);
        }
        ItemStack[] equipment = items.toArray(new ItemStack[items.size()]);
        this.tempInventory = new Inventory(6);
        for (int i = 0; i < equipment.length && i < 6; ++i) {
            this.tempInventory.func_70299_a(i, equipment[i]);
        }
        this.player = playerInventory.field_70458_d;
        this.level = this.player.field_70170_p;
        this.companion = (NPCEntity)this.level.func_73045_a(this.entityId);
        for (int l = 0; l < 3; ++l) {
            for (int j1 = 0; j1 < 9; ++j1) {
                this.func_75146_a(new Slot((IInventory)playerInventory, j1 + l * 9 + 9, 8 + j1 * 18, 142 + l * 18));
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            this.func_75146_a(new Slot((IInventory)playerInventory, i1, 8 + i1 * 18, 200));
        }
        for (int slot = 9; slot < 13; ++slot) {
            final EquipmentSlotType equipmentSlotType = SLOT_IDS[slot - 9];
            this.armorSlots[slot - 9] = this.func_75146_a(new Slot((IInventory)this.tempInventory, slot - 9, 8, yPos[slot - 9]){

                public int func_75219_a() {
                    return 1;
                }

                public boolean func_75214_a(ItemStack itemStack) {
                    if (itemStack.func_77973_b() instanceof ArmorItem) {
                        ArmorItem item = (ArmorItem)itemStack.func_77973_b();
                        return item.func_185083_B_() == equipmentSlotType;
                    }
                    return false;
                }

                public Pair<ResourceLocation, ResourceLocation> func_225517_c_() {
                    return Pair.of((Object)PlayerContainer.field_226615_c_, (Object)TEXTURE_EMPTY_SLOTS[equipmentSlotType.func_188454_b()]);
                }
            });
        }
        this.mainHand = this.func_75146_a(new Slot((IInventory)this.tempInventory, 4, 62, 67));
        this.offHand = this.func_75146_a(new Slot((IInventory)this.tempInventory, 5, 62, 85){

            public Pair<ResourceLocation, ResourceLocation> func_225517_c_() {
                return Pair.of((Object)PlayerContainer.field_226615_c_, (Object)EMPTY_ARMOR_SLOT_SHIELD);
            }
        });
        this.func_75132_a(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ItemStack func_82846_b(PlayerEntity player, int p_39254_) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(p_39254_);
        if (slot != null && slot.equals(this.mainHand) && slot.func_75216_d()) {
            if (player.field_71071_by.func_70447_i() <= -1 && player.field_71071_by.func_70432_d(slot.func_75211_c()) <= -1) return ItemStack.field_190927_a;
            player.func_191521_c(slot.func_75211_c());
            this.mainHand.func_75215_d(ItemStack.field_190927_a);
            this.mainHand.func_75218_e();
            HiredUnitHelper.updateEquipmentSlot(this.companion, EquipmentSlotType.MAINHAND, ItemStack.field_190927_a);
            return ItemStack.field_190927_a;
        } else if (slot != null && slot.equals(this.offHand) && slot.func_75216_d()) {
            if (player.field_71071_by.func_70447_i() <= -1 && player.field_71071_by.func_70432_d(slot.func_75211_c()) <= -1) return ItemStack.field_190927_a;
            player.func_191521_c(slot.func_75211_c());
            this.offHand.func_75215_d(ItemStack.field_190927_a);
            this.offHand.func_75218_e();
            HiredUnitHelper.updateEquipmentSlot(this.companion, EquipmentSlotType.OFFHAND, ItemStack.field_190927_a);
            return ItemStack.field_190927_a;
        } else if (slot != null && slot.equals(this.armorSlots[0]) && slot.func_75216_d()) {
            if (player.field_71071_by.func_70447_i() <= -1 && player.field_71071_by.func_70432_d(slot.func_75211_c()) <= -1) return ItemStack.field_190927_a;
            player.func_191521_c(slot.func_75211_c());
            this.offHand.func_75215_d(ItemStack.field_190927_a);
            this.offHand.func_75218_e();
            HiredUnitHelper.updateEquipmentSlot(this.companion, EquipmentSlotType.HEAD, ItemStack.field_190927_a);
            return ItemStack.field_190927_a;
        } else if (slot != null && slot.equals(this.armorSlots[1]) && slot.func_75216_d()) {
            if (player.field_71071_by.func_70447_i() <= -1 && player.field_71071_by.func_70432_d(slot.func_75211_c()) <= -1) return ItemStack.field_190927_a;
            player.func_191521_c(slot.func_75211_c());
            this.offHand.func_75215_d(ItemStack.field_190927_a);
            this.offHand.func_75218_e();
            HiredUnitHelper.updateEquipmentSlot(this.companion, EquipmentSlotType.CHEST, ItemStack.field_190927_a);
            return ItemStack.field_190927_a;
        } else if (slot != null && slot.equals(this.armorSlots[2]) && slot.func_75216_d()) {
            if (player.field_71071_by.func_70447_i() <= -1 && player.field_71071_by.func_70432_d(slot.func_75211_c()) <= -1) return ItemStack.field_190927_a;
            player.func_191521_c(slot.func_75211_c());
            this.offHand.func_75215_d(ItemStack.field_190927_a);
            this.offHand.func_75218_e();
            HiredUnitHelper.updateEquipmentSlot(this.companion, EquipmentSlotType.LEGS, ItemStack.field_190927_a);
            return ItemStack.field_190927_a;
        } else if (slot != null && slot.equals(this.armorSlots[3]) && slot.func_75216_d()) {
            if (player.field_71071_by.func_70447_i() <= -1 && player.field_71071_by.func_70432_d(slot.func_75211_c()) <= -1) return ItemStack.field_190927_a;
            player.func_191521_c(slot.func_75211_c());
            this.offHand.func_75215_d(ItemStack.field_190927_a);
            this.offHand.func_75218_e();
            HiredUnitHelper.updateEquipmentSlot(this.companion, EquipmentSlotType.FEET, ItemStack.field_190927_a);
            return ItemStack.field_190927_a;
        } else {
            if (slot == null || !slot.func_75216_d()) return ItemStack.field_190927_a;
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            boolean slotUpdated = false;
            if (itemstack1.func_77973_b() instanceof ArmorItem) {
                ArmorItem armor = (ArmorItem)itemstack1.func_77973_b();
                if (armor.func_185083_B_() == EquipmentSlotType.HEAD && !this.armorSlots[0].func_75216_d()) {
                    this.armorSlots[0].func_75215_d(itemstack1);
                    this.armorSlots[0].func_75218_e();
                    HiredUnitHelper.updateEquipmentSlot(this.companion, EquipmentSlotType.HEAD, itemstack1);
                    slotUpdated = true;
                } else if (armor.func_185083_B_() == EquipmentSlotType.CHEST && !this.armorSlots[1].func_75216_d()) {
                    this.armorSlots[1].func_75215_d(itemstack1);
                    this.armorSlots[1].func_75218_e();
                    HiredUnitHelper.updateEquipmentSlot(this.companion, EquipmentSlotType.CHEST, itemstack1);
                    slotUpdated = true;
                } else if (armor.func_185083_B_() == EquipmentSlotType.LEGS && !this.armorSlots[2].func_75216_d()) {
                    this.armorSlots[2].func_75215_d(itemstack1);
                    this.armorSlots[2].func_75218_e();
                    HiredUnitHelper.updateEquipmentSlot(this.companion, EquipmentSlotType.LEGS, itemstack1);
                    slotUpdated = true;
                } else if (armor.func_185083_B_() == EquipmentSlotType.FEET && !this.armorSlots[3].func_75216_d()) {
                    this.armorSlots[3].func_75215_d(itemstack1);
                    this.armorSlots[3].func_75218_e();
                    HiredUnitHelper.updateEquipmentSlot(this.companion, EquipmentSlotType.FEET, itemstack1);
                    slotUpdated = true;
                }
            }
            if ((itemstack1.func_77973_b() instanceof SwordItem || itemstack1.func_77973_b() instanceof SpearItem) && !this.mainHand.func_75216_d()) {
                this.mainHand.func_75215_d(itemstack1);
                this.mainHand.func_75218_e();
                HiredUnitHelper.updateEquipmentSlot(this.companion, EquipmentSlotType.MAINHAND, itemstack1);
                slotUpdated = true;
            }
            if (itemstack1.func_77973_b() instanceof ShieldItem && !this.offHand.func_75216_d()) {
                this.offHand.func_75215_d(itemstack1);
                this.offHand.func_75218_e();
                HiredUnitHelper.updateEquipmentSlot(this.companion, EquipmentSlotType.OFFHAND, itemstack1);
                slotUpdated = true;
            }
            if (slotUpdated) {
                slot.func_75215_d(ItemStack.field_190927_a);
                slot.func_75218_e();
                player.field_71071_by.func_70299_a(slot.field_75222_d, ItemStack.field_190927_a);
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
                return ItemStack.field_190927_a;
            } else {
                slot.func_75218_e();
            }
        }
        return ItemStack.field_190927_a;
    }

    public boolean func_75145_c(PlayerEntity p_75145_1_) {
        return true;
    }

    public int getEntityId() {
        return this.entityId;
    }

    public static void writeContainerInitData(PacketBuffer extraData, int entityId, List<ItemStack> equipment) {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a("entityId", entityId);
        ListNBT listnbt = new ListNBT();
        for (int i = 0; i < 6; ++i) {
            ItemStack stack = equipment.get(i);
            CompoundNBT compoundnbt = new CompoundNBT();
            CompoundNBT itemTag = new CompoundNBT();
            itemTag = stack.func_77955_b(itemTag);
            compoundnbt.func_218657_a("item", (INBT)itemTag);
            listnbt.add((Object)compoundnbt);
        }
        nbt.func_218657_a("equipment", (INBT)listnbt);
        extraData.func_150786_a(nbt);
    }

    public void func_71110_a(Container p_71110_1_, NonNullList<ItemStack> p_71110_2_) {
    }

    public void func_71111_a(Container p_71111_1_, int slot, ItemStack itemStack) {
        if (slot == this.mainHand.field_75222_d) {
            HiredUnitHelper.updateEquipmentSlot(this.companion, EquipmentSlotType.MAINHAND, itemStack);
        } else if (slot == this.offHand.field_75222_d) {
            HiredUnitHelper.updateEquipmentSlot(this.companion, EquipmentSlotType.OFFHAND, itemStack);
        } else if (slot == this.armorSlots[0].field_75222_d) {
            HiredUnitHelper.updateEquipmentSlot(this.companion, EquipmentSlotType.HEAD, itemStack);
        } else if (slot == this.armorSlots[1].field_75222_d) {
            HiredUnitHelper.updateEquipmentSlot(this.companion, EquipmentSlotType.CHEST, itemStack);
        } else if (slot == this.armorSlots[2].field_75222_d) {
            HiredUnitHelper.updateEquipmentSlot(this.companion, EquipmentSlotType.LEGS, itemStack);
        } else if (slot == this.armorSlots[3].field_75222_d) {
            HiredUnitHelper.updateEquipmentSlot(this.companion, EquipmentSlotType.FEET, itemStack);
        }
    }

    public void func_71112_a(Container p_71112_1_, int p_71112_2_, int p_71112_3_) {
    }
}

