/*
 * Decompiled with CFR 0.152.
 */
package net.richardsprojects.lotrcompanions.eventhandlers;

import com.github.maximuslotro.lotrrextended.ExtendedLog;
import java.util.HashSet;
import java.util.Random;
import java.util.UUID;
import lotr.common.entity.npc.BreeGuardEntity;
import lotr.common.entity.npc.DwarfEntity;
import lotr.common.entity.npc.ElfEntity;
import lotr.common.entity.npc.ExtendedHirableEntity;
import lotr.common.entity.npc.GondorSoldierEntity;
import lotr.common.entity.npc.ManEntity;
import lotr.common.entity.npc.NPCEntity;
import lotr.common.entity.npc.OrcEntity;
import lotr.common.entity.npc.data.NPCEntitySettings;
import lotr.common.entity.npc.data.NPCEntitySettingsManager;
import lotr.common.init.ExtendedItems;
import lotr.common.util.CoinUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.living.EntityTeleportEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.richardsprojects.lotrcompanions.container.CompanionContainer;
import net.richardsprojects.lotrcompanions.container.CompanionEquipmentContainer;
import net.richardsprojects.lotrcompanions.npcs.HiredBreeGuard;
import net.richardsprojects.lotrcompanions.npcs.HiredGondorSoldier;
import net.richardsprojects.lotrcompanions.npcs.HiredUnitHelper;
import net.richardsprojects.lotrcompanions.npcs.LOTRCNpcs;
import net.richardsprojects.lotrcompanions.utils.TeleportHelper;

public class ForgeEntityEvents {
    @SubscribeEvent
    public static void giveExperience(LivingDeathEvent event) {
        Entity companion = event.getSource().func_76346_g();
        if (companion instanceof HiredGondorSoldier || companion instanceof HiredBreeGuard) {
            NPCEntitySettings settings = NPCEntitySettingsManager.getEntityTypeSettings((Entity)event.getEntity());
            int xpPoints = settings != null && settings.getKillAlignmentBonus() > 0.0f ? (int)settings.getKillAlignmentBonus() : 1;
            ((ExtendedHirableEntity)companion).giveExperiencePoints(xpPoints);
            ((ExtendedHirableEntity)companion).setMobKills(((ExtendedHirableEntity)companion).getMobKills() + 1);
        }
    }

    @SubscribeEvent
    public static void playerCloseInventory(PlayerContainerEvent.Close event) {
        if (!(event.getContainer() instanceof CompanionContainer) && !(event.getContainer() instanceof CompanionEquipmentContainer)) {
            return;
        }
        Entity entity = event.getContainer() instanceof CompanionContainer ? event.getPlayer().field_70170_p.func_73045_a(((CompanionContainer)event.getContainer()).getEntityId()) : event.getPlayer().field_70170_p.func_73045_a(((CompanionEquipmentContainer)event.getContainer()).getEntityId());
        if (event.getContainer() instanceof CompanionContainer) {
            if (entity instanceof HiredGondorSoldier) {
                ((HiredGondorSoldier)entity).setInventoryOpen(false);
            } else if (entity instanceof HiredBreeGuard) {
                ((HiredBreeGuard)entity).setInventoryOpen(false);
            }
        } else if (event.getContainer() instanceof CompanionEquipmentContainer) {
            if (entity instanceof HiredGondorSoldier) {
                ((HiredGondorSoldier)entity).setEquipmentOpen(false);
            } else if (entity instanceof HiredBreeGuard) {
                ((HiredBreeGuard)entity).setEquipmentOpen(false);
            }
        }
    }

    @SubscribeEvent
    public static void lotrEntityDeathEvent(LivingDropsEvent event) {
        if (!(event.getEntity() instanceof NPCEntity)) {
            return;
        }
        if (!(event.getEntity() instanceof ManEntity || event.getEntity() instanceof ElfEntity || event.getEntity() instanceof DwarfEntity || event.getEntity() instanceof OrcEntity)) {
            return;
        }
        HashSet items = new HashSet();
        event.getDrops().forEach(e -> items.add(e.func_92059_d().func_77973_b()));
        if (!items.contains(ExtendedItems.SILVER_COIN_ONE.get())) {
            ItemEntity entity = new ItemEntity(event.getEntity().field_70170_p, event.getEntity().func_226277_ct_(), event.getEntity().func_226278_cu_(), event.getEntity().func_226281_cx_(), new ItemStack((IItemProvider)ExtendedItems.SILVER_COIN_ONE.get(), new Random().nextInt(2) + 1));
            event.getDrops().add(entity);
        }
    }

    @SubscribeEvent
    public static void hireGondorSoldier(PlayerInteractEvent.EntityInteract event) {
        if (!(event.getWorld() instanceof ServerWorld)) {
            return;
        }
        if (!(event.getTarget() instanceof GondorSoldierEntity)) {
            return;
        }
        if (event.getTarget() instanceof HiredGondorSoldier) {
            return;
        }
        if (!CoinUtils.isValidCoin((ItemStack)event.getItemStack())) {
            return;
        }
        int coins = CoinUtils.totalValueInPlayerInventory((PlayerInventory)event.getPlayer().field_71071_by);
        if (coins < 60) {
            event.getPlayer().func_145747_a((ITextComponent)new StringTextComponent("I require 60 coins in payment to be hired."), event.getPlayer().func_110124_au());
            return;
        }
        GondorSoldierEntity gondorSoldier = (GondorSoldierEntity)event.getTarget();
        HiredGondorSoldier newEntity = (HiredGondorSoldier)((EntityType)LOTRCNpcs.HIRED_GONDOR_SOLDIER.get()).func_220331_a((ServerWorld)event.getWorld(), null, event.getPlayer(), new BlockPos(gondorSoldier.func_226277_ct_(), gondorSoldier.func_226278_cu_(), gondorSoldier.func_226281_cx_()), SpawnReason.NATURAL, false, false);
        if (newEntity != null) {
            newEntity.tame(event.getPlayer());
            gondorSoldier.func_70106_y();
            CoinUtils.removeCoins((PlayerEntity)event.getPlayer(), (PlayerInventory)event.getPlayer().field_71071_by, (int)60);
            event.getPlayer().func_145747_a((ITextComponent)new StringTextComponent("The Gondor Soldier has been hired for 60 coins"), event.getPlayer().func_110124_au());
        }
    }

    @SubscribeEvent
    public static void hireBreeGuard(PlayerInteractEvent.EntityInteract event) {
        if (!(event.getWorld() instanceof ServerWorld)) {
            return;
        }
        if (!(event.getTarget() instanceof BreeGuardEntity)) {
            return;
        }
        if (event.getTarget() instanceof HiredBreeGuard) {
            return;
        }
        if (!CoinUtils.isValidCoin((ItemStack)event.getItemStack())) {
            return;
        }
        int coins = CoinUtils.totalValueInInventory((IInventory)event.getPlayer().field_71071_by);
        if (coins < 40) {
            event.getPlayer().func_145747_a((ITextComponent)new StringTextComponent("I require 40 coins in payment to be hired."), event.getPlayer().func_110124_au());
            return;
        }
        BreeGuardEntity breeGuard = (BreeGuardEntity)event.getTarget();
        HiredBreeGuard newEntity = (HiredBreeGuard)((EntityType)LOTRCNpcs.HIRED_BREE_GUARD.get()).func_220331_a((ServerWorld)event.getWorld(), null, event.getPlayer(), new BlockPos(breeGuard.func_226277_ct_(), breeGuard.func_226278_cu_(), breeGuard.func_226281_cx_()), SpawnReason.NATURAL, false, false);
        if (newEntity != null) {
            newEntity.tame(event.getPlayer());
            breeGuard.func_70106_y();
            CoinUtils.removeCoins((PlayerEntity)event.getPlayer(), (PlayerInventory)event.getPlayer().field_71071_by, (int)40);
            event.getPlayer().func_145747_a((ITextComponent)new StringTextComponent("The Bree-land Guard has been hired for 40 coins"), event.getPlayer().func_110124_au());
        }
    }

    @SubscribeEvent
    public static void onPlayerTeleport(EntityTeleportEvent event) {
        if (!(event.getEntity() instanceof PlayerEntity)) {
            return;
        }
        if (!(event.getEntity().field_70170_p instanceof ServerWorld)) {
            return;
        }
        ServerWorld world = (ServerWorld)event.getEntity().field_70170_p;
        BlockPos originalPos = new BlockPos(event.getPrevX(), event.getPrevY(), event.getPrevZ());
        BlockPos targetPos = new BlockPos(event.getTargetX(), event.getTargetY(), event.getTargetZ());
        TeleportHelper.teleportUnitsToPlayer(originalPos, targetPos, world, (PlayerEntity)event.getEntity());
    }

    @SubscribeEvent
    public static void preventFriendlyFireFromPlayerToCompanion(LivingAttackEvent event) {
        ExtendedHirableEntity hired = HiredUnitHelper.getExtendedHirableEntity(event.getEntity());
        if (hired == null) {
            return;
        }
        UUID owner = hired.getOwnerUUID();
        if (event.getSource() == null) {
            return;
        }
        if (event.getSource() != null && event.getSource().func_76346_g() != null && event.getSource().func_76346_g() instanceof PlayerEntity) {
            ExtendedLog.info((String)"Inside if statement");
            PlayerEntity player = (PlayerEntity)event.getSource().func_76346_g();
            if (owner.equals(player.func_110124_au())) {
                event.setCanceled(true);
            }
        }
    }
}

