/*
 * Decompiled with CFR 0.152.
 */
package net.richardsprojects.lotrcompanions.networking;

import io.netty.buffer.Unpooled;
import java.util.Objects;
import java.util.function.Supplier;
import lotr.common.entity.npc.ExtendedHirableEntity;
import lotr.common.entity.npc.NPCEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkHooks;
import net.richardsprojects.lotrcompanions.container.CompanionContainer;
import net.richardsprojects.lotrcompanions.container.CompanionsContainers;
import net.richardsprojects.lotrcompanions.npcs.HiredBreeGuard;
import net.richardsprojects.lotrcompanions.npcs.HiredGondorSoldier;

public class CompanionsClientOpenMenuPacket {
    private final int entityId;

    public CompanionsClientOpenMenuPacket(int entityId) {
        this.entityId = entityId;
    }

    public static CompanionsClientOpenMenuPacket decode(PacketBuffer buf) {
        return new CompanionsClientOpenMenuPacket(buf.readInt());
    }

    public static void encode(CompanionsClientOpenMenuPacket msg, PacketBuffer buf) {
        buf.writeInt(msg.entityId);
    }

    public int getId() {
        return this.entityId;
    }

    public int getEntityId() {
        return this.entityId;
    }

    public static void handle(CompanionsClientOpenMenuPacket msg, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            Entity entity = Objects.requireNonNull(((NetworkEvent.Context)context.get()).getSender()).field_70170_p.func_73045_a(msg.entityId);
            PacketBuffer initData = new PacketBuffer(Unpooled.buffer());
            CompanionContainer.writeContainerInitData(initData, msg.entityId);
            ExtendedHirableEntity hirableEntity = null;
            if (entity instanceof ExtendedHirableEntity) {
                hirableEntity = (ExtendedHirableEntity)entity;
            }
            if (entity instanceof NPCEntity) {
                NPCEntity npcEntity = (NPCEntity)entity;
                if (npcEntity instanceof HiredBreeGuard) {
                    ((HiredBreeGuard)npcEntity).setEquipmentOpen(true);
                }
                if (npcEntity instanceof HiredGondorSoldier) {
                    ((HiredGondorSoldier)npcEntity).setEquipmentOpen(true);
                }
            }
            assert (hirableEntity != null);
            NetworkHooks.openGui((ServerPlayerEntity)Objects.requireNonNull(((NetworkEvent.Context)context.get()).getSender()), (INamedContainerProvider)new SimpleNamedContainerProvider((windowId, playerInventory, player) -> (CompanionContainer)((ContainerType)CompanionsContainers.COMPANION_MAIN_CONTAINER.get()).create(windowId, playerInventory, initData), hirableEntity.getHiredUnitName()), buf -> CompanionContainer.writeContainerInitData(buf, msg.entityId));
            ((NetworkEvent.Context)context.get()).setPacketHandled(true);
        });
    }
}

