/*
 * Decompiled with CFR 0.152.
 */
package net.richardsprojects.lotrcompanions.npcs;

import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import lotr.common.entity.npc.ExtendedHirableEntity;
import lotr.common.entity.npc.GondorSoldierEntity;
import lotr.common.entity.npc.NPCEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.OpenDoorGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.richardsprojects.lotrcompanions.core.PacketHandler;
import net.richardsprojects.lotrcompanions.networking.CompanionsClientOpenMenuPacket;
import net.richardsprojects.lotrcompanions.npcs.HiredUnitHelper;
import net.richardsprojects.lotrcompanions.npcs.ai.CustomFollowOwnerGoal;
import net.richardsprojects.lotrcompanions.npcs.ai.CustomOwnerHurtByTargetGoal;
import net.richardsprojects.lotrcompanions.npcs.ai.CustomOwnerHurtTargetGoal;
import net.richardsprojects.lotrcompanions.npcs.ai.CustomSitGoal;
import net.richardsprojects.lotrcompanions.npcs.ai.CustomWaterAvoidingRandomWalkingGoal;
import net.richardsprojects.lotrcompanions.utils.Constants;

public class HiredGondorSoldier
extends GondorSoldierEntity
implements ExtendedHirableEntity {
    private static final int HEAL_RATE = 80;
    private int lastHealed = 0;
    protected static final DataParameter<Byte> DATA_FLAGS_ID = EntityDataManager.func_187226_a(HiredGondorSoldier.class, (IDataSerializer)DataSerializers.field_187191_a);
    protected static final DataParameter<Optional<UUID>> DATA_OWNERUUID_ID = EntityDataManager.func_187226_a(HiredGondorSoldier.class, (IDataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<Integer> LVL = EntityDataManager.func_187226_a(HiredGondorSoldier.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> CURRENT_XP = EntityDataManager.func_187226_a(HiredGondorSoldier.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> BASE_HEALTH = EntityDataManager.func_187226_a(HiredGondorSoldier.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> MAX_XP = EntityDataManager.func_187226_a(HiredGondorSoldier.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> KILLS = EntityDataManager.func_187226_a(HiredGondorSoldier.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> FOLLOWING = EntityDataManager.func_187226_a(HiredGondorSoldier.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> STATIONARY = EntityDataManager.func_187226_a(HiredGondorSoldier.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> PATROLLING = EntityDataManager.func_187226_a(HiredGondorSoldier.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> ALERT = EntityDataManager.func_187226_a(HiredGondorSoldier.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> GUARDING = EntityDataManager.func_187226_a(HiredGondorSoldier.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Float> TMP_LAST_HEALTH = EntityDataManager.func_187226_a(HiredGondorSoldier.class, (IDataSerializer)DataSerializers.field_187193_c);
    private boolean tmpHealthLoaded = false;
    private boolean healthUpdateFromTmpHealth = false;
    private static final DataParameter<Boolean> INVENTORY_OPEN = EntityDataManager.func_187226_a(HiredGondorSoldier.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<ItemStack> EQUIPMENT_CHEST = EntityDataManager.func_187226_a(HiredGondorSoldier.class, (IDataSerializer)DataSerializers.field_187196_f);
    private static final DataParameter<ItemStack> EQUIPMENT_HEAD = EntityDataManager.func_187226_a(HiredGondorSoldier.class, (IDataSerializer)DataSerializers.field_187196_f);
    private static final DataParameter<ItemStack> EQUIPMENT_LEGS = EntityDataManager.func_187226_a(HiredGondorSoldier.class, (IDataSerializer)DataSerializers.field_187196_f);
    private static final DataParameter<ItemStack> EQUIPMENT_FEET = EntityDataManager.func_187226_a(HiredGondorSoldier.class, (IDataSerializer)DataSerializers.field_187196_f);
    private static final DataParameter<ItemStack> EQUIPMENT_MAINHAND = EntityDataManager.func_187226_a(HiredGondorSoldier.class, (IDataSerializer)DataSerializers.field_187196_f);
    private static final DataParameter<ItemStack> EQUIPMENT_OFFHAND = EntityDataManager.func_187226_a(HiredGondorSoldier.class, (IDataSerializer)DataSerializers.field_187196_f);
    private static final DataParameter<Boolean> EQUIPMENT_OPEN = EntityDataManager.func_187226_a(HiredGondorSoldier.class, (IDataSerializer)DataSerializers.field_187198_h);
    public Inventory inventory = new Inventory(15);
    private static ItemStack[] baseGear = new ItemStack[]{Constants.GONDOR_SOLDIER_HEAD, Constants.GONDOR_SOLDIER_CHEST, Constants.GONDOR_SOLDIER_LEGS, Constants.GONDOR_SOLDIER_FEET, Constants.GONDOR_SOLDIER_MAINHAND, Constants.GONDOR_SOLDIER_OFFHAND};

    protected void addConsumingGoals(int prio) {
    }

    protected void addNPCAI() {
        ((GroundPathNavigator)this.func_70661_as()).func_179688_b(true);
        this.func_70661_as().func_212239_d(true);
        this.func_184644_a(PathNodeType.DANGER_FIRE, 16.0f);
        this.func_184644_a(PathNodeType.DAMAGE_FIRE, -1.0f);
        this.initialiseAttackGoals(this.getAttackGoalsHolder());
        this.addNPCTargetingAI();
        this.addAttackGoal(2);
    }

    public HiredGondorSoldier(EntityType<? extends GondorSoldierEntity> entityType, World level) {
        super(entityType, level);
        this.func_110163_bv();
        this.field_70180_af.func_187227_b(EQUIPMENT_HEAD, (Object)baseGear[0]);
        this.field_70180_af.func_187227_b(EQUIPMENT_CHEST, (Object)baseGear[1]);
        this.field_70180_af.func_187227_b(EQUIPMENT_LEGS, (Object)baseGear[2]);
        this.field_70180_af.func_187227_b(EQUIPMENT_FEET, (Object)baseGear[3]);
        this.field_70180_af.func_187227_b(EQUIPMENT_MAINHAND, (Object)baseGear[4]);
        this.field_70180_af.func_187227_b(EQUIPMENT_OFFHAND, (Object)baseGear[5]);
        this.setTame(false);
    }

    public void updateFeetSlot(ItemStack stack) {
        this.field_70180_af.func_187227_b(EQUIPMENT_FEET, (Object)stack);
    }

    public void updateHeadSlot(ItemStack stack) {
        this.field_70180_af.func_187227_b(EQUIPMENT_HEAD, (Object)stack);
    }

    public void updateChestSlot(ItemStack stack) {
        this.field_70180_af.func_187227_b(EQUIPMENT_CHEST, (Object)stack);
    }

    public void updateLegsSlot(ItemStack stack) {
        this.field_70180_af.func_187227_b(EQUIPMENT_LEGS, (Object)stack);
    }

    public void updateMainhandSlot(ItemStack stack) {
        this.field_70180_af.func_187227_b(EQUIPMENT_MAINHAND, (Object)stack);
    }

    public void updateOffhandSlot(ItemStack stack) {
        this.field_70180_af.func_187227_b(EQUIPMENT_OFFHAND, (Object)stack);
    }

    public Inventory getCustomInventory() {
        return this.inventory;
    }

    public ItemStack func_213357_a(World world, ItemStack stack) {
        if (stack.func_222117_E()) {
            this.func_70691_i(stack.func_77973_b().func_219967_s().func_221466_a());
        }
        super.func_213357_a(world, stack);
        return stack;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_FLAGS_ID, (Object)0);
        this.field_70180_af.func_187214_a(DATA_OWNERUUID_ID, Optional.empty());
        this.field_70180_af.func_187214_a(LVL, (Object)1);
        this.field_70180_af.func_187214_a(CURRENT_XP, (Object)0);
        this.field_70180_af.func_187214_a(MAX_XP, (Object)1);
        this.field_70180_af.func_187214_a(KILLS, (Object)0);
        this.field_70180_af.func_187214_a(FOLLOWING, (Object)false);
        this.field_70180_af.func_187214_a(GUARDING, (Object)false);
        this.field_70180_af.func_187214_a(PATROLLING, (Object)false);
        this.field_70180_af.func_187214_a(ALERT, (Object)false);
        this.field_70180_af.func_187214_a(STATIONARY, (Object)false);
        this.field_70180_af.func_187214_a(BASE_HEALTH, (Object)30);
        this.field_70180_af.func_187214_a(INVENTORY_OPEN, (Object)false);
        this.field_70180_af.func_187214_a(EQUIPMENT_OPEN, (Object)false);
        this.field_70180_af.func_187214_a(TMP_LAST_HEALTH, (Object)Float.valueOf(30.0f));
        this.field_70180_af.func_187214_a(EQUIPMENT_CHEST, (Object)ItemStack.field_190927_a);
        this.field_70180_af.func_187214_a(EQUIPMENT_HEAD, (Object)ItemStack.field_190927_a);
        this.field_70180_af.func_187214_a(EQUIPMENT_LEGS, (Object)ItemStack.field_190927_a);
        this.field_70180_af.func_187214_a(EQUIPMENT_FEET, (Object)ItemStack.field_190927_a);
        this.field_70180_af.func_187214_a(EQUIPMENT_MAINHAND, (Object)ItemStack.field_190927_a);
        this.field_70180_af.func_187214_a(EQUIPMENT_OFFHAND, (Object)ItemStack.field_190927_a);
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return GondorSoldierEntity.regAttrs().func_233815_a_(Attributes.field_233819_b_, 20.0).func_233815_a_(Attributes.field_233818_a_, 20.0).func_233815_a_(Attributes.field_233823_f_, 1.0).func_233815_a_(Attributes.field_233821_d_, 0.32);
    }

    public void synchronizeEquipment() {
        if (((ItemStack)this.field_70180_af.func_187225_a(EQUIPMENT_HEAD)).func_190926_b()) {
            this.func_184201_a(EquipmentSlotType.HEAD, baseGear[0]);
            this.inventory.func_70299_a(9, ItemStack.field_190927_a);
        } else {
            this.func_184201_a(EquipmentSlotType.HEAD, (ItemStack)this.field_70180_af.func_187225_a(EQUIPMENT_HEAD));
            this.inventory.func_70299_a(9, (ItemStack)this.field_70180_af.func_187225_a(EQUIPMENT_HEAD));
        }
        if (((ItemStack)this.field_70180_af.func_187225_a(EQUIPMENT_CHEST)).func_190926_b()) {
            this.func_184201_a(EquipmentSlotType.CHEST, baseGear[1]);
            this.inventory.func_70299_a(10, ItemStack.field_190927_a);
        } else {
            this.func_184201_a(EquipmentSlotType.CHEST, (ItemStack)this.field_70180_af.func_187225_a(EQUIPMENT_CHEST));
            this.inventory.func_70299_a(10, (ItemStack)this.field_70180_af.func_187225_a(EQUIPMENT_CHEST));
        }
        if (((ItemStack)this.field_70180_af.func_187225_a(EQUIPMENT_LEGS)).func_190926_b()) {
            this.func_184201_a(EquipmentSlotType.LEGS, baseGear[2]);
            this.inventory.func_70299_a(11, ItemStack.field_190927_a);
        } else {
            this.func_184201_a(EquipmentSlotType.LEGS, (ItemStack)this.field_70180_af.func_187225_a(EQUIPMENT_LEGS));
            this.inventory.func_70299_a(11, (ItemStack)this.field_70180_af.func_187225_a(EQUIPMENT_LEGS));
        }
        if (((ItemStack)this.field_70180_af.func_187225_a(EQUIPMENT_FEET)).func_190926_b()) {
            this.func_184201_a(EquipmentSlotType.FEET, baseGear[3]);
            this.inventory.func_70299_a(12, ItemStack.field_190927_a);
        } else {
            this.func_184201_a(EquipmentSlotType.FEET, (ItemStack)this.field_70180_af.func_187225_a(EQUIPMENT_FEET));
            this.inventory.func_70299_a(12, (ItemStack)this.field_70180_af.func_187225_a(EQUIPMENT_FEET));
        }
        if (((ItemStack)this.field_70180_af.func_187225_a(EQUIPMENT_MAINHAND)).func_190926_b()) {
            this.func_184201_a(EquipmentSlotType.MAINHAND, baseGear[4]);
            this.inventory.func_70299_a(13, ItemStack.field_190927_a);
        } else {
            this.func_184201_a(EquipmentSlotType.MAINHAND, (ItemStack)this.field_70180_af.func_187225_a(EQUIPMENT_MAINHAND));
            this.inventory.func_70299_a(13, (ItemStack)this.field_70180_af.func_187225_a(EQUIPMENT_MAINHAND));
        }
        if (!this.func_184582_a(EquipmentSlotType.OFFHAND).func_222117_E()) {
            if (((ItemStack)this.field_70180_af.func_187225_a(EQUIPMENT_OFFHAND)).func_190926_b()) {
                this.func_184201_a(EquipmentSlotType.OFFHAND, baseGear[5]);
                this.inventory.func_70299_a(14, ItemStack.field_190927_a);
            } else {
                this.func_184201_a(EquipmentSlotType.OFFHAND, (ItemStack)this.field_70180_af.func_187225_a(EQUIPMENT_OFFHAND));
                this.inventory.func_70299_a(14, (ItemStack)this.field_70180_af.func_187225_a(EQUIPMENT_OFFHAND));
            }
        }
    }

    public void setExpLvl(int lvl) {
        this.field_70180_af.func_187227_b(LVL, (Object)lvl);
    }

    public int getExpLvl() {
        return (Integer)this.field_70180_af.func_187225_a(LVL);
    }

    public void setMobKills(int kills) {
        this.field_70180_af.func_187227_b(KILLS, (Object)kills);
    }

    public int getMobKills() {
        return (Integer)this.field_70180_af.func_187225_a(KILLS);
    }

    public ITextComponent getHiredUnitName() {
        return new TranslationTextComponent("entity.lotr.shortname.hired_gondor_soldier", new Object[]{new StringTextComponent(this.getPersonalInfo().getName())});
    }

    public ItemStack checkFood() {
        for (int i = 0; i < 9; ++i) {
            ItemStack itemstack = this.inventory.func_70301_a(i);
            if (!itemstack.func_222117_E()) continue;
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    public void setCurrentXp(int currentXp) {
        this.field_70180_af.func_187227_b(CURRENT_XP, (Object)currentXp);
    }

    public int getCurrentXp() {
        return (Integer)this.field_70180_af.func_187225_a(CURRENT_XP);
    }

    public boolean isInventoryOpen() {
        return (Boolean)this.field_70180_af.func_187225_a(INVENTORY_OPEN);
    }

    public void setMaxXp(int maxXp) {
        this.field_70180_af.func_187227_b(MAX_XP, (Object)maxXp);
    }

    public void setInventoryOpen(boolean isOpen) {
        this.field_70180_af.func_187227_b(INVENTORY_OPEN, (Object)isOpen);
    }

    public boolean isEquipmentOpen() {
        return (Boolean)this.field_70180_af.func_187225_a(EQUIPMENT_OPEN);
    }

    public void setEquipmentOpen(boolean isOpen) {
        this.field_70180_af.func_187227_b(EQUIPMENT_OPEN, (Object)isOpen);
    }

    public int getMaxXp() {
        return (Integer)this.field_70180_af.func_187225_a(MAX_XP);
    }

    public void setBaseHealth(int health) {
        this.field_70180_af.func_187227_b(BASE_HEALTH, (Object)health);
    }

    public int getBaseHealth() {
        return (Integer)this.field_70180_af.func_187225_a(BASE_HEALTH);
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        if (hand == Hand.MAIN_HAND) {
            if (this.func_184191_r((Entity)player) && this.field_70170_p.func_201670_d()) {
                PacketHandler.sendToServer(new CompanionsClientOpenMenuPacket(this.func_145782_y()));
            }
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.func_201670_d());
        }
        return super.func_230254_b_(player, hand);
    }

    public boolean func_184191_r(Entity p_184191_1_) {
        if (this.isTame()) {
            LivingEntity livingentity = this.getOwner();
            if (p_184191_1_ == livingentity) {
                return true;
            }
            if (livingentity != null) {
                return livingentity.func_184191_r(p_184191_1_);
            }
        }
        return super.func_184191_r(p_184191_1_);
    }

    @Nullable
    public UUID getOwnerUUID() {
        return ((Optional)this.field_70180_af.func_187225_a(DATA_OWNERUUID_ID)).orElse(null);
    }

    public void setOwnerUUID(@Nullable UUID p_184754_1_) {
        this.field_70180_af.func_187227_b(DATA_OWNERUUID_ID, Optional.ofNullable(p_184754_1_));
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new CustomSitGoal((NPCEntity)this, this));
        this.field_70714_bg.func_75776_a(3, (Goal)new CustomFollowOwnerGoal((NPCEntity)this, this, 1.3, 8.0f, 2.0f, false));
        this.field_70714_bg.func_75776_a(5, (Goal)new CustomWaterAvoidingRandomWalkingGoal((NPCEntity)this, this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(8, (Goal)new OpenDoorGoal((MobEntity)this, true));
        this.field_70715_bh.func_75776_a(1, (Goal)new CustomOwnerHurtByTargetGoal((NPCEntity)this, this));
        this.field_70715_bh.func_75776_a(2, (Goal)new CustomOwnerHurtTargetGoal((NPCEntity)this, this));
        this.field_70715_bh.func_75776_a(3, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]).func_220794_a(new Class[0]));
    }

    public boolean wantsToAttack(LivingEntity p_142018_1_, LivingEntity p_142018_2_) {
        return true;
    }

    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        if (this.getOwnerUUID() != null) {
            tag.func_186854_a("Owner", this.getOwnerUUID());
        }
        NonNullList items = NonNullList.func_191197_a((int)15, (Object)ItemStack.field_190927_a);
        for (int i = 0; i < 15; ++i) {
            ItemStack item = this.inventory.func_70301_a(i);
            if (item != null) {
                items.set(i, (Object)item);
                continue;
            }
            items.set(i, (Object)ItemStack.field_190927_a);
        }
        ItemStackHelper.func_191282_a((CompoundNBT)tag, (NonNullList)items);
        tag.func_74757_a("following", this.isFollowing());
        tag.func_74757_a("stationary", this.isStationary());
        tag.func_74768_a("mob_kills", this.getMobKills());
        tag.func_74768_a("xp_level", this.getExpLvl());
        tag.func_74768_a("current_xp", this.getCurrentXp());
        tag.func_74768_a("max_xp", this.getMaxXp());
        tag.func_74768_a("base_health", this.getBaseHealth());
        tag.func_74776_a("tmp_last_health", this.func_110143_aJ());
    }

    private float getTmpLastHealth() {
        return ((Float)this.field_70180_af.func_187225_a(TMP_LAST_HEALTH)).floatValue();
    }

    public boolean isFollowing() {
        return (Boolean)this.field_70180_af.func_187225_a(FOLLOWING);
    }

    public boolean isPatrolling() {
        return (Boolean)this.field_70180_af.func_187225_a(PATROLLING);
    }

    public float getHiredUnitMaxHealth() {
        return this.func_110138_aP();
    }

    public float getHiredUnitHealth() {
        return this.func_110143_aJ();
    }

    public boolean isAlert() {
        return (Boolean)this.field_70180_af.func_187225_a(ALERT);
    }

    public boolean isStationary() {
        return (Boolean)this.field_70180_af.func_187225_a(STATIONARY);
    }

    public void setStationary(boolean stationary) {
        this.field_70180_af.func_187227_b(STATIONARY, (Object)stationary);
    }

    public void setFollowing(boolean following) {
        this.field_70180_af.func_187227_b(FOLLOWING, (Object)following);
    }

    public void tame(PlayerEntity p_193101_1_) {
        this.setTame(true);
        this.setOwnerUUID(p_193101_1_.func_110124_au());
        this.setFollowing(true);
    }

    public void setTame(boolean p_70903_1_) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(DATA_FLAGS_ID);
        if (p_70903_1_) {
            this.field_70180_af.func_187227_b(DATA_FLAGS_ID, (Object)((byte)(b0 | 4)));
        } else {
            this.field_70180_af.func_187227_b(DATA_FLAGS_ID, (Object)((byte)(b0 & 0xFFFFFFFB)));
        }
    }

    @Nullable
    public LivingEntity getOwner() {
        try {
            UUID uuid = this.getOwnerUUID();
            return uuid == null ? null : this.field_70170_p.func_217371_b(uuid);
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return null;
        }
    }

    public void func_70037_a(CompoundNBT tag) {
        UUID uuid;
        super.func_70037_a(tag);
        if (tag.func_186855_b("Owner")) {
            uuid = tag.func_186857_a("Owner");
        } else {
            String ownerString = tag.func_74779_i("Owner");
            uuid = PreYggdrasilConverter.func_187473_a((MinecraftServer)this.func_184102_h(), (String)ownerString);
        }
        if (uuid != null) {
            try {
                this.setOwnerUUID(uuid);
                this.setTame(true);
            }
            catch (Throwable var4) {
                this.setTame(false);
            }
        }
        NonNullList itemsStacks = NonNullList.func_191197_a((int)15, (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((CompoundNBT)tag, (NonNullList)itemsStacks);
        for (int i = 0; i < 15; ++i) {
            ItemStack itemStack = (ItemStack)itemsStacks.get(i);
            if (itemStack.equals(ItemStack.field_190927_a)) continue;
            this.inventory.func_70299_a(i, (ItemStack)itemsStacks.get(i));
        }
        this.initializeEquipmentServerSide();
        if (tag.func_74764_b("following")) {
            this.setFollowing(tag.func_74767_n("following"));
        }
        if (tag.func_74764_b("xp_level")) {
            this.setExpLvl(tag.func_74762_e("xp_level"));
        }
        if (tag.func_74764_b("current_xp")) {
            this.setCurrentXp(tag.func_74762_e("current_xp"));
        }
        if (tag.func_74764_b("max_xp")) {
            this.setMaxXp(tag.func_74762_e("max_xp"));
        }
        if (tag.func_74764_b("mob_kills")) {
            this.setMobKills(tag.func_74762_e("mob_kills"));
        }
        if (tag.func_74764_b("base_health")) {
            this.setBaseHealth(tag.func_74762_e("base_health"));
        }
        if (tag.func_74764_b("tmp_last_health")) {
            this.field_70180_af.func_187227_b(TMP_LAST_HEALTH, (Object)Float.valueOf(tag.func_74760_g("tmp_last_health")));
            this.func_70606_j(tag.func_74760_g("tmp_last_health"));
            this.tmpHealthLoaded = true;
        }
        if (tag.func_74764_b("stationary")) {
            this.setStationary(tag.func_74767_n("stationary"));
        }
    }

    public void func_70071_h_() {
        if (this.lastHealed == 80) {
            if (this.func_110143_aJ() < this.func_110138_aP()) {
                this.func_70606_j(this.func_110143_aJ() + 1.0f);
            }
            this.lastHealed = 0;
        } else {
            ++this.lastHealed;
        }
        this.checkStats();
        this.synchronizeEquipment();
        if (this.tmpHealthLoaded && !this.healthUpdateFromTmpHealth) {
            this.func_70606_j(this.getTmpLastHealth());
            this.healthUpdateFromTmpHealth = true;
        }
        super.func_70071_h_();
    }

    public void func_70645_a(DamageSource p_70645_1_) {
        HiredUnitHelper.die(this.field_70170_p, p_70645_1_, this);
        super.func_70645_a(p_70645_1_);
    }

    public boolean isTame() {
        return ((Byte)this.field_70180_af.func_187225_a(DATA_FLAGS_ID) & 4) != 0;
    }

    public void checkStats() {
        if ((int)this.func_110138_aP() != this.getBaseHealth()) {
            this.modifyMaxHealth(this.getBaseHealth() - 30, "Base Health from current level", false);
        }
    }

    public void initializeEquipmentServerSide() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.inventory.func_70301_a(9).func_190926_b()) {
                this.field_70180_af.func_187227_b(EQUIPMENT_HEAD, (Object)baseGear[0]);
            } else {
                this.field_70180_af.func_187227_b(EQUIPMENT_HEAD, (Object)this.inventory.func_70301_a(9));
            }
            if (this.inventory.func_70301_a(10).func_190926_b()) {
                this.field_70180_af.func_187227_b(EQUIPMENT_CHEST, (Object)baseGear[1]);
            } else {
                this.field_70180_af.func_187227_b(EQUIPMENT_CHEST, (Object)this.inventory.func_70301_a(10));
            }
            if (this.inventory.func_70301_a(11).func_190926_b()) {
                this.field_70180_af.func_187227_b(EQUIPMENT_LEGS, (Object)baseGear[2]);
            } else {
                this.field_70180_af.func_187227_b(EQUIPMENT_LEGS, (Object)this.inventory.func_70301_a(11));
            }
            if (this.inventory.func_70301_a(12).func_190926_b()) {
                this.field_70180_af.func_187227_b(EQUIPMENT_FEET, (Object)baseGear[3]);
            } else {
                this.field_70180_af.func_187227_b(EQUIPMENT_FEET, (Object)this.inventory.func_70301_a(12));
            }
            if (this.inventory.func_70301_a(13).func_190926_b()) {
                this.field_70180_af.func_187227_b(EQUIPMENT_MAINHAND, (Object)baseGear[4]);
            } else {
                this.field_70180_af.func_187227_b(EQUIPMENT_MAINHAND, (Object)this.inventory.func_70301_a(13));
            }
            if (this.inventory.func_70301_a(14).func_190926_b()) {
                this.field_70180_af.func_187227_b(EQUIPMENT_OFFHAND, (Object)baseGear[5]);
            } else {
                this.field_70180_af.func_187227_b(EQUIPMENT_OFFHAND, (Object)this.inventory.func_70301_a(14));
            }
        }
        this.func_184201_a(EquipmentSlotType.HEAD, (ItemStack)this.field_70180_af.func_187225_a(EQUIPMENT_HEAD));
        this.func_184201_a(EquipmentSlotType.CHEST, (ItemStack)this.field_70180_af.func_187225_a(EQUIPMENT_CHEST));
        this.func_184201_a(EquipmentSlotType.LEGS, (ItemStack)this.field_70180_af.func_187225_a(EQUIPMENT_LEGS));
        this.func_184201_a(EquipmentSlotType.FEET, (ItemStack)this.field_70180_af.func_187225_a(EQUIPMENT_FEET));
        this.func_184201_a(EquipmentSlotType.OFFHAND, (ItemStack)this.field_70180_af.func_187225_a(EQUIPMENT_OFFHAND));
        this.func_184201_a(EquipmentSlotType.MAINHAND, (ItemStack)this.field_70180_af.func_187225_a(EQUIPMENT_MAINHAND));
    }

    public int getHiredUnitId() {
        return this.func_145782_y();
    }

    public void modifyMaxHealth(int change, String name, boolean permanent) {
        ModifiableAttributeInstance attributeInstance = this.func_110148_a(Attributes.field_233818_a_);
        Set modifiers = attributeInstance.func_225505_c_();
        if (!modifiers.isEmpty()) {
            for (AttributeModifier attributeModifier : modifiers) {
                if (attributeModifier == null || !attributeModifier.func_111166_b().equals(name)) continue;
                this.func_110148_a(Attributes.field_233818_a_).func_111124_b(attributeModifier);
            }
        }
        AttributeModifier HEALTH_MODIFIER = new AttributeModifier(name, (double)change, AttributeModifier.Operation.ADDITION);
        if (permanent) {
            attributeInstance.func_233769_c_(HEALTH_MODIFIER);
        } else {
            attributeInstance.func_233767_b_(HEALTH_MODIFIER);
        }
    }

    public void setHiredUnitHealth(float p_70606_1_) {
        this.func_70606_j(p_70606_1_);
    }

    public void giveExperiencePoints(int points) {
        HiredUnitHelper.giveExperiencePoints(this, points);
    }
}

