/*
 * Decompiled with CFR 0.152.
 */
package net.richardsprojects.lotrcompanions.npcs;

import lotr.common.entity.npc.ExtendedHirableEntity;
import lotr.common.entity.npc.NPCEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.richardsprojects.lotrcompanions.npcs.HiredBreeGuard;
import net.richardsprojects.lotrcompanions.npcs.HiredGondorSoldier;

public class HiredUnitHelper {
    public static void die(World world, DamageSource source, ExtendedHirableEntity unit) {
        if (!world.field_72995_K && world.func_82736_K().func_223586_b(GameRules.field_223609_l) && unit.getOwner() instanceof ServerPlayerEntity) {
            unit.getOwner().func_145747_a((ITextComponent)HiredUnitHelper.getCompanionDeathMessage(unit, source), unit.getOwnerUUID());
        }
    }

    private static TranslationTextComponent getCompanionDeathMessage(ExtendedHirableEntity unit, DamageSource source) {
        LivingEntity killer = null;
        if (unit instanceof LivingEntity) {
            killer = ((LivingEntity)unit).func_94060_bK();
        }
        String s = "death.attack." + source.field_76373_n;
        TranslationTextComponent companionName = new TranslationTextComponent("notification.hired_companion_prefix", new Object[]{unit.getHiredUnitName()});
        return killer != null ? new TranslationTextComponent(s, new Object[]{companionName, killer.func_145748_c_()}) : new TranslationTextComponent(s, new Object[]{companionName});
    }

    public static void giveExperiencePoints(ExtendedHirableEntity unit, int points) {
        int newExperience = unit.getCurrentXp() + points;
        if (newExperience >= unit.getMaxXp()) {
            unit.setExpLvl(unit.getExpLvl() + 1);
            int difference = newExperience - unit.getMaxXp();
            unit.setCurrentXp(difference);
            unit.setMaxXp(unit.getMaxXp() + 2);
            unit.setHiredUnitHealth(unit.getHiredUnitHealth() + 2.0f);
            unit.setBaseHealth(unit.getBaseHealth() + 2);
            if (unit.getOwner() != null) {
                unit.getOwner().func_145747_a((ITextComponent)new StringTextComponent("Your hired companion ").func_230529_a_(unit.getHiredUnitName()).func_240702_b_(" has reached level " + unit.getExpLvl() + "!"), unit.getOwnerUUID());
            }
        } else {
            unit.setCurrentXp(newExperience);
        }
    }

    public static boolean isEntityHiredUnit(Entity entity) {
        return entity instanceof HiredGondorSoldier || entity instanceof HiredBreeGuard;
    }

    public static ExtendedHirableEntity getExtendedHirableEntity(Entity entity) {
        if (!HiredUnitHelper.isEntityHiredUnit(entity)) {
            return null;
        }
        ExtendedHirableEntity result = null;
        if (entity instanceof HiredBreeGuard) {
            result = (ExtendedHirableEntity)entity;
        } else if (entity instanceof HiredGondorSoldier) {
            result = (ExtendedHirableEntity)entity;
        }
        return result;
    }

    public static boolean updateEquipmentSlot(NPCEntity companion, EquipmentSlotType slot, ItemStack item) {
        boolean result = false;
        if (companion instanceof HiredBreeGuard) {
            HiredBreeGuard guard = (HiredBreeGuard)companion;
            if (slot == EquipmentSlotType.FEET) {
                guard.updateFeetSlot(item);
                result = true;
            } else if (slot == EquipmentSlotType.HEAD) {
                guard.updateHeadSlot(item);
                result = true;
            } else if (slot == EquipmentSlotType.CHEST) {
                guard.updateChestSlot(item);
                result = true;
            } else if (slot == EquipmentSlotType.LEGS) {
                guard.updateLegsSlot(item);
                result = true;
            } else if (slot == EquipmentSlotType.MAINHAND) {
                guard.updateMainhandSlot(item);
                result = true;
            } else if (slot == EquipmentSlotType.OFFHAND) {
                guard.updateOffhandSlot(item);
                result = true;
            }
        } else if (companion instanceof HiredGondorSoldier) {
            HiredGondorSoldier soldier = (HiredGondorSoldier)companion;
            if (slot == EquipmentSlotType.FEET) {
                soldier.updateFeetSlot(item);
                result = true;
            } else if (slot == EquipmentSlotType.HEAD) {
                soldier.updateHeadSlot(item);
                result = true;
            } else if (slot == EquipmentSlotType.CHEST) {
                soldier.updateChestSlot(item);
                result = true;
            } else if (slot == EquipmentSlotType.LEGS) {
                soldier.updateLegsSlot(item);
                result = true;
            } else if (slot == EquipmentSlotType.MAINHAND) {
                soldier.updateMainhandSlot(item);
                result = true;
            } else if (slot == EquipmentSlotType.OFFHAND) {
                soldier.updateOffhandSlot(item);
                result = true;
            }
        }
        return result;
    }
}

