/*
 * Decompiled with CFR 0.152.
 */
package net.richardsprojects.lotrcompanions.npcs.ai;

import java.util.EnumSet;
import lotr.common.entity.npc.ExtendedHirableEntity;
import lotr.common.entity.npc.NPCEntity;
import net.minecraft.block.BlockState;
import net.minecraft.block.LeavesBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;

public class FollowOwnerGoal
extends Goal {
    private final NPCEntity entity;
    private final ExtendedHirableEntity hirable;
    private LivingEntity owner;
    private final IWorldReader level;
    private final double speedModifier;
    private final PathNavigator navigation;
    private int timeToRecalcPath;
    private final float stopDistance;
    private final float startDistance;
    private float oldWaterCost;
    private final boolean canFly;

    public FollowOwnerGoal(NPCEntity p_i225711_1_, ExtendedHirableEntity hirable, double p_i225711_2_, float p_i225711_4_, float p_i225711_5_, boolean p_i225711_6_) {
        this.entity = p_i225711_1_;
        this.hirable = hirable;
        this.level = p_i225711_1_.field_70170_p;
        this.speedModifier = p_i225711_2_;
        this.navigation = p_i225711_1_.func_70661_as();
        this.startDistance = p_i225711_4_;
        this.stopDistance = p_i225711_5_;
        this.canFly = p_i225711_6_;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        if (!(p_i225711_1_.func_70661_as() instanceof GroundPathNavigator) && !(p_i225711_1_.func_70661_as() instanceof FlyingPathNavigator)) {
            throw new IllegalArgumentException("Unsupported mob type for FollowOwnerGoal");
        }
    }

    public boolean func_75250_a() {
        LivingEntity livingentity = this.hirable.getOwner();
        if (livingentity == null) {
            return false;
        }
        if (livingentity.func_175149_v()) {
            return false;
        }
        if (this.entity.func_70068_e((Entity)livingentity) < (double)(this.startDistance * this.startDistance)) {
            return false;
        }
        this.owner = livingentity;
        return true;
    }

    public boolean func_75253_b() {
        if (this.navigation.func_75500_f()) {
            return false;
        }
        return !(this.entity.func_70068_e((Entity)this.owner) <= (double)(this.stopDistance * this.stopDistance));
    }

    public void func_75249_e() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.entity.func_184643_a(PathNodeType.WATER);
        this.entity.func_184644_a(PathNodeType.WATER, 0.0f);
    }

    public void func_75251_c() {
        this.owner = null;
        this.navigation.func_75499_g();
        this.entity.func_184644_a(PathNodeType.WATER, this.oldWaterCost);
    }

    public void func_75246_d() {
        this.entity.func_70671_ap().func_75651_a((Entity)this.owner, 10.0f, (float)this.entity.func_70646_bf());
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = 10;
            if (!this.entity.func_110167_bD() && !this.entity.func_184218_aH()) {
                if (this.entity.func_70068_e((Entity)this.owner) >= 144.0) {
                    this.teleportToOwner();
                } else {
                    this.navigation.func_75497_a((Entity)this.owner, this.speedModifier);
                }
            }
        }
    }

    private void teleportToOwner() {
        BlockPos blockpos = this.owner.func_233580_cy_();
        for (int i = 0; i < 10; ++i) {
            int j = this.randomIntInclusive(-3, 3);
            int k = this.randomIntInclusive(-1, 1);
            int l = this.randomIntInclusive(-3, 3);
            boolean flag = this.maybeTeleportTo(blockpos.func_177958_n() + j, blockpos.func_177956_o() + k, blockpos.func_177952_p() + l);
            if (!flag) continue;
            return;
        }
    }

    private boolean maybeTeleportTo(int p_226328_1_, int p_226328_2_, int p_226328_3_) {
        if (Math.abs((double)p_226328_1_ - this.owner.func_226277_ct_()) < 2.0 && Math.abs((double)p_226328_3_ - this.owner.func_226281_cx_()) < 2.0) {
            return false;
        }
        if (!this.canTeleportTo(new BlockPos(p_226328_1_, p_226328_2_, p_226328_3_))) {
            return false;
        }
        this.entity.func_70012_b((double)p_226328_1_ + 0.5, (double)p_226328_2_, (double)p_226328_3_ + 0.5, this.entity.field_70177_z, this.entity.field_70125_A);
        this.navigation.func_75499_g();
        return true;
    }

    private boolean canTeleportTo(BlockPos p_226329_1_) {
        PathNodeType pathnodetype = WalkNodeProcessor.func_237231_a_((IBlockReader)this.level, (BlockPos.Mutable)p_226329_1_.func_239590_i_());
        if (pathnodetype != PathNodeType.WALKABLE) {
            return false;
        }
        BlockState blockstate = this.level.func_180495_p(p_226329_1_.func_177977_b());
        if (!this.canFly && blockstate.func_177230_c() instanceof LeavesBlock) {
            return false;
        }
        BlockPos blockpos = p_226329_1_.func_177973_b((Vector3i)this.entity.func_233580_cy_());
        return this.level.func_226665_a__((Entity)this.entity, this.entity.func_174813_aQ().func_186670_a(blockpos));
    }

    private int randomIntInclusive(int p_226327_1_, int p_226327_2_) {
        return this.entity.func_70681_au().nextInt(p_226327_2_ - p_226327_1_ + 1) + p_226327_1_;
    }
}

