/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_transformer.ast.transform;

import io.github.douira.glsl_transformer.GLSLLexer;
import io.github.douira.glsl_transformer.GLSLParser;
import io.github.douira.glsl_transformer.ast.data.TypedTreeCache;
import io.github.douira.glsl_transformer.ast.node.TranslationUnit;
import io.github.douira.glsl_transformer.ast.node.basic.ASTNode;
import io.github.douira.glsl_transformer.ast.node.expression.Expression;
import io.github.douira.glsl_transformer.ast.node.external_declaration.ExternalDeclaration;
import io.github.douira.glsl_transformer.ast.node.statement.Statement;
import io.github.douira.glsl_transformer.ast.query.EmptyRoot;
import io.github.douira.glsl_transformer.ast.transform.ASTBuilder;
import io.github.douira.glsl_transformer.basic.CachingParser;
import io.github.douira.glsl_transformer.basic.EnhancedParser;
import io.github.douira.glsl_transformer.basic.ParserInterface;
import io.github.douira.glsl_transformer.cst.token_filter.TokenFilter;
import io.github.douira.glsl_transformer.tree.ExtendedContext;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import oculus.org.antlr.v4.runtime.RecognitionException;

public class ASTParser
implements ParserInterface {
    private static ASTParser INSTANCE;
    private final CachingParser parser = new CachingParser();
    private TypedTreeCache<ASTNode> buildCache = new TypedTreeCache();
    private CacheStrategy cacheStrategy = CacheStrategy.ALL_EXCLUDING_TRANSLATION_UNIT;

    public static ASTParser getInternalInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ASTParser();
        }
        return INSTANCE;
    }

    public void setBuildCacheSizeAndClear(int size) {
        this.buildCache = new TypedTreeCache(size);
    }

    public void setParseCacheSizeAndClear(int size) {
        this.parser.setParseCacheSizeAndClear(size);
    }

    public void setCacheStrategy(CacheStrategy cacheStrategy) {
        this.cacheStrategy = cacheStrategy;
    }

    @Override
    public GLSLLexer getLexer() {
        return this.parser.getLexer();
    }

    @Override
    public GLSLParser getParser() {
        return this.parser.getParser();
    }

    @Override
    public void setThrowParseErrors(boolean throwParseErrors) {
        this.parser.setThrowParseErrors(throwParseErrors);
    }

    @Override
    public void setParsingStrategy(EnhancedParser.ParsingStrategy parsingStrategy) {
        this.parser.setParsingStrategy(parsingStrategy);
    }

    @Override
    public void setSLLOnly() {
        this.parser.setSLLOnly();
    }

    @Override
    public void setLLOnly() {
        this.parser.setLLOnly();
    }

    @Override
    public void setParseTokenFilter(TokenFilter<?> parseTokenFilter) {
        this.parser.setParseTokenFilter(parseTokenFilter);
    }

    @Override
    public TokenFilter<?> getParseTokenFilter() {
        return this.parser.getParseTokenFilter();
    }

    public <RuleType extends ExtendedContext, ReturnType extends ASTNode> ReturnType parseNode(String input, ASTNode parentTreeMember, Class<RuleType> ruleType, Function<GLSLParser, RuleType> parseMethod, BiFunction<ASTBuilder, RuleType, ReturnType> visitMethod) throws RecognitionException {
        if (ruleType == GLSLParser.TranslationUnitContext.class) {
            throw new IllegalArgumentException("Translation units may not be parsed into another node, that makes no sense.");
        }
        if (this.cacheStrategy == CacheStrategy.NONE) {
            return ASTBuilder.buildSubtree(parentTreeMember, this.parser.parse(input, ruleType, parseMethod), visitMethod);
        }
        return (ReturnType)this.buildCache.cachedGet(input, ruleType, () -> ASTBuilder.build(new EmptyRoot(), this.parser.parse(input, ruleType, parseMethod), visitMethod)).cloneInto(parentTreeMember);
    }

    public <RuleType extends ExtendedContext, ReturnType extends ASTNode> ReturnType parseNodeSeparate(String input, Class<RuleType> ruleType, Function<GLSLParser, RuleType> parseMethod, BiFunction<ASTBuilder, RuleType, ReturnType> visitMethod) throws RecognitionException {
        if (this.cacheStrategy == CacheStrategy.NONE || this.cacheStrategy == CacheStrategy.ALL_EXCLUDING_TRANSLATION_UNIT && ruleType == GLSLParser.TranslationUnitContext.class) {
            return ASTBuilder.build(this.parser.parse(input, ruleType, parseMethod), visitMethod);
        }
        return (ReturnType)this.buildCache.cachedGet(input, ruleType, () -> ASTBuilder.build(new EmptyRoot(), this.parser.parse(input, ruleType, parseMethod), visitMethod)).cloneSeparate();
    }

    public TranslationUnit parseTranslationUnit(String input) throws RecognitionException {
        return this.parseNodeSeparate(input, GLSLParser.TranslationUnitContext.class, GLSLParser::translationUnit, ASTBuilder::visitTranslationUnit);
    }

    public ExternalDeclaration parseExternalDeclaration(ASTNode treeMember, String input) throws RecognitionException {
        return this.parseNode(input, treeMember, GLSLParser.ExternalDeclarationContext.class, GLSLParser::externalDeclaration, ASTBuilder::visitExternalDeclaration);
    }

    public Expression parseExpression(ASTNode treeMember, String input) throws RecognitionException {
        return this.parseNode(input, treeMember, GLSLParser.ExpressionContext.class, GLSLParser::expression, ASTBuilder::visitExpression);
    }

    public Statement parseStatement(ASTNode treeMember, String input) throws RecognitionException {
        return this.parseNode(input, treeMember, GLSLParser.StatementContext.class, GLSLParser::statement, ASTBuilder::visitStatement);
    }

    public ExternalDeclaration parseSeparateExternalDeclaration(String input) throws RecognitionException {
        return this.parseNodeSeparate(input, GLSLParser.ExternalDeclarationContext.class, GLSLParser::externalDeclaration, ASTBuilder::visitExternalDeclaration);
    }

    public Expression parseSeparateExpression(String input) throws RecognitionException {
        return this.parseNodeSeparate(input, GLSLParser.ExpressionContext.class, GLSLParser::expression, ASTBuilder::visitExpression);
    }

    public Statement parseSeparateStatement(String input) throws RecognitionException {
        return this.parseNodeSeparate(input, GLSLParser.StatementContext.class, GLSLParser::statement, ASTBuilder::visitStatement);
    }

    public List<ExternalDeclaration> parseExternalDeclarations(ASTNode treeMember, String ... inputs) {
        ArrayList<ExternalDeclaration> nodes = new ArrayList<ExternalDeclaration>(inputs.length);
        for (String input : inputs) {
            nodes.add(this.parseExternalDeclaration(treeMember, input));
        }
        return nodes;
    }

    public List<Expression> parseExpression(ASTNode treeMember, String ... inputs) {
        ArrayList<Expression> nodes = new ArrayList<Expression>(inputs.length);
        for (String input : inputs) {
            nodes.add(this.parseExpression(treeMember, input));
        }
        return nodes;
    }

    public List<Statement> parseStatements(ASTNode treeMember, String ... inputs) {
        ArrayList<Statement> nodes = new ArrayList<Statement>(inputs.length);
        for (String input : inputs) {
            nodes.add(this.parseStatement(treeMember, input));
        }
        return nodes;
    }

    public static enum CacheStrategy {
        ALL,
        ALL_EXCLUDING_TRANSLATION_UNIT,
        NONE;

    }
}

