/*
 * Decompiled with CFR 0.152.
 */
package io.github.douira.glsl_transformer.cst.core;

import io.github.douira.glsl_transformer.GLSLParser;
import io.github.douira.glsl_transformer.cst.core.CachePolicy;
import io.github.douira.glsl_transformer.cst.core.ConfigurableTransformation;
import io.github.douira.glsl_transformer.cst.core.SearchTerminals;
import io.github.douira.glsl_transformer.cst.core.target.HandlerTarget;
import io.github.douira.glsl_transformer.cst.core.target.ParsedReplaceTarget;
import io.github.douira.glsl_transformer.cst.core.target.TerminalReplaceTarget;
import io.github.douira.glsl_transformer.cst.core.target.WrapThrowTarget;
import io.github.douira.glsl_transformer.cst.transform.CSTInjectionPoint;
import io.github.douira.glsl_transformer.cst.transform.RunPhase;
import io.github.douira.glsl_transformer.cst.transform.lifecycle.ActivatableLifecycleUser;
import io.github.douira.glsl_transformer.job_parameter.JobParameters;
import io.github.douira.glsl_transformer.tree.ExtendedContext;
import io.github.douira.glsl_transformer.tree.TreeMember;
import io.github.douira.glsl_transformer.util.CompatUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class WrapIdentifier<T extends JobParameters>
extends ConfigurableTransformation<T> {
    protected Collection<String> detectionResultsDirect = new ArrayList<String>(0);
    protected Collection<String> externalDeclarationsDirect = new ArrayList<String>(0);
    private Supplier<ActivatableLifecycleUser<T>> wrapResultDetector = this.once(this::getWrapResultDetector);
    private Supplier<Collection<String>> detectionResults = this.once(this::getDetectionResults);
    private Supplier<String> parsedReplacement = this.once(this::getParsedReplacement);
    private Supplier<Function<GLSLParser, ExtendedContext>> parseMethod = this.once(this::getParseMethod);
    private Supplier<ActivatableLifecycleUser<T>> wrappingReplacer = this.once(this::getWrappingReplacer);
    private Supplier<Collection<HandlerTarget<T>>> wrapHandlerTargets = this.once(this::getWrapHandlerTargets);
    private Supplier<String> wrapTarget = this.once(this::getWrapTarget);
    private Supplier<ActivatableLifecycleUser<T>> injector = this.once(this::getInjector);
    private Supplier<CSTInjectionPoint> injectionLocation = this.once(this::getInjectionLocation);
    private Supplier<Collection<String>> injectionExternalDeclarations = this.once(this::getInjectionExternalDeclarations);

    @Override
    protected void setupGraph() {
        this.chainDependent(this.wrapResultDetector());
        this.chainDependent(this.wrappingReplacer());
        this.chainDependent(this.injector());
    }

    @Override
    public WrapIdentifier<T> activation(Supplier<Boolean> activation) {
        super.activation((Supplier)activation);
        return this;
    }

    public void addDetectionResult(String detectionResult) {
        this.detectionResultsDirect.add(detectionResult);
    }

    public void addExternalDeclaration(String externalDeclaration) {
        this.externalDeclarationsDirect.add(externalDeclaration);
    }

    protected ActivatableLifecycleUser<T> getWrapResultDetector() {
        Collection<String> staticDetects = this.detectionResults();
        if (staticDetects.size() == 1) {
            return new SearchTerminals().singleTarget(new WrapThrowTarget<T>(){

                @Override
                protected String getWrapResult() {
                    return WrapIdentifier.this.detectionResult();
                }
            });
        }
        return new SearchTerminals<T>(){
            List<String> detectsList;

            @Override
            public void resetState() {
                Collection<String> detects = WrapIdentifier.this.detectionResults();
                if (detects != this.detectsList) {
                    this.detectsList = new ArrayList<String>(detects);
                }
            }

            @Override
            protected Collection<HandlerTarget<T>> getTargets() {
                ArrayList targets = new ArrayList(this.detectsList.size());
                int i = 0;
                while (i < this.detectsList.size()) {
                    final int index = i++;
                    targets.add(new WrapThrowTarget<T>(){

                        @Override
                        protected String getWrapResult() {
                            if (detectsList.size() <= index) {
                                return null;
                            }
                            return detectsList.get(index);
                        }
                    });
                }
                return targets;
            }
        };
    }

    protected Collection<String> getDetectionResults() {
        return this.detectionResultsDirect.isEmpty() ? CompatUtil.listOf(this.parsedReplacement()) : this.detectionResultsDirect;
    }

    protected String getParsedReplacement() {
        throw new IllegalStateException("No parsed replacement is set. This error can also occur if no detection results are set.");
    }

    protected Function<GLSLParser, ExtendedContext> getParseMethod() {
        return GLSLParser::expression;
    }

    protected ActivatableLifecycleUser<T> getWrappingReplacer() {
        return new SearchTerminals<T>(){

            @Override
            protected Collection<HandlerTarget<T>> getTargets() {
                return WrapIdentifier.this.wrapHandlerTargets();
            }
        };
    }

    protected Collection<HandlerTarget<T>> getWrapHandlerTargets() {
        try {
            this.parsedReplacement();
            return CompatUtil.listOf(new ParsedReplaceTarget<T>(){

                @Override
                public String getNeedle() {
                    return WrapIdentifier.this.wrapTarget();
                }

                @Override
                protected String getNewContent(TreeMember node, String match) {
                    return WrapIdentifier.this.parsedReplacement();
                }

                @Override
                protected Function<GLSLParser, ExtendedContext> getParseMethod(TreeMember node, String match) {
                    return WrapIdentifier.this.parseMethod();
                }
            });
        }
        catch (Exception e) {
            return CompatUtil.listOf(new TerminalReplaceTarget<T>(){

                @Override
                public String getNeedle() {
                    return WrapIdentifier.this.wrapTarget();
                }

                @Override
                protected String getTerminalContent() {
                    return WrapIdentifier.this.detectionResult();
                }
            });
        }
    }

    protected String getWrapTarget() {
        throw new IllegalStateException("No wrap target is set");
    }

    protected ActivatableLifecycleUser<T> getInjector() {
        return new RunPhase<T>(){

            @Override
            protected void run(GLSLParser.TranslationUnitContext ctx) {
                CSTInjectionPoint location = WrapIdentifier.this.injectionLocation();
                for (String externalDeclaration : WrapIdentifier.this.injectionExternalDeclarations()) {
                    this.injectExternalDeclaration(location, externalDeclaration);
                }
            }
        };
    }

    protected CSTInjectionPoint getInjectionLocation() {
        return CSTInjectionPoint.BEFORE_DECLARATIONS;
    }

    protected Collection<String> getInjectionExternalDeclarations() {
        if (this.externalDeclarationsDirect.isEmpty()) {
            throw new IllegalStateException("No injection external declarations are set");
        }
        return this.externalDeclarationsDirect;
    }

    public WrapIdentifier<T> wrapResultDetector(ActivatableLifecycleUser<T> wrapResultDetector) {
        this.wrapResultDetector = this.swapSupplier(this.wrapResultDetector, wrapResultDetector);
        return this;
    }

    public WrapIdentifier<T> detectionResults(Collection<String> detectionResults) {
        this.detectionResults = this.swapSupplier(this.detectionResults, detectionResults);
        return this;
    }

    public WrapIdentifier<T> detectionResult(String detectionResult) {
        return this.detectionResults(CompatUtil.listOf(detectionResult));
    }

    public WrapIdentifier<T> parsedReplacement(String parsedReplacement) {
        this.parsedReplacement = this.swapSupplier(this.parsedReplacement, parsedReplacement);
        return this;
    }

    public WrapIdentifier<T> parseMethod(Function<GLSLParser, ExtendedContext> parseMethod) {
        this.parseMethod = this.swapSupplier(this.parseMethod, parseMethod);
        return this;
    }

    public WrapIdentifier<T> wrappingReplacer(ActivatableLifecycleUser<T> wrappingReplacer) {
        this.wrappingReplacer = this.swapSupplier(this.wrappingReplacer, wrappingReplacer);
        return this;
    }

    public WrapIdentifier<T> wrapHandlerTargets(Collection<HandlerTarget<T>> wrapHandlerTargets) {
        this.wrapHandlerTargets = this.swapSupplier(this.wrapHandlerTargets, wrapHandlerTargets);
        return this;
    }

    public WrapIdentifier<T> wrapTarget(String wrapTarget) {
        this.wrapTarget = this.swapSupplier(this.wrapTarget, wrapTarget);
        return this;
    }

    public WrapIdentifier<T> injector(ActivatableLifecycleUser<T> injector) {
        this.injector = this.swapSupplier(this.injector, injector);
        return this;
    }

    public WrapIdentifier<T> injectionLocation(CSTInjectionPoint injectionLocation) {
        this.injectionLocation = this.swapSupplier(this.injectionLocation, injectionLocation);
        return this;
    }

    public WrapIdentifier<T> injectionExternalDeclarations(Collection<String> injectionExternalDeclarations) {
        this.injectionExternalDeclarations = this.swapSupplier(this.injectionExternalDeclarations, injectionExternalDeclarations);
        return this;
    }

    public WrapIdentifier<T> injectionExternalDeclaration(String injectionExternalDeclaration) {
        return this.injectionExternalDeclarations(CompatUtil.listOf(injectionExternalDeclaration));
    }

    public WrapIdentifier<T> wrapResultDetector(Supplier<ActivatableLifecycleUser<T>> wrapResultDetector) {
        this.wrapResultDetector = this.swapSupplier(this.wrapResultDetector, wrapResultDetector);
        return this;
    }

    public WrapIdentifier<T> detectionResults(Supplier<Collection<String>> detectionResults) {
        this.detectionResults = this.swapSupplier(this.detectionResults, detectionResults);
        return this;
    }

    public WrapIdentifier<T> parsedReplacement(Supplier<String> parsedReplacement) {
        this.parsedReplacement = this.swapSupplier(this.parsedReplacement, parsedReplacement);
        return this;
    }

    public WrapIdentifier<T> parseMethod(Supplier<Function<GLSLParser, ExtendedContext>> parseMethod) {
        this.parseMethod = this.swapSupplier(this.parseMethod, parseMethod);
        return this;
    }

    public WrapIdentifier<T> wrappingReplacer(Supplier<ActivatableLifecycleUser<T>> wrappingReplacer) {
        this.wrappingReplacer = this.swapSupplier(this.wrappingReplacer, wrappingReplacer);
        return this;
    }

    public WrapIdentifier<T> wrapHandlerTargets(Supplier<Collection<HandlerTarget<T>>> wrapHandlerTargets) {
        this.wrapHandlerTargets = this.swapSupplier(this.wrapHandlerTargets, wrapHandlerTargets);
        return this;
    }

    public WrapIdentifier<T> wrapTarget(Supplier<String> wrapTarget) {
        this.wrapTarget = this.swapSupplier(this.wrapTarget, wrapTarget);
        return this;
    }

    public WrapIdentifier<T> injector(Supplier<ActivatableLifecycleUser<T>> injector) {
        this.injector = this.swapSupplier(this.injector, injector);
        return this;
    }

    public WrapIdentifier<T> injectionLocation(Supplier<CSTInjectionPoint> injectionLocation) {
        this.injectionLocation = this.swapSupplier(this.injectionLocation, injectionLocation);
        return this;
    }

    public WrapIdentifier<T> injectionExternalDeclarations(Supplier<Collection<String>> injectionExternalDeclarations) {
        this.injectionExternalDeclarations = this.swapSupplier(this.injectionExternalDeclarations, injectionExternalDeclarations);
        return this;
    }

    public WrapIdentifier<T> wrapResultDetector(CachePolicy newPolicy) {
        this.wrapResultDetector = this.swapPolicy(this.wrapResultDetector, newPolicy);
        return this;
    }

    public WrapIdentifier<T> detectionResults(CachePolicy newPolicy) {
        this.detectionResults = this.swapPolicy(this.detectionResults, newPolicy);
        return this;
    }

    public WrapIdentifier<T> parsedReplacement(CachePolicy newPolicy) {
        this.parsedReplacement = this.swapPolicy(this.parsedReplacement, newPolicy);
        return this;
    }

    public WrapIdentifier<T> parseMethod(CachePolicy newPolicy) {
        this.parseMethod = this.swapPolicy(this.parseMethod, newPolicy);
        return this;
    }

    public WrapIdentifier<T> wrappingReplacer(CachePolicy newPolicy) {
        this.wrappingReplacer = this.swapPolicy(this.wrappingReplacer, newPolicy);
        return this;
    }

    public WrapIdentifier<T> wrapHandlerTargets(CachePolicy newPolicy) {
        this.wrapHandlerTargets = this.swapPolicy(this.wrapHandlerTargets, newPolicy);
        return this;
    }

    public WrapIdentifier<T> wrapTarget(CachePolicy newPolicy) {
        this.wrapTarget = this.swapPolicy(this.wrapTarget, newPolicy);
        return this;
    }

    public WrapIdentifier<T> injector(CachePolicy newPolicy) {
        this.injector = this.swapPolicy(this.injector, newPolicy);
        return this;
    }

    public WrapIdentifier<T> injectionLocation(CachePolicy newPolicy) {
        this.injectionLocation = this.swapPolicy(this.injectionLocation, newPolicy);
        return this;
    }

    public WrapIdentifier<T> injectionExternalDeclarations(CachePolicy newPolicy) {
        this.injectionExternalDeclarations = this.swapPolicy(this.injectionExternalDeclarations, newPolicy);
        return this;
    }

    protected final ActivatableLifecycleUser<T> wrapResultDetector() {
        return this.wrapResultDetector.get().activation(this::isActive);
    }

    protected final Collection<String> detectionResults() {
        return this.detectionResults.get();
    }

    protected final String detectionResult() {
        return this.detectionResults.get().stream().findFirst().orElse(null);
    }

    protected final String parsedReplacement() {
        return this.parsedReplacement.get();
    }

    protected final Function<GLSLParser, ExtendedContext> parseMethod() {
        return this.parseMethod.get();
    }

    protected final ActivatableLifecycleUser<T> wrappingReplacer() {
        return this.wrappingReplacer.get().activation(this::isActive);
    }

    protected final Collection<HandlerTarget<T>> wrapHandlerTargets() {
        return this.wrapHandlerTargets.get();
    }

    protected final String wrapTarget() {
        return this.wrapTarget.get();
    }

    protected final ActivatableLifecycleUser<T> injector() {
        return this.injector.get().activation(this::isActive);
    }

    protected final CSTInjectionPoint injectionLocation() {
        return this.injectionLocation.get();
    }

    protected final Collection<String> injectionExternalDeclarations() {
        return this.injectionExternalDeclarations.get();
    }
}

