/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.texture.format;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Objects;
import java.util.Properties;
import net.coderbot.iris.Iris;
import net.coderbot.iris.texture.format.TextureFormat;
import net.coderbot.iris.texture.format.TextureFormatRegistry;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class TextureFormatLoader {
    public static final ResourceLocation LOCATION = new ResourceLocation("optifine/texture.properties");
    private static TextureFormat format;

    @Nullable
    public static TextureFormat getFormat() {
        return format;
    }

    public static void reload(IResourceManager resourceManager) {
        TextureFormat newFormat = TextureFormatLoader.loadFormat(resourceManager);
        boolean didFormatChange = !Objects.equals(format, newFormat);
        format = newFormat;
        if (didFormatChange) {
            TextureFormatLoader.onFormatChange();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static TextureFormat loadFormat(IResourceManager resourceManager) {
        try (IResource resource2222 = resourceManager.func_199002_a(LOCATION);){
            Properties properties = new Properties();
            properties.load(resource2222.func_199027_b());
            String format = properties.getProperty("format");
            if (format == null) return null;
            if (format.isEmpty()) return null;
            String[] splitFormat = format.split("/");
            if (splitFormat.length <= 0) return null;
            String name = splitFormat[0];
            TextureFormat.Factory factory = TextureFormatRegistry.INSTANCE.getFactory(name);
            if (factory != null) {
                String version = splitFormat.length > 1 ? splitFormat[1] : null;
                TextureFormat textureFormat = factory.createFormat(name, version);
                return textureFormat;
            }
            Iris.logger.warn("Invalid texture format '" + name + "' in file '" + LOCATION + "'");
            return null;
        }
        catch (FileNotFoundException resource2222) {
            return null;
        }
        catch (Exception e) {
            Iris.logger.error("Failed to load texture format from file '" + LOCATION + "'", e);
        }
        return null;
    }

    private static void onFormatChange() {
        try {
            Iris.reload();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

