/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.texture.util;

import net.minecraft.client.renderer.texture.NativeImage;

public class ImageManipulationUtil {
    public static NativeImage scaleNearestNeighbor(NativeImage image, int newWidth, int newHeight) {
        NativeImage scaled = new NativeImage(image.func_211678_c(), newWidth, newHeight, false);
        float xScale = (float)newWidth / (float)image.func_195702_a();
        float yScale = (float)newHeight / (float)image.func_195714_b();
        for (int y = 0; y < newHeight; ++y) {
            for (int x = 0; x < newWidth; ++x) {
                float unscaledX = ((float)x + 0.5f) / xScale;
                float unscaledY = ((float)y + 0.5f) / yScale;
                scaled.func_195700_a(x, y, image.func_195709_a((int)unscaledX, (int)unscaledY));
            }
        }
        return scaled;
    }

    public static NativeImage scaleBilinear(NativeImage image, int newWidth, int newHeight) {
        NativeImage scaled = new NativeImage(image.func_211678_c(), newWidth, newHeight, false);
        float xScale = (float)newWidth / (float)image.func_195702_a();
        float yScale = (float)newHeight / (float)image.func_195714_b();
        for (int y = 0; y < newHeight; ++y) {
            for (int x = 0; x < newWidth; ++x) {
                float rightWeight;
                float leftWeight;
                float unscaledX = ((float)x + 0.5f) / xScale;
                float unscaledY = ((float)y + 0.5f) / yScale;
                int x1 = Math.round(unscaledX);
                int y1 = Math.round(unscaledY);
                int x0 = x1 - 1;
                int y0 = y1 - 1;
                boolean x0valid = true;
                boolean y0valid = true;
                boolean x1valid = true;
                boolean y1valid = true;
                if (x0 < 0) {
                    x0valid = false;
                }
                if (y0 < 0) {
                    y0valid = false;
                }
                if (x1 >= image.func_195702_a()) {
                    x1valid = false;
                }
                if (y1 >= image.func_195714_b()) {
                    y1valid = false;
                }
                int finalColor = 0;
                if (x0valid & y0valid & x1valid & y1valid) {
                    leftWeight = (float)x1 + 0.5f - unscaledX;
                    rightWeight = unscaledX - ((float)x0 + 0.5f);
                    float topWeight = (float)y1 + 0.5f - unscaledY;
                    float bottomWeight = unscaledY - ((float)y0 + 0.5f);
                    float weightTL = leftWeight * topWeight;
                    float weightTR = rightWeight * topWeight;
                    float weightBL = leftWeight * bottomWeight;
                    float weightBR = rightWeight * bottomWeight;
                    int colorTL = image.func_195709_a(x0, y0);
                    int colorTR = image.func_195709_a(x1, y0);
                    int colorBL = image.func_195709_a(x0, y1);
                    int colorBR = image.func_195709_a(x1, y1);
                    finalColor = ImageManipulationUtil.blendColor(colorTL, colorTR, colorBL, colorBR, weightTL, weightTR, weightBL, weightBR);
                } else if (x0valid & x1valid) {
                    leftWeight = (float)x1 + 0.5f - unscaledX;
                    rightWeight = unscaledX - ((float)x0 + 0.5f);
                    int validY = y0valid ? y0 : y1;
                    int colorLeft = image.func_195709_a(x0, validY);
                    int colorRight = image.func_195709_a(x1, validY);
                    finalColor = ImageManipulationUtil.blendColor(colorLeft, colorRight, leftWeight, rightWeight);
                } else if (y0valid & y1valid) {
                    float topWeight = (float)y1 + 0.5f - unscaledY;
                    float bottomWeight = unscaledY - ((float)y0 + 0.5f);
                    int validX = x0valid ? x0 : x1;
                    int colorTop = image.func_195709_a(validX, y0);
                    int colorBottom = image.func_195709_a(validX, y1);
                    finalColor = ImageManipulationUtil.blendColor(colorTop, colorBottom, topWeight, bottomWeight);
                } else {
                    finalColor = image.func_195709_a(x0valid ? x0 : x1, y0valid ? y0 : y1);
                }
                scaled.func_195700_a(x, y, finalColor);
            }
        }
        return scaled;
    }

    private static int blendColor(int c0, int c1, int c2, int c3, float w0, float w1, float w2, float w3) {
        return NativeImage.func_227787_a_((int)ImageManipulationUtil.blendChannel(NativeImage.func_227786_a_((int)c0), NativeImage.func_227786_a_((int)c1), NativeImage.func_227786_a_((int)c2), NativeImage.func_227786_a_((int)c3), w0, w1, w2, w3), (int)ImageManipulationUtil.blendChannel(NativeImage.func_227795_d_((int)c0), NativeImage.func_227795_d_((int)c1), NativeImage.func_227795_d_((int)c2), NativeImage.func_227795_d_((int)c3), w0, w1, w2, w3), (int)ImageManipulationUtil.blendChannel(NativeImage.func_227793_c_((int)c0), NativeImage.func_227793_c_((int)c1), NativeImage.func_227793_c_((int)c2), NativeImage.func_227793_c_((int)c3), w0, w1, w2, w3), (int)ImageManipulationUtil.blendChannel(NativeImage.func_227791_b_((int)c0), NativeImage.func_227791_b_((int)c1), NativeImage.func_227791_b_((int)c2), NativeImage.func_227791_b_((int)c3), w0, w1, w2, w3));
    }

    private static int blendChannel(int v0, int v1, int v2, int v3, float w0, float w1, float w2, float w3) {
        return Math.round((float)v0 * w0 + (float)v1 * w1 + (float)v2 * w2 + (float)v3 * w3);
    }

    private static int blendColor(int c0, int c1, float w0, float w1) {
        return NativeImage.func_227787_a_((int)ImageManipulationUtil.blendChannel(NativeImage.func_227786_a_((int)c0), NativeImage.func_227786_a_((int)c1), w0, w1), (int)ImageManipulationUtil.blendChannel(NativeImage.func_227795_d_((int)c0), NativeImage.func_227795_d_((int)c1), w0, w1), (int)ImageManipulationUtil.blendChannel(NativeImage.func_227793_c_((int)c0), NativeImage.func_227793_c_((int)c1), w0, w1), (int)ImageManipulationUtil.blendChannel(NativeImage.func_227791_b_((int)c0), NativeImage.func_227791_b_((int)c1), w0, w1));
    }

    private static int blendChannel(int v0, int v1, float w0, float w1) {
        return Math.round((float)v0 * w0 + (float)v1 * w1);
    }
}

