/*
 * Decompiled with CFR 0.152.
 */
package oculus.org.anarres.cpp;

import com.github.zafarkhaja.semver.Version;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildMetadata {
    public static final String RESOURCE = "/META-INF/jcpp.properties";
    private static BuildMetadata INSTANCE;
    private final Properties properties = new Properties();

    @Nonnull
    public static synchronized BuildMetadata getInstance() {
        try {
            if (INSTANCE == null) {
                INSTANCE = new BuildMetadata();
            }
            return INSTANCE;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private BuildMetadata() throws IOException {
        URL url = BuildMetadata.class.getResource(RESOURCE);
        InputStream in = url.openStream();
        try {
            this.properties.load(in);
        }
        finally {
            in.close();
        }
    }

    @Nonnull
    public Map<? extends String, ? extends String> asMap() {
        HashMap<String, String> out = new HashMap<String, String>();
        for (Map.Entry<Object, Object> e : this.properties.entrySet()) {
            out.put(String.valueOf(e.getKey()), String.valueOf(e.getValue()));
        }
        return out;
    }

    @Nonnull
    public Version getVersion() {
        return Version.valueOf((String)this.properties.getProperty("Implementation-Version"));
    }

    @Nonnull
    public Date getBuildDate() throws ParseException {
        String text = this.properties.getProperty("Build-Date");
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd_HH:mm:ss");
        return format.parse(text);
    }

    public String getChangeId() {
        return this.properties.getProperty("Change");
    }
}

