/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.impl.lib.sat4j.tools;

import java.util.SortedSet;
import java.util.TreeSet;
import net.fabricmc.loader.impl.lib.sat4j.core.VecInt;
import net.fabricmc.loader.impl.lib.sat4j.specs.ISolver;
import net.fabricmc.loader.impl.lib.sat4j.specs.IVecInt;
import net.fabricmc.loader.impl.lib.sat4j.specs.IteratorInt;
import net.fabricmc.loader.impl.lib.sat4j.tools.SolutionFoundListener;
import net.fabricmc.loader.impl.lib.sat4j.tools.SolverDecorator;

public class AbstractMinimalModel
extends SolverDecorator<ISolver> {
    private static final long serialVersionUID = 1L;
    protected final SortedSet<Integer> pLiterals = new TreeSet<Integer>();
    protected final SolutionFoundListener modelListener;

    public static IVecInt positiveLiterals(ISolver solver) {
        VecInt literals = new VecInt(solver.nVars());
        for (int i = 1; i <= solver.nVars(); ++i) {
            literals.push(i);
        }
        return literals;
    }

    public static IVecInt negativeLiterals(ISolver solver) {
        VecInt literals = new VecInt(solver.nVars());
        for (int i = 1; i <= solver.nVars(); ++i) {
            literals.push(-i);
        }
        return literals;
    }

    public AbstractMinimalModel(ISolver solver) {
        this(solver, SolutionFoundListener.VOID);
    }

    public AbstractMinimalModel(ISolver solver, IVecInt p) {
        this(solver, p, SolutionFoundListener.VOID);
    }

    public AbstractMinimalModel(ISolver solver, SolutionFoundListener modelListener) {
        this(solver, AbstractMinimalModel.negativeLiterals(solver), modelListener);
    }

    public AbstractMinimalModel(ISolver solver, IVecInt p, SolutionFoundListener modelListener) {
        super(solver);
        IteratorInt it = p.iterator();
        while (it.hasNext()) {
            this.pLiterals.add(it.next());
        }
        this.modelListener = modelListener;
    }
}

