/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.impl.lib.sat4j.tools;

import net.fabricmc.loader.impl.lib.sat4j.core.VecInt;
import net.fabricmc.loader.impl.lib.sat4j.specs.ContradictionException;
import net.fabricmc.loader.impl.lib.sat4j.specs.ISolver;
import net.fabricmc.loader.impl.lib.sat4j.tools.DimacsArrayReader;
import net.fabricmc.loader.impl.lib.sat4j.tools.GateTranslator;

public class ExtendedDimacsArrayReader
extends DimacsArrayReader {
    public static final int FALSE = 1;
    public static final int TRUE = 2;
    public static final int NOT = 3;
    public static final int AND = 4;
    public static final int NAND = 5;
    public static final int OR = 6;
    public static final int NOR = 7;
    public static final int XOR = 8;
    public static final int XNOR = 9;
    public static final int IMPLIES = 10;
    public static final int IFF = 11;
    public static final int IFTHENELSE = 12;
    public static final int ATLEAST = 13;
    public static final int ATMOST = 14;
    public static final int COUNT = 15;
    private static final long serialVersionUID = 1L;
    private final GateTranslator gater;

    public ExtendedDimacsArrayReader(ISolver solver) {
        super(solver);
        this.gater = new GateTranslator(solver);
    }

    @Override
    protected boolean handleConstr(int gateType, int output, int[] inputs) throws ContradictionException {
        switch (gateType) {
            case 1: {
                assert (inputs.length == 0);
                this.gater.gateFalse(output);
                break;
            }
            case 2: {
                assert (inputs.length == 0);
                this.gater.gateTrue(output);
                break;
            }
            case 6: {
                VecInt literals = new VecInt(inputs);
                this.gater.or(output, literals);
                break;
            }
            case 3: {
                assert (inputs.length == 1);
                this.gater.not(output, inputs[0]);
                break;
            }
            case 4: {
                VecInt literals = new VecInt(inputs);
                this.gater.and(output, literals);
                break;
            }
            case 8: {
                VecInt literals = new VecInt(inputs);
                this.gater.xor(output, literals);
                break;
            }
            case 11: {
                VecInt literals = new VecInt(inputs);
                this.gater.iff(output, literals);
                break;
            }
            case 12: {
                assert (inputs.length == 3);
                this.gater.ite(output, inputs[0], inputs[1], inputs[2]);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Gate type " + gateType + " not handled yet");
            }
        }
        return true;
    }
}

