/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.impl.lib.sat4j.tools;

import net.fabricmc.loader.impl.lib.sat4j.annotations.Feature;
import net.fabricmc.loader.impl.lib.sat4j.specs.ISolverService;
import net.fabricmc.loader.impl.lib.sat4j.specs.IVecInt;
import net.fabricmc.loader.impl.lib.sat4j.specs.Lbool;
import net.fabricmc.loader.impl.lib.sat4j.specs.RandomAccessModel;
import net.fabricmc.loader.impl.lib.sat4j.specs.SearchListenerAdapter;
import net.fabricmc.loader.impl.lib.sat4j.tools.SolutionFoundListener;

@Feature(value="searchlistener")
public class SearchEnumeratorListener
extends SearchListenerAdapter<ISolverService> {
    private static final long serialVersionUID = 1L;
    private ISolverService solverService;
    private int nbsolutions = 0;
    private final SolutionFoundListener sfl;

    public SearchEnumeratorListener(SolutionFoundListener sfl) {
        this.sfl = sfl;
    }

    @Override
    public void init(ISolverService solverService) {
        this.solverService = solverService;
    }

    @Override
    public void solutionFound(int[] model, RandomAccessModel lazyModel) {
        IVecInt clauseToAdd = this.solverService.createBlockingClauseForCurrentModel();
        int[] vecint = new int[clauseToAdd.size()];
        clauseToAdd.copyTo(vecint);
        this.solverService.addClauseOnTheFly(vecint);
        ++this.nbsolutions;
        this.sfl.onSolutionFound(model);
    }

    @Override
    public void end(Lbool result) {
        assert (result != Lbool.TRUE);
        if (result == Lbool.FALSE) {
            this.sfl.onUnsatTermination();
        }
    }

    public int getNumberOfSolutionFound() {
        return this.nbsolutions;
    }
}

