/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.impl.lib.sat4j.tools;

import java.util.Set;
import java.util.TreeSet;
import net.fabricmc.loader.impl.lib.sat4j.core.VecInt;
import net.fabricmc.loader.impl.lib.sat4j.specs.ContradictionException;
import net.fabricmc.loader.impl.lib.sat4j.specs.ISolver;
import net.fabricmc.loader.impl.lib.sat4j.specs.IVecInt;
import net.fabricmc.loader.impl.lib.sat4j.specs.IteratorInt;
import net.fabricmc.loader.impl.lib.sat4j.tools.ModelIterator;

public class SubModelIterator
extends ModelIterator {
    private static final long serialVersionUID = 1L;
    private final Set<Integer> subsetVars = new TreeSet<Integer>();

    public SubModelIterator(ISolver solver, IVecInt subsetVars) {
        this(solver, subsetVars, Long.MAX_VALUE);
    }

    public SubModelIterator(ISolver solver, IVecInt subsetVars, long bound) {
        super(solver, bound);
        IteratorInt it = subsetVars.iterator();
        while (it.hasNext()) {
            this.subsetVars.add(it.next());
        }
    }

    @Override
    public int[] model() {
        int[] last = super.model();
        ++this.nbModelFound;
        int[] sub = new int[this.subsetVars.size()];
        VecInt clause = new VecInt(sub.length);
        int i = 0;
        for (int q : last) {
            int var = Math.abs(q);
            if (!this.subsetVars.contains(var)) continue;
            clause.push(-q);
            sub[i++] = q;
        }
        try {
            this.addBlockingClause(clause);
        }
        catch (ContradictionException e) {
            this.trivialfalsity = true;
        }
        return sub;
    }

    @Override
    public int[] primeImplicant() {
        throw new UnsupportedOperationException();
    }
}

