/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.impl.lib.sat4j.tools.xplain;

import java.util.Map;
import java.util.Set;
import net.fabricmc.loader.impl.lib.sat4j.core.VecInt;
import net.fabricmc.loader.impl.lib.sat4j.specs.ISolver;
import net.fabricmc.loader.impl.lib.sat4j.specs.IVecInt;
import net.fabricmc.loader.impl.lib.sat4j.specs.IteratorInt;
import net.fabricmc.loader.impl.lib.sat4j.specs.TimeoutException;
import net.fabricmc.loader.impl.lib.sat4j.tools.xplain.MinimizationStrategy;

public class InsertionStrategy
implements MinimizationStrategy {
    private static final long serialVersionUID = 1L;
    private boolean computationCanceled;

    @Override
    public void cancelExplanationComputation() {
        this.computationCanceled = true;
    }

    @Override
    public IVecInt explain(ISolver solver, Map<Integer, ?> constrs, IVecInt assumps) throws TimeoutException {
        boolean shouldContinue;
        this.computationCanceled = false;
        VecInt encodingAssumptions = new VecInt(constrs.size() + assumps.size());
        assumps.copyTo(encodingAssumptions);
        IVecInt firstExplanation = solver.unsatExplanation();
        if (firstExplanation.size() == 1) {
            VecInt results = new VecInt();
            results.push(-firstExplanation.get(0));
            return results;
        }
        if (solver.isVerbose()) {
            System.out.print(solver.getLogPrefix() + "initial unsat core ");
            firstExplanation.sort();
            IteratorInt it = firstExplanation.iterator();
            while (it.hasNext()) {
                System.out.print(constrs.get(-it.next()));
                System.out.print(" ");
            }
            System.out.println();
        }
        int i = 0;
        while (i < firstExplanation.size()) {
            if (assumps.contains(firstExplanation.get(i))) {
                firstExplanation.delete(i);
                continue;
            }
            ++i;
        }
        Set<Integer> constraintsVariables = constrs.keySet();
        VecInt remainingVariables = new VecInt(constraintsVariables.size());
        for (Integer v : constraintsVariables) {
            remainingVariables.push(v);
        }
        IteratorInt it = firstExplanation.iterator();
        while (it.hasNext()) {
            int p = it.next();
            if (p < 0) {
                p = -p;
            }
            remainingVariables.remove(p);
            encodingAssumptions.push(p);
        }
        remainingVariables.copyTo(encodingAssumptions);
        int startingPoint = assumps.size();
        do {
            shouldContinue = false;
            int i2 = startingPoint;
            encodingAssumptions.set(i2, -encodingAssumptions.get(i2));
            assert (encodingAssumptions.get(i2) < 0);
            while (!this.computationCanceled && solver.isSatisfiable(encodingAssumptions)) {
                assert (encodingAssumptions.get(++i2) > 0);
                encodingAssumptions.set(i2, -encodingAssumptions.get(i2));
            }
            if (!this.computationCanceled && i2 > startingPoint) {
                assert (!solver.isSatisfiable(encodingAssumptions));
                if (i2 < encodingAssumptions.size()) {
                    int tmp = encodingAssumptions.get(i2);
                    for (int j = i2; j > startingPoint; --j) {
                        encodingAssumptions.set(j, -encodingAssumptions.get(j - 1));
                    }
                    encodingAssumptions.set(startingPoint, tmp);
                    if (solver.isVerbose()) {
                        System.out.println(solver.getLogPrefix() + constrs.get(tmp) + " is mandatory ");
                    }
                }
                shouldContinue = true;
            }
            ++startingPoint;
        } while (!this.computationCanceled && shouldContinue && solver.isSatisfiable(encodingAssumptions));
        if (this.computationCanceled) {
            throw new TimeoutException();
        }
        VecInt constrsKeys = new VecInt(startingPoint);
        for (int i3 = assumps.size(); i3 < startingPoint; ++i3) {
            constrsKeys.push(-encodingAssumptions.get(i3));
        }
        return constrsKeys;
    }

    public String toString() {
        return "Replay (Insertion-based) minimization strategy";
    }
}

