/*
 * Decompiled with CFR 0.152.
 */
package io.github.projectet.ae2things.block.entity;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.inventories.ISegmentedInventory;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.energy.IEnergyService;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.IUpgradeableObject;
import appeng.api.upgrades.UpgradeInventories;
import appeng.blockentity.grid.AENetworkPowerBlockEntity;
import appeng.core.definitions.AEItems;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.CombinedInternalInventory;
import appeng.util.inv.FilteredInternalInventory;
import appeng.util.inv.InternalInventoryHost;
import appeng.util.inv.filter.IAEItemFilter;
import io.github.projectet.ae2things.AE2Things;
import io.github.projectet.ae2things.recipe.CrystalGrowthRecipe;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class BECrystalGrowth
extends AENetworkPowerBlockEntity
implements IGridTickable,
IUpgradeableObject {
    private final InternalInventory extInventory;
    private final AppEngInternalInventory topRow = new AppEngInternalInventory((InternalInventoryHost)this, 4, 64);
    private final AppEngInternalInventory midRow = new AppEngInternalInventory((InternalInventoryHost)this, 4, 64);
    private final AppEngInternalInventory botRow = new AppEngInternalInventory((InternalInventoryHost)this, 4, 64);
    private final Random r = new Random();
    private final CombinedInternalInventory combInv = new CombinedInternalInventory(new InternalInventory[]{this.topRow, this.midRow, this.botRow});
    private final Map<InternalInventory, Integer> progress = new IdentityHashMap<AppEngInternalInventory, Integer>(Map.of(this.topRow, 0, this.midRow, 0, this.botRow, 0));
    private final Map<InternalInventory, CrystalGrowthRecipe> cachedRecipes = new IdentityHashMap<InternalInventory, CrystalGrowthRecipe>();
    private final Set<InternalInventory> toRemove = new HashSet<InternalInventory>();
    private boolean hasInitialised = false;
    private IUpgradeInventory upgrades = UpgradeInventories.forMachine((class_1935)AE2Things.CRYSTAL_GROWTH, (int)3, () -> ((BECrystalGrowth)this).saveChanges());
    private boolean isWorking;

    public BECrystalGrowth(class_2338 pos, class_2680 state) {
        super(AE2Things.CRYSTAL_GROWTH_BE, pos, state);
        FilteredInventory filter = new FilteredInventory();
        this.extInventory = new FilteredInternalInventory((InternalInventory)this.combInv, (IAEItemFilter)filter);
        this.getMainNode().setExposedOnSides(EnumSet.allOf(class_2350.class)).setIdlePowerUsage(0.0).addService(IGridTickable.class, (IGridNodeService)this);
        this.setInternalMaxPower(1600.0);
    }

    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(1, 20, this.combInv.isEmpty() || !this.hasWork(), true);
    }

    public int getTopProg() {
        return this.progress.get(this.topRow);
    }

    public int getMidProg() {
        return this.progress.get(this.midRow);
    }

    public int getBotProg() {
        return this.progress.get(this.botRow);
    }

    public boolean isWorking() {
        return this.isWorking;
    }

    public boolean hasWork() {
        if (!this.hasInitialised) {
            this.initCache();
            this.hasInitialised = true;
        }
        return !this.cachedRecipes.isEmpty();
    }

    private int howManyFull() {
        int full = 0;
        for (InternalInventory inv : this.progress.keySet()) {
            if (inv.getStackInSlot(3).method_7947() != 64) continue;
            ++full;
        }
        return full;
    }

    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        if (this.isWorking()) {
            this.getMainNode().ifPresent(iGrid -> {
                int speedFactor = 1 + this.upgrades.getInstalledUpgrades((class_1935)AEItems.SPEED_CARD);
                IEnergyService eg = iGrid.getEnergyService();
                BECrystalGrowth src = this;
                int powerConsumption = 10 * speedFactor * (this.cachedRecipes.size() - this.howManyFull());
                double powerThreshold = (double)powerConsumption - 0.01;
                double powerReq = this.extractAEPower(powerConsumption, Actionable.SIMULATE, PowerMultiplier.CONFIG);
                if (powerReq <= powerThreshold) {
                    src = eg;
                    powerReq = eg.extractAEPower((double)powerConsumption, Actionable.SIMULATE, PowerMultiplier.CONFIG);
                }
                if (powerReq > powerThreshold) {
                    if (!this.isWorking()) {
                        this.isWorking = true;
                        this.markForUpdate();
                    }
                    src.extractAEPower(powerConsumption, Actionable.MODULATE, PowerMultiplier.CONFIG);
                    this.cachedRecipes.forEach((inventory, recipe) -> {
                        if (recipe != null) {
                            int d = this.progress.get(inventory);
                            if (d >= 100) {
                                int i;
                                class_1799 resultItem = recipe.method_8110();
                                if (inventory.insertItem(3, resultItem, true).method_7947() != 0) {
                                    return;
                                }
                                for (i = 2; inventory.getStackInSlot(i).method_7909() == class_1802.field_8162 && i >= 1; --i) {
                                }
                                class_1799 stack = inventory.getStackInSlot(i);
                                if (stack.method_7909() != class_1802.field_8162) {
                                    class_1792 item = recipe.nextStage(stack);
                                    if (this.r.nextInt(12) == 0 && !recipe.isFlawless(stack)) {
                                        inventory.getStackInSlot(i).method_7934(1);
                                        if (item != class_1802.field_8162 && i != 2) {
                                            inventory.setItemDirect(i + 1, new class_1799((class_1935)item));
                                        } else {
                                            inventory.getStackInSlot(i + 1).method_7933(1);
                                        }
                                    }
                                }
                                inventory.insertItem(3, resultItem, false);
                                this.progress.put((InternalInventory)inventory, 0);
                                this.saveChanges();
                            } else if (inventory.getStackInSlot(3).method_7947() != 64) {
                                this.progress.put((InternalInventory)inventory, d + speedFactor);
                            }
                        }
                    });
                }
            });
        }
        this.clearEmptyCache();
        this.matchWork();
        return this.hasWork() ? TickRateModulation.URGENT : TickRateModulation.SLEEP;
    }

    public void setOrientation(class_2350 inForward, class_2350 inUp) {
        this.setPowerSides(EnumSet.allOf(class_2350.class));
    }

    public void onReady() {
        this.getMainNode().setExposedOnSides(EnumSet.allOf(class_2350.class));
        super.onReady();
    }

    private void clearEmptyCache() {
        for (InternalInventory inv : this.toRemove) {
            this.cachedRecipes.remove(inv);
            this.progress.put(inv, 0);
        }
        this.toRemove.clear();
    }

    private void initCache() {
        block0: for (InternalInventory inv : this.progress.keySet()) {
            if (!this.hasIngredients(inv)) continue;
            for (class_1799 stack : inv) {
                if (stack.method_7960()) continue;
                this.cachedRecipes.put(inv, CrystalGrowthRecipe.getRecipefromStack(this.method_10997(), stack));
                continue block0;
            }
        }
    }

    protected boolean readFromStream(class_2540 data) {
        boolean newWorking;
        boolean c = super.readFromStream(data);
        boolean oldWorking = this.isWorking();
        if (oldWorking != (newWorking = data.readBoolean()) && newWorking) {
            this.isWorking = true;
        }
        for (int i = 0; i < this.combInv.size(); ++i) {
            this.combInv.setItemDirect(i, data.method_10819());
        }
        return c;
    }

    protected void writeToStream(class_2540 data) {
        super.writeToStream(data);
        data.writeBoolean(this.isWorking());
        for (int i = 0; i < this.combInv.size(); ++i) {
            data.method_10793(this.combInv.getStackInSlot(i));
        }
    }

    @Nullable
    public InternalInventory getSubInventory(class_2960 id) {
        if (id.equals((Object)ISegmentedInventory.STORAGE)) {
            return this.getInternalInventory();
        }
        if (id.equals((Object)ISegmentedInventory.UPGRADES)) {
            return this.upgrades;
        }
        return super.getSubInventory(id);
    }

    public void method_11007(class_2487 data) {
        super.method_11007(data);
        this.upgrades.writeToNBT(data, "upgrades");
        data.method_10556("working", this.isWorking);
        data.method_10539("progress", new int[]{this.getTopProg(), this.getMidProg(), this.getBotProg()});
    }

    public void loadTag(class_2487 data) {
        super.loadTag(data);
        this.upgrades.readFromNBT(data, "upgrades");
        this.isWorking = data.method_10577("working");
        int[] savedProgress = data.method_10561("progress");
        this.progress.put((InternalInventory)this.topRow, savedProgress[0]);
        this.progress.put((InternalInventory)this.midRow, savedProgress[1]);
        this.progress.put((InternalInventory)this.botRow, savedProgress[2]);
    }

    public void addAdditionalDrops(class_1937 level, class_2338 pos, List<class_1799> drops) {
        super.addAdditionalDrops(level, pos, drops);
        for (class_1799 upgrade : this.upgrades) {
            drops.add(upgrade);
        }
    }

    public InternalInventory getInternalInventory() {
        return this.combInv;
    }

    public InternalInventory getExposedInventoryForSide(class_2350 side) {
        return this.extInventory;
    }

    public void onChangeInventory(InternalInventory inv, int slot) {
        CrystalGrowthRecipe recipe = CrystalGrowthRecipe.getRecipefromStack(this.field_11863, inv.getStackInSlot(slot));
        if (this.cachedRecipes.get(inv) != recipe && recipe != null) {
            this.cachedRecipes.put(inv, recipe);
        } else if (!this.hasIngredients(inv)) {
            this.toRemove.add(inv);
            this.progress.put(inv, 0);
        }
        if (!this.isWorking()) {
            this.markForUpdate();
        }
        this.getMainNode().ifPresent((grid, node) -> grid.getTickManager().wakeDevice(node));
    }

    public boolean hasIngredients(InternalInventory inv) {
        for (int i = 0; i <= 2; ++i) {
            if (inv.getStackInSlot(i).method_7909() == class_1802.field_8162) continue;
            return true;
        }
        return false;
    }

    public void matchWork() {
        if (this.isWorking() != this.hasWork()) {
            this.isWorking = this.hasWork();
            this.markForUpdate();
        }
    }

    public IUpgradeInventory getUpgrades() {
        return this.upgrades;
    }

    public class FilteredInventory
    implements IAEItemFilter {
        public boolean allowExtract(InternalInventory inv, int slot, int amount) {
            return slot == 3;
        }

        public boolean allowInsert(InternalInventory inv, int slot, class_1799 stack) {
            CrystalGrowthRecipe recipe = CrystalGrowthRecipe.getRecipefromStack(BECrystalGrowth.this.method_10997(), stack);
            if (recipe == null) {
                return false;
            }
            switch (slot) {
                case 0: {
                    return recipe.getFlawlessCrystal().method_8093(stack) || recipe.getFlawedCrystal().method_8093(stack);
                }
                case 1: {
                    return recipe.getChippedCrystal().method_8093(stack);
                }
                case 2: {
                    return recipe.getDamagedCrystal().method_8093(stack);
                }
            }
            return false;
        }
    }
}

