/*
 * Decompiled with CFR 0.152.
 */
package io.github.projectet.ae2things.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.github.projectet.ae2things.AE2Things;
import io.github.projectet.ae2things.item.AETItems;
import io.github.projectet.ae2things.storage.IDISKCellItem;
import java.util.UUID;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2487;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_3222;
import net.minecraft.class_5242;

public class Command {
    static LiteralCommandNode<class_2168> commandRoot = ((LiteralArgumentBuilder)class_2170.method_9247((String)"ae2things").executes(Command::help)).build();
    static LiteralCommandNode<class_2168> recoverArg = ((LiteralArgumentBuilder)class_2170.method_9247((String)"ae2things").then(class_2170.method_9247((String)"recover").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"uuid", (ArgumentType)class_5242.method_27643()).requires(serverCommandSource -> serverCommandSource.method_9259(2))).executes(context -> Command.spawnDrive((CommandContext<class_2168>)context, (UUID)context.getArgument("uuid", UUID.class)))))).build();
    static LiteralCommandNode<class_2168> copyUUID = ((LiteralArgumentBuilder)class_2170.method_9247((String)"ae2things").then(class_2170.method_9247((String)"getuuid").executes(Command::getUUID))).build();

    public static void init() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            dispatcher.getRoot().addChild(commandRoot);
            dispatcher.getRoot().addChild(recoverArg);
            dispatcher.getRoot().addChild(copyUUID);
        });
    }

    private static int help(CommandContext<class_2168> context) {
        ((class_2168)context.getSource()).method_9226((class_2561)class_2561.method_43470((String)"Available Argument(s): "), false);
        ((class_2168)context.getSource()).method_9226((class_2561)class_2561.method_43470((String)"/ae2things recover <UUID> - Spawns a drive with the given UUID, if it doesn't exist, does not spawn any item."), false);
        ((class_2168)context.getSource()).method_9226((class_2561)class_2561.method_43470((String)"/ae2things getuuid - Gets the UUID of the drive in the player's hand if it has a UUID. Returns the DISKS uuid."), false);
        return 0;
    }

    private static int spawnDrive(CommandContext<class_2168> context, UUID uuid) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        if (AE2Things.STORAGE_INSTANCE.hasUUID(uuid)) {
            class_1799 stack = new class_1799((class_1935)AETItems.DISK_DRIVE_64K);
            class_2487 nbt = new class_2487();
            nbt.method_25927("diskuuid", uuid);
            nbt.method_10544("ic", AE2Things.STORAGE_INSTANCE.getOrCreateDisk((UUID)uuid).itemCount);
            stack.method_7980(nbt);
            player.method_7270(stack);
            ((class_2168)context.getSource()).method_9226((class_2561)class_2561.method_43469((String)"command.ae2things.recover_success", (Object[])new Object[]{player.method_5476(), uuid}), true);
            return 0;
        }
        ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43469((String)"command.ae2things.recover_fail", (Object[])new Object[]{uuid}));
        return 1;
    }

    private static int getUUID(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        class_1799 mainStack = player.method_6047();
        if (mainStack.method_7909() instanceof IDISKCellItem) {
            if (mainStack.method_7985() && mainStack.method_7969().method_10545("diskuuid")) {
                class_2561 text = Command.copyToClipboard(mainStack.method_7969().method_25926("diskuuid").toString());
                ((class_2168)context.getSource()).method_9226((class_2561)class_2561.method_43469((String)"command.ae2things.getuuid_success", (Object[])new Object[]{text}), false);
                return 0;
            }
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43471((String)"command.ae2things.getuuid_fail_nouuid"));
            return 1;
        }
        ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43471((String)"command.ae2things.getuuid_fail_notdisk"));
        return 1;
    }

    private static class_2561 copyToClipboard(String string) {
        return class_2561.method_43470((String)string).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_21462, string)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43471((String)"chat.copy.click"))).method_10975(string).method_10977(class_124.field_1060));
    }
}

