/*
 * Decompiled with CFR 0.152.
 */
package io.github.projectet.ae2things.inventory;

import appeng.api.inventories.InternalInventory;
import appeng.api.stacks.GenericStack;
import appeng.menu.AEBaseMenu;
import io.github.projectet.ae2things.recipe.CrystalGrowthRecipe;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1937;

public class CrystalGrowthSlot
extends class_1735 {
    private static final class_1263 EMPTY_INVENTORY = new class_1277(0);
    private final InternalInventory inventory;
    private final int invSlot;
    private class_1937 world;
    private AEBaseMenu menu = null;
    private boolean active = true;
    public final int slotIndex;

    public CrystalGrowthSlot(InternalInventory inv, int invSlot, int x, int y, int slotIndex, class_1937 world) {
        super(EMPTY_INVENTORY, invSlot, x, y);
        this.invSlot = invSlot;
        this.slotIndex = slotIndex;
        this.inventory = inv;
        this.world = world;
    }

    public boolean method_7680(class_1799 stack) {
        if (this.containsWrapperItem()) {
            return false;
        }
        CrystalGrowthRecipe recipe = CrystalGrowthRecipe.getRecipefromStack(this.world, stack);
        if (recipe == null) {
            return false;
        }
        switch (this.slotIndex) {
            case 0: {
                return recipe.getFlawlessCrystal().method_8093(stack) || recipe.getFlawedCrystal().method_8093(stack);
            }
            case 1: {
                return recipe.getChippedCrystal().method_8093(stack);
            }
            case 2: {
                return recipe.getDamagedCrystal().method_8093(stack);
            }
        }
        return false;
    }

    public class_1799 method_7677() {
        if (!this.isSlotEnabled()) {
            return class_1799.field_8037;
        }
        if (this.invSlot >= this.inventory.size()) {
            return class_1799.field_8037;
        }
        return this.inventory.getStackInSlot(this.invSlot);
    }

    public void method_7673(class_1799 stack) {
        if (this.isSlotEnabled()) {
            this.inventory.setItemDirect(this.invSlot, stack);
            this.method_7668();
        }
    }

    public void method_44206(class_1799 stack) {
        this.inventory.setItemDirect(this.invSlot, stack);
    }

    private void notifyContainerSlotChanged() {
        if (this.getMenu() != null) {
            this.getMenu().onSlotChange((class_1735)this);
        }
    }

    public InternalInventory getInventory() {
        return this.inventory;
    }

    public void method_7668() {
        super.method_7668();
        this.notifyContainerSlotChanged();
    }

    public int method_7675() {
        return this.inventory.getSlotLimit(this.invSlot);
    }

    public int method_7676(class_1799 stack) {
        return Math.min(this.method_7675(), stack.method_7914());
    }

    public boolean method_7674(class_1657 player) {
        if (this.containsWrapperItem()) {
            return false;
        }
        if (this.isSlotEnabled()) {
            return !this.inventory.extractItem(this.invSlot, 1, true).method_7960();
        }
        return false;
    }

    public class_1799 method_7671(int amount) {
        if (this.containsWrapperItem()) {
            return class_1799.field_8037;
        }
        return this.inventory.extractItem(this.invSlot, amount, false);
    }

    private boolean containsWrapperItem() {
        return GenericStack.isWrapped((class_1799)this.method_7677());
    }

    public boolean method_7682() {
        return this.isSlotEnabled() && this.active;
    }

    public boolean isSlotEnabled() {
        return true;
    }

    protected AEBaseMenu getMenu() {
        return this.menu;
    }

    public void setMenu(AEBaseMenu menu) {
        this.menu = menu;
    }
}

