/*
 * Decompiled with CFR 0.152.
 */
package ad_astra_giselle_addon.common.block.entity;

import ad_astra_giselle_addon.common.AdAstraGiselleAddon;
import ad_astra_giselle_addon.common.block.entity.IRocketSensingType;
import ad_astra_giselle_addon.common.registry.AddonItems;
import ad_astra_giselle_addon.common.util.RedstoneUtils;
import earth.terrarium.ad_astra.common.config.VehiclesConfig;
import earth.terrarium.ad_astra.common.entity.vehicle.Lander;
import earth.terrarium.ad_astra.common.entity.vehicle.Rocket;
import earth.terrarium.ad_astra.common.entity.vehicle.Vehicle;
import earth.terrarium.ad_astra.common.registry.ModItems;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3611;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum RocketSensingType implements IRocketSensingType
{
    DISABLED(AdAstraGiselleAddon.rl("disabled")){

        @Override
        public boolean test(Vehicle vehicle) {
            return vehicle instanceof Rocket;
        }

        @Override
        public int getAnalogSignal(Vehicle vehicle) {
            return 0;
        }

        @Override
        public class_1799 getDisplayIcon() {
            return new class_1799((class_1935)class_1802.field_8054);
        }
    }
    ,
    FOUND(AdAstraGiselleAddon.rl("found")){

        @Override
        public boolean test(Vehicle vehicle) {
            return vehicle instanceof Rocket;
        }

        @Override
        public int getAnalogSignal(Vehicle vehicle) {
            return 15;
        }

        @Override
        public class_1799 getDisplayIcon() {
            return new class_1799((class_1935)class_1802.field_8725);
        }
    }
    ,
    FLYING_UP(AdAstraGiselleAddon.rl("flying_up")){

        @Override
        public boolean test(Vehicle vehicle) {
            return vehicle instanceof Rocket;
        }

        @Override
        public int getAnalogSignal(Vehicle vehicle) {
            Rocket rocket = (Rocket)vehicle;
            return RedstoneUtils.onOff(rocket.isFlying() && rocket.getCountdownTicks() <= 0);
        }

        @Override
        public class_1799 getDisplayIcon() {
            return new class_1799((class_1935)ModItems.TIER_1_ROCKET.get());
        }
    }
    ,
    FUEL_LOADED(AdAstraGiselleAddon.rl("fuel_loaded")){

        @Override
        public boolean test(Vehicle vehicle) {
            return vehicle instanceof Rocket;
        }

        @Override
        public int getAnalogSignal(Vehicle vehicle) {
            Rocket rocket = (Rocket)vehicle;
            return RedstoneUtils.onOff(rocket.getTankAmount() >= Rocket.getRequiredAmountForLaunch((class_3611)rocket.getTankFluid()));
        }

        @Override
        public class_1799 getDisplayIcon() {
            return new class_1799((class_1935)ModItems.FUEL_BUCKET.get());
        }
    }
    ,
    LAUNCH_COUNTDOWN(AdAstraGiselleAddon.rl("launch_countdown"), 2){

        @Override
        public boolean test(Vehicle vehicle) {
            return vehicle instanceof Rocket;
        }

        @Override
        public int getAnalogSignal(Vehicle vehicle) {
            Rocket rocket = (Rocket)vehicle;
            int max = VehiclesConfig.RocketConfig.countDownTicks;
            return rocket.isFlying() ? RedstoneUtils.range((double)(max - rocket.getCountdownTicks()) / (double)max) : 0;
        }

        @Override
        public class_1799 getDisplayIcon() {
            return new class_1799((class_1935)ModItems.LAUNCH_PAD.get());
        }
    }
    ,
    LANDER_FOUND(AdAstraGiselleAddon.rl("lander_found"), 1){

        @Override
        public boolean test(Vehicle vehicle) {
            return vehicle instanceof Lander;
        }

        @Override
        public int getAnalogSignal(Vehicle vehicle) {
            return 15;
        }

        @Override
        public class_1799 getDisplayIcon() {
            return new class_1799((class_1935)AddonItems.LANDER_ICON.get());
        }
    };

    private final class_2960 name;
    private final class_2561 displayName;
    private final List<class_2561> tooltip;

    private RocketSensingType(class_2960 name) {
        this(name, 1);
    }

    private RocketSensingType(class_2960 name, int tooltipLines) {
        this.name = name;
        this.displayName = class_2561.method_43471((String)AdAstraGiselleAddon.tl("rocket_sensing_type", name));
        Object[] tooltipParams = new Object[]{0, 15};
        this.tooltip = tooltipLines == 1 ? Collections.singletonList(class_2561.method_43469((String)AdAstraGiselleAddon.tl("rocket_sensing_type", name, "desc"), (Object[])tooltipParams)) : IntStream.range(0, tooltipLines).mapToObj(i -> class_2561.method_43469((String)AdAstraGiselleAddon.tl("rocket_sensing_type", name, "desc" + (i + 1)), (Object[])tooltipParams)).collect(Collectors.toUnmodifiableList());
    }

    @Override
    public class_2960 getName() {
        return this.name;
    }

    @Override
    public class_2561 getDisplayName() {
        return this.displayName;
    }

    @Override
    public List<class_2561> getTooltip() {
        return this.tooltip;
    }

    @Override
    public abstract boolean test(Vehicle var1);

    @Override
    public abstract int getAnalogSignal(Vehicle var1);
}

