/*
 * Decompiled with CFR 0.152.
 */
package ad_astra_giselle_addon.common.block.entity;

import ad_astra_giselle_addon.common.block.entity.AddonMachineBlockEntity;
import ad_astra_giselle_addon.common.block.entity.IRangedWorkingAreaBlockEntity;
import ad_astra_giselle_addon.common.block.entity.IRocketSensingType;
import ad_astra_giselle_addon.common.block.entity.RocketSensingType;
import ad_astra_giselle_addon.common.config.MachinesConfig;
import ad_astra_giselle_addon.common.menu.RocketSensorMenu;
import ad_astra_giselle_addon.common.registry.AddonBlockEntityTypes;
import earth.terrarium.ad_astra.common.entity.vehicle.Vehicle;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RocketSensorBlockEntity
extends AddonMachineBlockEntity
implements IRangedWorkingAreaBlockEntity {
    public static final String DATA_WORKINGAREA_VISIBLE_KEY = "workingAreaVisible";
    public static final String DATA_SENSING_TYPE_KEY = "sensingType";
    public static final String DATA_INVERTED_KEY = "inverted";
    public static final String DATA_ANALOG_SIGNAL_KEY = "analogSignal";
    private boolean workingAreaVisible = false;
    private IRocketSensingType sensingType = RocketSensingType.DISABLED;
    private boolean inverted = false;
    private int analogSignal = 0;
    private Vehicle cachedTarget;

    public RocketSensorBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)AddonBlockEntityTypes.ROCKET_SENSOR.get(), pos, state);
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.workingAreaVisible = nbt.method_10577(DATA_WORKINGAREA_VISIBLE_KEY);
        this.sensingType = IRocketSensingType.readNBT(nbt.method_10580(DATA_SENSING_TYPE_KEY));
        this.inverted = nbt.method_10577(DATA_INVERTED_KEY);
        this.analogSignal = nbt.method_10550(DATA_ANALOG_SIGNAL_KEY);
    }

    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10556(DATA_WORKINGAREA_VISIBLE_KEY, this.workingAreaVisible);
        nbt.method_10566(DATA_SENSING_TYPE_KEY, IRocketSensingType.writeNBT(this.sensingType));
        nbt.method_10556(DATA_INVERTED_KEY, this.inverted);
        nbt.method_10569(DATA_ANALOG_SIGNAL_KEY, this.analogSignal);
    }

    @Nullable
    public class_1703 createMenu(int windowId, class_1661 inv, class_1657 player) {
        return new RocketSensorMenu(windowId, inv, this);
    }

    public void tick() {
        class_1937 level = this.method_10997();
        if (!level.method_8608()) {
            int analogSignal;
            IRocketSensingType sensingType = this.getSensingType();
            Vehicle newTarget = this.findTarget(sensingType);
            int n = analogSignal = newTarget != null ? sensingType.getAnalogSignal(newTarget) : 0;
            if (this.isInverted()) {
                analogSignal = 15 - analogSignal;
            }
            if (this.getCachedTarget() != newTarget) {
                this.cachedTarget = newTarget;
                this.analogSignal = analogSignal;
                this.method_5431();
            } else if (this.getAnalogSignal() != analogSignal) {
                this.analogSignal = analogSignal;
                this.method_5431();
            }
        }
    }

    public Vehicle findTarget(IRocketSensingType sensingType) {
        class_1937 level = this.method_10997();
        class_238 workingArea = this.getWorkingArea();
        return level.method_18467(Vehicle.class, workingArea).stream().filter(sensingType::test).findFirst().orElse(null);
    }

    @Override
    public boolean isWorkingAreaVisible() {
        return this.workingAreaVisible;
    }

    @Override
    public void setWorkingAreaVisible(boolean visible) {
        if (this.isWorkingAreaVisible() != visible) {
            this.workingAreaVisible = visible;
            this.method_5431();
        }
    }

    @Override
    public int getWorkingRange() {
        return MachinesConfig.ROCKET_SENSOR_WORKING_RANGE;
    }

    @Override
    public class_238 getWorkingArea(double range) {
        return this.getWorkingArea(this.method_11016(), range);
    }

    public Vehicle getCachedTarget() {
        return this.cachedTarget;
    }

    @NotNull
    public IRocketSensingType getSensingType() {
        return this.sensingType;
    }

    public void setSensingType(@Nullable IRocketSensingType sensingType) {
        if (sensingType == null) {
            sensingType = RocketSensingType.DISABLED;
        }
        if (this.getSensingType() != sensingType) {
            this.sensingType = sensingType;
            this.method_5431();
        }
    }

    public boolean isInverted() {
        return this.inverted;
    }

    public void setInverted(boolean inverted) {
        if (this.isInverted() != inverted) {
            this.inverted = inverted;
            this.method_5431();
        }
    }

    public int getAnalogSignal() {
        return this.analogSignal;
    }
}

