/*
 * Decompiled with CFR 0.152.
 */
package ad_astra_giselle_addon.common.content.oxygen;

import ad_astra_giselle_addon.common.content.oxygen.ChargeMode;
import ad_astra_giselle_addon.common.content.oxygen.IChargeMode;
import ad_astra_giselle_addon.common.content.oxygen.IOxygenStorage;
import ad_astra_giselle_addon.common.fluid.FluidHooks2;
import ad_astra_giselle_addon.common.fluid.FluidPredicates;
import ad_astra_giselle_addon.common.fluid.UniveralFluidHandler;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1309;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IOxygenCharger
extends IOxygenStorage {
    default public List<IChargeMode> getAvailableChargeModes() {
        return Arrays.asList(ChargeMode.values());
    }

    @NotNull
    public IChargeMode getChargeMode();

    public void setChargeMode(@Nullable IChargeMode var1);

    public long getTransferAmount();

    public UniveralFluidHandler getFluidHandler();

    @Override
    default public long extractOxygen(@Nullable class_1309 entity, long amount, boolean simulate) {
        UniveralFluidHandler fluidHandler = this.getFluidHandler();
        return FluidHooks2.extractFluid(fluidHandler, FluidPredicates::isOxygen, amount, simulate).getFluidAmount();
    }

    @Override
    default public long getOxygenAmount() {
        UniveralFluidHandler fluidHandler = this.getFluidHandler();
        int size = fluidHandler.getTankAmount();
        long amount = 0L;
        for (int i = 0; i < size; ++i) {
            amount += fluidHandler.getFluidInTank(i).getFluidAmount();
        }
        return amount;
    }

    @Override
    default public long getOxygenCapacity() {
        UniveralFluidHandler fluidHandler = this.getFluidHandler();
        int size = fluidHandler.getTankAmount();
        long capacity = 0L;
        for (int i = 0; i < size; ++i) {
            capacity += fluidHandler.getTankCapacity(i);
        }
        return capacity;
    }
}

