/*
 * Decompiled with CFR 0.152.
 */
package ad_astra_giselle_addon.common.content.oxygen;

import ad_astra_giselle_addon.common.content.oxygen.IOxygenCharger;
import ad_astra_giselle_addon.common.content.oxygen.IOxygenChargerItem;
import ad_astra_giselle_addon.common.content.oxygen.OxygenStorageUtils;
import ad_astra_giselle_addon.common.fluid.FluidHooks2;
import ad_astra_giselle_addon.common.fluid.FluidPredicates;
import ad_astra_giselle_addon.common.fluid.UniveralFluidHandler;
import ad_astra_giselle_addon.common.item.ItemStackReference;
import earth.terrarium.ad_astra.common.item.armor.SpaceSuit;
import earth.terrarium.botarium.api.fluid.FluidHolder;
import earth.terrarium.botarium.api.item.ItemStackHolder;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import org.jetbrains.annotations.Nullable;

public class OxygenChargerUtils {
    public static final long LEAST_DISTRIBUTION_AMOUNT = FluidHooks2.MILLI_BUCKET;

    public static void distributeToItems(class_1309 living) {
        OxygenStorageUtils.streamExtractable(living, LEAST_DISTRIBUTION_AMOUNT).forEach(source -> {
            if (source instanceof IOxygenCharger) {
                IOxygenCharger charger = (IOxygenCharger)source;
                OxygenChargerUtils.distributeToItems(living, charger);
            }
        });
    }

    public static void distributeToItems(class_1309 living, IOxygenCharger oxygenCharger) {
        FluidHolder moved;
        UniveralFluidHandler itemFluidHandler;
        ItemStackReference itemRef;
        class_1792 item;
        UniveralFluidHandler fluidHandler = oxygenCharger.getFluidHandler();
        List<ItemStackReference> items = oxygenCharger.getChargeMode().getItems(living);
        long transfer = oxygenCharger.getTransferAmount();
        Iterator iterator = items.iterator();
        while (iterator.hasNext() && (!((item = (itemRef = (ItemStackReference)((Object)iterator.next())).getStack().method_7909()) instanceof SpaceSuit) || (itemFluidHandler = (UniveralFluidHandler)UniveralFluidHandler.fromSafe(itemRef).orElse(null)) == null || (moved = FluidHooks2.moveFluidAny(fluidHandler, itemFluidHandler, FluidPredicates::isOxygen, transfer, false)).isEmpty() || (transfer -= moved.getFluidAmount()) > 0L)) {
        }
    }

    @Nullable
    public static IOxygenCharger get(ItemStackHolder item) {
        class_1792 class_17922 = item.getStack().method_7909();
        if (class_17922 instanceof IOxygenChargerItem) {
            IOxygenChargerItem oxygenChargerItem = (IOxygenChargerItem)class_17922;
            return oxygenChargerItem.getOxygenCharger(item);
        }
        return null;
    }

    private OxygenChargerUtils() {
    }
}

