/*
 * Decompiled with CFR 0.152.
 */
package ad_astra_giselle_addon.common.content.oxygen;

import ad_astra_giselle_addon.common.compat.CompatibleManager;
import ad_astra_giselle_addon.common.compat.create.BacktankOxygenStorage;
import ad_astra_giselle_addon.common.content.oxygen.IOxygenStorage;
import ad_astra_giselle_addon.common.content.oxygen.IOxygenStorageItem;
import ad_astra_giselle_addon.common.entity.LivingHelper;
import ad_astra_giselle_addon.common.fluid.UniveralFluidHandler;
import ad_astra_giselle_addon.common.item.ItemStackReference;
import ad_astra_giselle_addon.common.item.OxygenCanItem;
import earth.terrarium.ad_astra.common.registry.ModFluids;
import earth.terrarium.ad_astra.common.util.ModUtils;
import earth.terrarium.botarium.api.fluid.FluidHolder;
import earth.terrarium.botarium.api.fluid.FluidHooks;
import earth.terrarium.botarium.api.item.ItemStackHolder;
import java.util.List;
import java.util.OptionalDouble;
import java.util.stream.Stream;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_3611;
import org.jetbrains.annotations.Nullable;

public class OxygenStorageUtils {
    public static OptionalDouble getExtractableStoredRatio(class_1309 living) {
        List<ItemStackReference> items = LivingHelper.getInventoryItems(living);
        long stored = 0L;
        long capacity = 0L;
        int temperature = (int)ModUtils.getWorldTemperature((class_1937)living.method_37908());
        for (ItemStackReference item : items) {
            IOxygenStorage oxygenStorage = OxygenStorageUtils.get(item);
            if (oxygenStorage == null || !oxygenStorage.getTemperatureThreshold().contains((Object)temperature)) continue;
            stored += oxygenStorage.getOxygenAmount();
            capacity += oxygenStorage.getOxygenCapacity();
        }
        if (capacity == 0L) {
            return OptionalDouble.empty();
        }
        return OptionalDouble.of((double)stored / (double)capacity);
    }

    @Nullable
    public static IOxygenStorage firstExtractable(class_1309 living, long extracting) {
        return OxygenStorageUtils.streamExtractable(living, extracting).findFirst().orElse(null);
    }

    @Nullable
    public static Stream<IOxygenStorage> streamExtractable(class_1309 living, long extracting) {
        int temperature = (int)ModUtils.getWorldTemperature((class_1937)living.method_37908());
        return LivingHelper.getInventoryItems(living).stream().map(OxygenStorageUtils::get).filter(oxygenStorage -> {
            long extract;
            return oxygenStorage != null && oxygenStorage.getTemperatureThreshold().contains((Object)temperature) && (extract = oxygenStorage.extractOxygen(living, extracting, true)) >= extracting;
        });
    }

    @Nullable
    public static IOxygenStorage get(ItemStackHolder item) {
        IOxygenStorage storage;
        class_1792 class_17922 = item.getStack().method_7909();
        if (class_17922 instanceof IOxygenStorageItem) {
            IOxygenStorageItem oxygenStorageItem = (IOxygenStorageItem)class_17922;
            return oxygenStorageItem.getOxygenStorage(item);
        }
        if (CompatibleManager.Create.isLoaded() && (storage = BacktankOxygenStorage.getOxygenStroage(item)) != null) {
            return storage;
        }
        return null;
    }

    public static long insert(class_1309 living, long amount) {
        for (ItemStackReference item : LivingHelper.getSlotItems(living)) {
            if (amount <= 0L) break;
            if (!(item.getStack().method_7909() instanceof OxygenCanItem)) continue;
            UniveralFluidHandler tank = UniveralFluidHandler.from(item);
            FluidHolder containedStack = tank.getFluidInTank(0);
            class_3611 insertingFluid = (class_3611)ModFluids.OXYGEN.get();
            if (!containedStack.isEmpty()) {
                insertingFluid = containedStack.getFluid();
            }
            FluidHolder inserting = FluidHooks.newFluidHolder((class_3611)insertingFluid, (long)amount, null);
            long inserted = tank.insertFluid(inserting, false);
            amount -= inserted;
        }
        return amount;
    }

    private OxygenStorageUtils() {
    }
}

