/*
 * Decompiled with CFR 0.152.
 */
package ad_astra_giselle_addon.common.item;

import ad_astra_giselle_addon.common.item.ItemStackReference;
import earth.terrarium.botarium.api.energy.EnergyHooks;
import earth.terrarium.botarium.api.item.ItemStackHolder;
import java.util.function.Consumer;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum ItemUsableResource {
    Energy{

        @Override
        public boolean test(class_1799 item) {
            return EnergyHooks.isEnergyItem((class_1799)item);
        }

        @Override
        public long extract(class_1309 living, class_1304 slot, ItemStackReference item, long amount, boolean simulate) {
            return this.extract(item, amount, simulate);
        }

        @Override
        public long extract(class_1309 living, byte slot, ItemStackReference item, long amount, boolean simulate) {
            return this.extract(item, amount, simulate);
        }

        @Override
        public long extract(class_1309 living, class_1268 hand, ItemStackReference item, long amount, boolean simulate) {
            return this.extract(item, amount, simulate);
        }

        private Long extract(ItemStackReference item, long amount, boolean simulate) {
            return EnergyHooks.safeGetItemEnergyManager((class_1799)item.getStack()).map(e -> e.extract((ItemStackHolder)item, amount, simulate)).orElse(0L);
        }
    }
    ,
    Durability{

        @Override
        public boolean test(class_1799 item) {
            return true;
        }

        @Override
        public long extract(class_1309 living, byte slot, ItemStackReference item, long amount, boolean simulate) {
            return this.extract(living, item, amount, simulate, l -> l.field_6002.method_8421((class_1297)l, slot));
        }

        @Override
        public long extract(class_1309 living, class_1304 slot, ItemStackReference item, long amount, boolean simulate) {
            return this.extract(living, item, amount, simulate, l -> l.method_20235(slot));
        }

        @Override
        public long extract(class_1309 living, class_1268 hand, ItemStackReference item, long amount, boolean simulate) {
            return this.extract(living, item, amount, simulate, l -> l.method_20236(hand));
        }

        private long extract(class_1309 living, ItemStackReference item, long amount, boolean simulate, Consumer<class_1309> onBreak) {
            class_1799 stack = item.getStack();
            if (stack.method_7963() && !simulate) {
                stack.method_7956((int)amount, living, onBreak);
                item.setStack(stack);
            }
            return amount;
        }
    };


    @Nullable
    public static ItemUsableResource first(class_1799 item) {
        for (ItemUsableResource resource : ItemUsableResource.values()) {
            if (!resource.test(item)) continue;
            return resource;
        }
        return null;
    }

    public abstract boolean test(class_1799 var1);

    public abstract long extract(class_1309 var1, byte var2, ItemStackReference var3, long var4, boolean var6);

    public abstract long extract(class_1309 var1, class_1304 var2, ItemStackReference var3, long var4, boolean var6);

    public abstract long extract(class_1309 var1, class_1268 var2, ItemStackReference var3, long var4, boolean var6);
}

