/*
 * Decompiled with CFR 0.152.
 */
package ad_astra_giselle_addon.common.item;

import ad_astra_giselle_addon.common.config.ItemsConfig;
import ad_astra_giselle_addon.common.content.oxygen.ChargeMode;
import ad_astra_giselle_addon.common.content.oxygen.IChargeMode;
import ad_astra_giselle_addon.common.content.oxygen.IOxygenCharger;
import ad_astra_giselle_addon.common.content.oxygen.IOxygenChargerItem;
import ad_astra_giselle_addon.common.content.oxygen.OxygenChargerUtils;
import ad_astra_giselle_addon.common.fluid.FluidPredicates;
import ad_astra_giselle_addon.common.fluid.UniveralFluidHandler;
import ad_astra_giselle_addon.common.item.ItemStackConsumers;
import ad_astra_giselle_addon.common.item.ItemStackReference;
import ad_astra_giselle_addon.common.util.NBTUtils;
import ad_astra_giselle_addon.common.util.TranslationUtils;
import earth.terrarium.ad_astra.common.item.FluidContainingItem;
import earth.terrarium.ad_astra.common.item.armor.SpaceSuit;
import earth.terrarium.ad_astra.common.registry.ModFluids;
import earth.terrarium.ad_astra.common.registry.ModItems;
import earth.terrarium.botarium.api.fluid.FluidHolder;
import earth.terrarium.botarium.api.fluid.FluidHooks;
import earth.terrarium.botarium.api.item.ItemStackHolder;
import java.util.List;
import java.util.function.BiPredicate;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import org.apache.commons.lang3.Range;

public class OxygenCanItem
extends class_1792
implements FluidContainingItem,
IOxygenChargerItem {
    public static final String KEY_OXYGEN_CHARGER = "oxygencharger";
    public static final String KEY_CHARGE_MODE = "chargemode";

    public OxygenCanItem(class_1792.class_1793 properties) {
        super(properties.method_7889(1));
    }

    public long getTankSize() {
        return ItemsConfig.OXYGEN_CAN_FLUID_CAPACITY;
    }

    protected long getFluidTransfer() {
        return ItemsConfig.OXYGEN_CAN_FLUID_TRANSFER;
    }

    public BiPredicate<Integer, FluidHolder> getFilter() {
        return FluidPredicates::isOxygen;
    }

    public void method_7850(class_1761 group, class_2371<class_1799> list) {
        super.method_7850(group, list);
        if (this.method_7877(group)) {
            ItemStackHolder full = new ItemStackHolder(new class_1799((class_1935)this));
            IOxygenCharger oxygenCharger = OxygenChargerUtils.get(full);
            oxygenCharger.getFluidHandler().insertFluid(FluidHooks.newFluidHolder((class_3611)((class_3611)ModFluids.OXYGEN.get()), (long)oxygenCharger.getOxygenCapacity(), null), false);
            list.add((Object)full.getStack());
        }
    }

    public class_1814 method_7862(class_1799 item) {
        return this.method_7886(item) ? class_1814.field_8904 : super.method_7862(item);
    }

    public boolean method_7886(class_1799 item) {
        long totalAmount;
        IOxygenCharger oxygenCharger = OxygenChargerUtils.get(new ItemStackHolder(item));
        if (oxygenCharger != null && oxygenCharger.getChargeMode() != ChargeMode.NONE && (totalAmount = oxygenCharger.getOxygenAmount()) > 0L) {
            return true;
        }
        return super.method_7886(item);
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        class_1799 item = player.method_5998(hand);
        if (level.method_8608()) {
            return class_1271.method_22430((Object)item);
        }
        ItemStackReference holder = new ItemStackReference(item, ItemStackConsumers.hand(hand, (arg_0, arg_1) -> ((class_1657)player).method_6122(arg_0, arg_1)));
        IOxygenCharger oxygenCharger = OxygenChargerUtils.get(holder);
        if (oxygenCharger != null && !player.method_5715()) {
            IChargeMode chargeMode = oxygenCharger.getChargeMode();
            List<IChargeMode> modes = oxygenCharger.getAvailableChargeModes();
            int nextIndex = (modes.indexOf(chargeMode) + 1) % modes.size();
            IChargeMode nextMode = modes.get(nextIndex);
            oxygenCharger.setChargeMode(nextMode);
            player.method_43496(TranslationUtils.descriptionChargeMode(nextMode));
        }
        return class_1271.method_22430((Object)item);
    }

    public void method_7851(class_1799 item, class_1937 level, List<class_2561> tooltip, class_1836 flag) {
        super.method_7851(item, level, tooltip, flag);
        IOxygenCharger oxygenCharger = OxygenChargerUtils.get(new ItemStackHolder(item));
        if (oxygenCharger != null) {
            tooltip.add(TranslationUtils.descriptionTemperatureRange(oxygenCharger.getTemperatureThreshold()));
            tooltip.add(TranslationUtils.descriptionChargeMode(oxygenCharger.getChargeMode()));
            UniveralFluidHandler fluidHandler = oxygenCharger.getFluidHandler();
            for (int i = 0; i < fluidHandler.getTankAmount(); ++i) {
                FluidHolder fluid = fluidHandler.getFluidInTank(i);
                long capacity = fluidHandler.getTankCapacity(i);
                tooltip.add(TranslationUtils.oxygenStorage(fluid.getFluidAmount(), capacity));
            }
        }
    }

    public boolean method_31567(class_1799 item) {
        return true;
    }

    public int method_31569(class_1799 item) {
        double ratio = OxygenChargerUtils.get(new ItemStackHolder(item)).getOxygenStoredRatio();
        return (int)(ratio * 13.0);
    }

    public int method_31571(class_1799 item) {
        double ratio = OxygenChargerUtils.get(new ItemStackHolder(item)).getOxygenStoredRatio();
        return class_3532.method_15369((float)((float)(ratio / 3.0)), (float)1.0f, (float)1.0f);
    }

    @Override
    public IOxygenCharger getOxygenCharger(ItemStackHolder item) {
        return new AbstractOxygenCharger(item){

            @Override
            public Range<Integer> getTemperatureThreshold() {
                return ((SpaceSuit)ModItems.SPACE_SUIT.get()).getTemperatureThreshold();
            }
        };
    }

    public abstract class AbstractOxygenCharger
    implements IOxygenCharger {
        private final ItemStackHolder item;

        public AbstractOxygenCharger(ItemStackHolder item) {
            this.item = item;
        }

        @Override
        public void setChargeMode(IChargeMode mode) {
            class_2487 tag = NBTUtils.getOrCreateTag(this.getItem().getStack(), OxygenCanItem.KEY_OXYGEN_CHARGER);
            tag.method_10566(OxygenCanItem.KEY_CHARGE_MODE, IChargeMode.writeNBT(mode));
        }

        @Override
        public IChargeMode getChargeMode() {
            class_2487 tag = NBTUtils.getTag(this.getItem().getStack(), OxygenCanItem.KEY_OXYGEN_CHARGER);
            return IChargeMode.readNBT(tag.method_10580(OxygenCanItem.KEY_CHARGE_MODE));
        }

        @Override
        public long getTransferAmount() {
            return OxygenCanItem.this.getFluidTransfer();
        }

        @Override
        public UniveralFluidHandler getFluidHandler() {
            return UniveralFluidHandler.from(this.item);
        }

        public final ItemStackHolder getItem() {
            return this.item;
        }
    }
}

