/*
 * Decompiled with CFR 0.152.
 */
package dev.thestaticvoid.capejs;

import dev.latvian.mods.kubejs.event.EventJS;
import dev.thestaticvoid.capejs.CapeJS;
import dev.thestaticvoid.capejs.kubejs.AddCapeEventJS;
import dev.thestaticvoid.capejs.kubejs.CapeJSEvents;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.class_2960;
import net.minecraft.class_742;

public class CapeRegistry {
    private static final HashMap<UUID, class_2960> CUSTOM_CAPE_MAP = new HashMap();
    private static final class_2960 DEV_CAPE = new class_2960("capejs", CapeRegistry.locationString("dev_cape"));

    public static void initialize() {
        CapeJS.LOGGER.info("Registering custom capes for: capejs");
        CapeRegistry.addToCapeMap("8c641065-dba3-41f3-864f-edea4ddfc8bb", DEV_CAPE);
        CapeJSEvents.ADD_CAPE.post((EventJS)new AddCapeEventJS());
    }

    private static String locationString(String type) {
        return "textures/capes/" + type + ".png";
    }

    public static class_2960 createCapeResource(String type) {
        String textureLocation = CapeRegistry.locationString(type);
        if (type.equals("dev_cape")) {
            throw new IllegalArgumentException("dev_cape is reserved for mod author!");
        }
        if (!class_2960.method_20207((String)textureLocation)) {
            throw new IllegalArgumentException(type + ".png is not found in capejs/textures/capes/");
        }
        return new class_2960("capejs", textureLocation);
    }

    public static void addToCapeMap(String uuid, class_2960 identifier) {
        CapeJS.LOGGER.info("Adding custom cape for: " + uuid + ", at: " + identifier);
        if (!CUSTOM_CAPE_MAP.containsKey(UUID.fromString(uuid))) {
            CUSTOM_CAPE_MAP.put(UUID.fromString(uuid), identifier);
        }
    }

    public static boolean mapContainsPlayer(class_742 player) {
        return CUSTOM_CAPE_MAP.containsKey(player.method_7334().getId());
    }

    public static class_2960 getResourceByPlayer(class_742 player) {
        UUID uuid = player.method_7334().getId();
        if (CUSTOM_CAPE_MAP.containsKey(uuid)) {
            return CUSTOM_CAPE_MAP.get(uuid);
        }
        return null;
    }
}

