/*
 * Decompiled with CFR 0.152.
 */
package dev.sapphic.couplings;

import com.google.common.base.Preconditions;
import dev.sapphic.couplings.Couplings;
import io.netty.buffer.Unpooled;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

@Environment(value=EnvType.CLIENT)
public final class CouplingsClient
implements ClientModInitializer {
    private static boolean serverCouplesDoors;
    private static boolean serverCouplesFenceGates;
    private static boolean serverCouplesTrapdoors;

    static boolean serverCouplesDoors() {
        return serverCouplesDoors;
    }

    static boolean serverCouplesFenceGates() {
        return serverCouplesFenceGates;
    }

    static boolean serverCouplesTrapdoors() {
        return serverCouplesTrapdoors;
    }

    public void onInitializeClient() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)Couplings.SERVER_CONFIG, (minecraft, listener, buf, sender) -> {
            Preconditions.checkArgument((buf.readableBytes() == 1 ? 1 : 0) != 0, (Object)buf);
            byte serverConfig = buf.readByte();
            Preconditions.checkArgument((serverConfig <= 7 ? 1 : 0) != 0, (Object)buf);
            minecraft.execute(() -> {
                serverCouplesDoors = (serverConfig >> 2 & 1) != 0;
                serverCouplesFenceGates = (serverConfig >> 1 & 1) != 0;
                serverCouplesTrapdoors = (serverConfig & 1) != 0;
            });
        });
        ClientPlayConnectionEvents.JOIN.register((listener, sender, minecraft) -> {
            int clientConfig = Couplings.IGNORE_SNEAKING ? 1 : 0;
            ClientPlayNetworking.send((class_2960)Couplings.CLIENT_CONFIG, (class_2540)new class_2540(Unpooled.buffer((int)1, (int)1).writeByte(clientConfig).asReadOnly()));
        });
    }
}

