/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.emojiful.api;

import com.hrznstudio.emojiful.Constants;
import com.hrznstudio.emojiful.platform.Services;
import com.hrznstudio.emojiful.util.EmojiUtil;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import net.minecraft.class_1011;
import net.minecraft.class_1044;
import net.minecraft.class_1049;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class Emoji
implements Predicate<String> {
    public static final class_2960 loading_texture = new class_2960("emojiful", "textures/26a0.png");
    public static final class_2960 noSignal_texture = new class_2960("emojiful", "textures/26d4.png");
    public static final class_2960 error_texture = new class_2960("emojiful", "textures/26d4.png");
    public static final AtomicInteger threadDownloadCounter = new AtomicInteger(0);
    public static final AtomicInteger threadFileLoaderCounter = new AtomicInteger(0);
    public String name;
    public List<String> strings = new ArrayList<String>();
    public List<String> texts = new ArrayList<String>();
    public String location;
    public int version = 1;
    public int sort = 0;
    public boolean worldBased = false;
    public boolean deleteOldTexture;
    public List<DownloadImageData> img = new ArrayList<DownloadImageData>();
    public List<class_2960> frames = new ArrayList<class_2960>();
    public boolean finishedLoading = false;
    public boolean loadedTextures = false;
    private String shortString;
    private String regex;
    private Pattern regexPattern;
    private String textRegex;
    private Thread imageThread;
    private Thread gifLoaderThread;

    public void checkLoad() {
        if (this.imageThread == null && !this.finishedLoading) {
            this.loadImage();
        } else if (!this.loadedTextures) {
            this.loadedTextures = true;
        }
    }

    public class_2960 getResourceLocationForBinding() {
        this.checkLoad();
        if (this.deleteOldTexture) {
            this.img.forEach(class_1044::method_4528);
            this.deleteOldTexture = false;
        }
        return this.finishedLoading && this.frames.size() > 0 ? this.frames.get((int)((double)System.currentTimeMillis() / 10.0 % (double)this.frames.size())) : loading_texture;
    }

    @Override
    public boolean test(String s) {
        for (String text : this.strings) {
            if (!s.equalsIgnoreCase(text)) continue;
            return true;
        }
        return false;
    }

    public boolean worldBased() {
        return this.worldBased;
    }

    public String getShorterString() {
        if (this.shortString != null) {
            return this.shortString;
        }
        this.shortString = this.strings.get(0);
        for (String string : this.strings) {
            if (string.length() >= this.shortString.length()) continue;
            this.shortString = string;
        }
        return this.shortString;
    }

    public Pattern getRegex() {
        if (this.regexPattern != null) {
            return this.regexPattern;
        }
        this.regexPattern = Pattern.compile(this.getRegexString());
        return this.regexPattern;
    }

    public String getRegexString() {
        if (this.regex != null) {
            return this.regex;
        }
        ArrayList<String> processed = new ArrayList<String>();
        for (String string : this.strings) {
            char first;
            char last = string.toLowerCase().charAt(string.length() - 1);
            Object s = string;
            if (last >= 'a' && last <= 'z') {
                s = string + "\\b";
            }
            if ((first = string.toLowerCase().charAt(0)) >= 'a' && first <= 'z') {
                s = "\\b" + (String)s;
            }
            processed.add(EmojiUtil.cleanStringForRegex((String)s));
        }
        this.regex = String.join((CharSequence)"|", processed);
        return this.regex;
    }

    public String getTextRegex() {
        if (this.textRegex != null) {
            return this.textRegex;
        }
        ArrayList<String> processed = new ArrayList<String>();
        for (String string : this.texts) {
            processed.add(EmojiUtil.cleanStringForRegex(string));
        }
        this.textRegex = "(?<=^|\\s)(" + String.join((CharSequence)"|", processed) + ")(?=$|\\s)";
        return this.textRegex;
    }

    private void loadImage() {
        final File cache = this.getCache();
        if (cache.exists()) {
            if (this.getUrl().endsWith(".gif") && Services.CONFIG.loadGifEmojis()) {
                if (this.gifLoaderThread == null) {
                    this.gifLoaderThread = new Thread("Emojiful Texture Downloader #" + threadDownloadCounter.incrementAndGet()){

                        @Override
                        public void run() {
                            try {
                                Emoji.this.loadTextureFrames(EmojiUtil.splitGif(cache));
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    };
                    this.gifLoaderThread.setDaemon(true);
                    this.gifLoaderThread.start();
                }
            } else {
                try {
                    DownloadImageData imageData = new DownloadImageData(ImageIO.read(cache), loading_texture);
                    class_2960 resourceLocation = new class_2960("emojiful", "texures/emoji/" + this.name.toLowerCase().replaceAll("[^a-z0-9/._-]", "") + "_" + this.version);
                    class_310.method_1551().method_1531().method_4616(resourceLocation, (class_1044)imageData);
                    this.img.add(imageData);
                    this.frames.add(resourceLocation);
                    this.finishedLoading = true;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else if (this.imageThread == null) {
            this.loadTextureFromServer();
        }
    }

    public String getUrl() {
        return "https://raw.githubusercontent.com/InnovativeOnlineIndustries/emojiful-assets/master/" + this.location;
    }

    public File getCache() {
        return new File("emojiful/cache/" + this.name + "-" + this.version);
    }

    public void loadTextureFrames(List<Pair<BufferedImage, Integer>> framesPair) {
        class_310.method_1551().method_19537(() -> {
            int i = 0;
            for (Pair bufferedImage : framesPair) {
                DownloadImageData imageData = new DownloadImageData((BufferedImage)bufferedImage.getKey(), loading_texture);
                class_2960 resourceLocation = new class_2960("emojiful", "texures/emoji/" + this.name.toLowerCase().replaceAll("[^a-z0-9/._-]", "") + "_" + this.version + "_frame" + i);
                class_310.method_1551().method_1531().method_4616(resourceLocation, (class_1044)imageData);
                this.img.add(imageData);
                Integer integer = 0;
                while (integer < (Integer)bufferedImage.getValue()) {
                    this.frames.add(resourceLocation);
                    Integer n = integer;
                    integer = integer + 1;
                }
                ++i;
            }
            this.finishedLoading = true;
        });
    }

    protected void loadTextureFromServer() {
        this.imageThread = new Thread("Emojiful Texture Downloader #" + threadDownloadCounter.incrementAndGet()){

            @Override
            public void run() {
                HttpURLConnection httpurlconnection = null;
                try {
                    httpurlconnection = (HttpURLConnection)new URL(Emoji.this.getUrl()).openConnection(class_310.method_1551().method_1487());
                    httpurlconnection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.95 Safari/537.11");
                    httpurlconnection.setDoInput(true);
                    httpurlconnection.setDoOutput(false);
                    httpurlconnection.connect();
                    if (httpurlconnection.getResponseCode() / 100 == 2) {
                        if (Emoji.this.getCache() != null) {
                            FileUtils.copyInputStreamToFile((InputStream)httpurlconnection.getInputStream(), (File)Emoji.this.getCache());
                        }
                        Emoji.this.finishedLoading = true;
                        Emoji.this.loadImage();
                    } else {
                        Emoji.this.frames = new ArrayList<class_2960>();
                        Emoji.this.frames.add(noSignal_texture);
                        Emoji.this.deleteOldTexture = true;
                        Emoji.this.finishedLoading = true;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    Emoji.this.frames = new ArrayList<class_2960>();
                    Emoji.this.frames.add(error_texture);
                    Emoji.this.deleteOldTexture = true;
                    Emoji.this.finishedLoading = true;
                }
                finally {
                    if (httpurlconnection != null) {
                        httpurlconnection.disconnect();
                    }
                }
            }
        };
        this.imageThread.setDaemon(true);
        this.imageThread.start();
    }

    public class DownloadImageData
    extends class_1049 {
        private final BufferedImage cacheFile;
        public boolean textureUploaded;
        private class_1011 nativeImage;

        public DownloadImageData(BufferedImage cacheFileIn, class_2960 textureResourceLocation) {
            super(textureResourceLocation);
            this.cacheFile = cacheFileIn;
        }

        private void checkTextureUploaded() {
            if (!this.textureUploaded && this.nativeImage != null) {
                if (this.field_5224 != null) {
                    this.method_4528();
                }
                TextureUtil.prepareImage((int)super.method_4624(), (int)this.nativeImage.method_4307(), (int)this.nativeImage.method_4323());
                this.nativeImage.method_4301(0, 0, 0, true);
                this.textureUploaded = true;
            }
        }

        private void setImage(class_1011 nativeImageIn) {
            class_310.method_1551().execute(() -> {
                this.textureUploaded = true;
                if (!RenderSystem.isOnRenderThread()) {
                    RenderSystem.recordRenderCall(() -> this.upload(nativeImageIn));
                } else {
                    this.upload(nativeImageIn);
                }
            });
        }

        private void upload(class_1011 imageIn) {
            TextureUtil.prepareImage((int)this.method_4624(), (int)imageIn.method_4307(), (int)imageIn.method_4323());
            imageIn.method_4301(0, 0, 0, true);
        }

        @Nullable
        private class_1011 loadTexture(InputStream inputStreamIn) {
            class_1011 nativeimage = null;
            try {
                nativeimage = class_1011.method_4309((InputStream)inputStreamIn);
            }
            catch (IOException ioexception) {
                Constants.LOG.warn("Error while loading the skin texture", (Throwable)ioexception);
            }
            return nativeimage;
        }

        public void method_4625(class_3300 resourceManager) throws IOException {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)this.cacheFile, "png", os);
            ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
            this.setImage(this.loadTexture(is));
        }
    }
}

