/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.emojiful.gui;

import com.hrznstudio.emojiful.ClientEmojiHandler;
import com.hrznstudio.emojiful.Constants;
import com.hrznstudio.emojiful.api.Emoji;
import com.hrznstudio.emojiful.api.EmojiCategory;
import com.hrznstudio.emojiful.gui.IDrawableGuiListener;
import com.hrznstudio.emojiful.platform.Services;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_408;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_7417;
import net.minecraft.class_768;

public class EmojiSelectionGui
implements IDrawableGuiListener {
    private final class_408 chatScreen;
    private final class_342 fieldWidget;
    private final class_768 openSelectionArea;
    private final class_768 selectionArea;
    private final class_768 categorySelectionArea;
    private final class_768 emojiInfoArea;
    private final class_768 textFieldRectangle;
    private int selectionPointer = 1;
    private int categoryPointer = 0;
    private int openSelectionAreaEmoji;
    private boolean showingSelectionArea;
    private double lastMouseX;
    private double lastMouseY;
    private Emoji lastEmoji;
    private List<Emoji[]> filteredEmojis;

    public EmojiSelectionGui(class_408 screen) {
        this.chatScreen = screen;
        this.openSelectionAreaEmoji = -1;
        if (Constants.EMOJI_MAP.containsKey("Smileys & Emotion")) {
            this.openSelectionAreaEmoji = new Random().nextInt(Constants.EMOJI_MAP.get("Smileys & Emotion").size());
        }
        this.showingSelectionArea = false;
        int offset = 0;
        if (Services.PLATFORM.isModLoaded("quark")) {
            offset = -80;
        }
        this.openSelectionArea = new class_768(this.chatScreen.field_22789 - 14, this.chatScreen.field_22790 - 12, 12, 12);
        this.selectionArea = new class_768(this.chatScreen.field_22789 - 14 - 132 + offset, this.chatScreen.field_22790 - 16 - 110 - 4, 136, 114);
        this.categorySelectionArea = new class_768(this.selectionArea.method_3321(), this.selectionArea.method_3322() + 20, 22, this.selectionArea.method_3320() - 20);
        this.emojiInfoArea = new class_768(this.selectionArea.method_3321() + 22, this.selectionArea.method_3322() + this.selectionArea.method_3320() - 20, this.selectionArea.method_3319() - 22, 20);
        this.textFieldRectangle = new class_768(this.selectionArea.method_3321() + 6, this.selectionArea.method_3322() + 6, this.selectionArea.method_3319() - 12, 10);
        this.fieldWidget = new class_342(ClientEmojiHandler.oldFontRenderer, this.textFieldRectangle.method_3321(), this.textFieldRectangle.method_3322(), this.textFieldRectangle.method_3319(), this.textFieldRectangle.method_3320(), (class_2561)class_5250.method_43477((class_7417)new class_2585("")));
        this.fieldWidget.method_1888(true);
        this.fieldWidget.method_1862(true);
        this.filteredEmojis = new ArrayList<Emoji[]>();
    }

    @Override
    public void render(class_4587 stack) {
        if (this.openSelectionAreaEmoji != -1) {
            class_310.method_1551().field_1772.method_1729(stack, Constants.EMOJI_MAP.get((Object)"Smileys & Emotion").get((int)this.openSelectionAreaEmoji).strings.get(0), (float)this.openSelectionArea.method_3321(), (float)this.openSelectionArea.method_3322(), 0);
        }
        if (this.showingSelectionArea) {
            this.drawRectangle(stack, this.selectionArea);
            this.drawRectangle(stack, this.categorySelectionArea);
            this.drawRectangle(stack, this.emojiInfoArea);
            for (int i = 0; i < 6; ++i) {
                this.drawLine(stack, (float)i * 12.0f, i + this.selectionPointer);
            }
            int progressY = (int)((double)(this.emojiInfoArea.method_3322() - this.categorySelectionArea.method_3322() - 5) / (double)this.getLineAmount() * (double)this.selectionPointer);
            this.drawRectangle(stack, new class_768(this.selectionArea.method_3321() + this.selectionArea.method_3319() - 2, this.categorySelectionArea.method_3322() + progressY, 1, 5), -11382190);
            if (this.lastEmoji != null) {
                class_310.method_1551().field_1772.method_1729(stack, this.lastEmoji.strings.get(0), (float)(this.emojiInfoArea.method_3321() + 2), (float)(this.emojiInfoArea.method_3322() + 6), 0);
                StringBuilder builder = new StringBuilder();
                this.lastEmoji.strings.forEach(s -> builder.append((String)s).append(" "));
                float textScale = 0.5f;
                List iTextPropertiesList = ClientEmojiHandler.oldFontRenderer.method_1728(class_5348.method_29430((String)builder.toString()), (int)((float)(this.emojiInfoArea.method_3319() - 18) * (1.0f / textScale)));
                float i = -iTextPropertiesList.size() / 2;
                stack.method_22903();
                stack.method_22905(textScale, textScale, textScale);
                for (class_5481 reorderingProcessor : iTextPropertiesList) {
                    StringBuilder stringBuilder = new StringBuilder();
                    reorderingProcessor.accept((p_accept_1_, p_accept_2_, ch) -> {
                        stringBuilder.append((char)ch);
                        return true;
                    });
                    ClientEmojiHandler.oldFontRenderer.method_1729(stack, stringBuilder.toString(), (float)(this.emojiInfoArea.method_3321() + 15) * (1.0f / textScale), ((float)(this.emojiInfoArea.method_3322() + 8) + 4.0f * i) * (1.0f / textScale), 0x969696);
                    i += 1.0f;
                }
                stack.method_22905(1.0f, 1.0f, 1.0f);
                stack.method_22909();
            }
            progressY = (int)((double)(this.categorySelectionArea.method_3320() - 10) / ((double)ClientEmojiHandler.CATEGORIES.size() - 7.0) * (double)this.categoryPointer);
            this.drawRectangle(stack, new class_768(this.categorySelectionArea.method_3321() + this.categorySelectionArea.method_3319() - 2, this.categorySelectionArea.method_3322() + progressY + 2, 1, 5), -11382190);
            EmojiCategory firstCategory = this.getCategory(this.selectionPointer);
            for (int i = 0; i < 7; ++i) {
                int selCategory = i + this.categoryPointer;
                if (selCategory >= ClientEmojiHandler.CATEGORIES.size()) continue;
                EmojiCategory category = ClientEmojiHandler.CATEGORIES.get(selCategory);
                class_768 rec = new class_768(this.categorySelectionArea.method_3321() + 6, this.categorySelectionArea.method_3322() + 6 + i * 12, 11, 11);
                if (category.equals(firstCategory)) {
                    class_332.method_25294((class_4587)stack, (int)(rec.method_3321() - 1), (int)(rec.method_3322() - 2), (int)(rec.method_3321() + rec.method_3319()), (int)(rec.method_3322() + rec.method_3320() - 1), (int)-2130706433);
                }
                if (rec.method_3318((int)this.lastMouseX, (int)this.lastMouseY) && class_310.method_1551().field_1755 != null) {
                    class_310.method_1551().field_1755.method_30901(stack, Arrays.asList(class_5250.method_43477((class_7417)new class_2585(category.name()))), (int)this.lastMouseX, (int)this.lastMouseY);
                }
                if (!ClientEmojiHandler.SORTED_EMOJIS_FOR_SELECTION.containsKey(category) || ClientEmojiHandler.SORTED_EMOJIS_FOR_SELECTION.get(category).size() <= 0) continue;
                class_310.method_1551().field_1772.method_1729(stack, ClientEmojiHandler.SORTED_EMOJIS_FOR_SELECTION.get((Object)category).get((int)0)[0].strings.get(0), (float)(this.categorySelectionArea.method_3321() + 6), (float)(this.categorySelectionArea.method_3322() + 6 + i * 12), 0);
            }
            this.fieldWidget.method_25394(stack, (int)this.lastMouseX, (int)this.lastMouseY, 0.0f);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int p_231044_5_) {
        if (this.openSelectionArea.method_3318((int)mouseX, (int)mouseY)) {
            this.toggleSelectionArea();
            return true;
        }
        if (this.showingSelectionArea) {
            this.fieldWidget.method_1876(this.textFieldRectangle.method_3318((int)mouseX, (int)mouseY));
            if (this.categorySelectionArea.method_3318((int)mouseX, (int)mouseY)) {
                for (int i = 0; i < 7; ++i) {
                    class_768 rec;
                    int selCategory = i + this.categoryPointer;
                    if (selCategory >= ClientEmojiHandler.CATEGORIES.size() || !(rec = new class_768(this.categorySelectionArea.method_3321() + 6, this.categorySelectionArea.method_3322() + 6 + i * 12, 11, 11)).method_3318((int)mouseX, (int)mouseY)) continue;
                    EmojiCategory name = ClientEmojiHandler.CATEGORIES.get(selCategory);
                    for (int i1 = 0; i1 < this.getLineAmount(); ++i1) {
                        if (!name.equals(this.getLineToDraw(i1))) continue;
                        this.selectionPointer = i1;
                    }
                }
                return true;
            }
            if (this.selectionArea.method_3318((int)mouseX, (int)mouseY)) {
                for (int line = 0; line < 6; ++line) {
                    Object object = this.getLineToDraw(line + this.selectionPointer);
                    if (!(object instanceof Emoji[])) continue;
                    Emoji[] emojis = (Emoji[])object;
                    for (int i = 0; i < emojis.length; ++i) {
                        float y;
                        float x;
                        class_768 rec;
                        if (emojis[i] == null || !(rec = new class_768((int)(x = (float)(this.categorySelectionArea.method_3321() + this.categorySelectionArea.method_3319() + 2) + 12.0f * (float)i), (int)(y = (float)(this.categorySelectionArea.method_3322() + line * 12 + 2)) - 1, 11, 11)).method_3318((int)this.lastMouseX, (int)this.lastMouseY)) continue;
                        this.chatScreen.field_2382.method_1852(this.chatScreen.field_2382.method_1882() + emojis[i].getShorterString());
                    }
                }
                return true;
            }
        }
        return false;
    }

    public void method_16014(double mouseX, double mouseY) {
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        if (this.categorySelectionArea.method_3318((int)mouseX, (int)mouseY)) {
            this.categoryPointer = (int)((double)this.categoryPointer - delta);
            this.categoryPointer = class_3532.method_15340((int)this.categoryPointer, (int)0, (int)(ClientEmojiHandler.CATEGORIES.size() - 7));
            return true;
        }
        if (this.selectionArea.method_3318((int)mouseX, (int)mouseY)) {
            this.selectionPointer = (int)((double)this.selectionPointer - delta);
            this.selectionPointer = class_3532.method_15340((int)this.selectionPointer, (int)1, (int)Math.max(1, this.getLineAmount() - 5));
            this.categoryPointer = class_3532.method_15340((int)Arrays.asList(ClientEmojiHandler.CATEGORIES).indexOf(this.getCategory(this.selectionPointer)), (int)0, (int)(ClientEmojiHandler.CATEGORIES.size() - 7));
            return true;
        }
        return false;
    }

    public void drawRectangle(class_4587 stack, class_768 rectangle2d) {
        this.drawRectangle(stack, rectangle2d, Integer.MIN_VALUE);
    }

    public void drawRectangle(class_4587 stack, class_768 rectangle2d, int value) {
        class_332.method_25294((class_4587)stack, (int)rectangle2d.method_3321(), (int)rectangle2d.method_3322(), (int)(rectangle2d.method_3321() + rectangle2d.method_3319()), (int)(rectangle2d.method_3322() + rectangle2d.method_3320()), (int)value);
    }

    public void toggleSelectionArea() {
        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
        this.showingSelectionArea = !this.showingSelectionArea;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.fieldWidget.method_25404(keyCode, scanCode, modifiers)) {
            this.updateFilter();
            return true;
        }
        return false;
    }

    public boolean method_25400(char c, int mod) {
        if (this.fieldWidget.method_25400(c, mod)) {
            this.updateFilter();
            return true;
        }
        return false;
    }

    public void drawLine(class_4587 stack, float height, int line) {
        Object lineToDraw = this.getLineToDraw(line);
        if (lineToDraw != null) {
            if (lineToDraw instanceof EmojiCategory) {
                float textScale = 1.0f;
                stack.method_22905(textScale, textScale, textScale);
                class_310.method_1551().field_1772.method_1729(stack, ((EmojiCategory)lineToDraw).name(), (float)(this.categorySelectionArea.method_3321() + this.categorySelectionArea.method_3319() + 2) * (1.0f / textScale), ((float)this.categorySelectionArea.method_3322() + height + 2.0f) * (1.0f / textScale), 0x969696);
                stack.method_22905(1.0f, 1.0f, 1.0f);
            } else {
                Emoji[] emojis = (Emoji[])lineToDraw;
                for (int i = 0; i < emojis.length; ++i) {
                    float y;
                    if (emojis[i] == null) continue;
                    float x = (float)(this.categorySelectionArea.method_3321() + this.categorySelectionArea.method_3319() + 2) + 12.0f * (float)i;
                    class_768 rec = new class_768((int)x, (int)(y = (float)this.categorySelectionArea.method_3322() + height + 2.0f) - 1, 11, 11);
                    if (rec.method_3318((int)this.lastMouseX, (int)this.lastMouseY)) {
                        this.lastEmoji = emojis[i];
                        class_332.method_25294((class_4587)stack, (int)(rec.method_3321() - 1), (int)(rec.method_3322() - 1), (int)(rec.method_3321() + rec.method_3319()), (int)(rec.method_3322() + rec.method_3320()), (int)-2130706433);
                    }
                    class_310.method_1551().field_1772.method_1729(stack, emojis[i].strings.get(0), x, y, 0x969696);
                }
            }
        }
    }

    public Object getLineToDraw(int line) {
        if (this.fieldWidget.method_1882().isEmpty()) {
            for (EmojiCategory category : ClientEmojiHandler.SORTED_EMOJIS_FOR_SELECTION.keySet()) {
                if (--line == 0) {
                    return category;
                }
                for (Emoji[] emojis : ClientEmojiHandler.SORTED_EMOJIS_FOR_SELECTION.get(category)) {
                    if (--line != 0) continue;
                    return emojis;
                }
            }
        } else if (this.filteredEmojis.size() > line - 1 && line - 1 >= 0) {
            return this.filteredEmojis.get(line - 1);
        }
        return null;
    }

    public void updateFilter() {
        if (!this.fieldWidget.method_1882().isEmpty()) {
            this.selectionPointer = 1;
            this.filteredEmojis = new ArrayList<Emoji[]>();
            List emojis = Constants.EMOJI_LIST.stream().filter(emoji -> emoji.strings.stream().anyMatch(s -> s.toLowerCase().contains(this.fieldWidget.method_1882().toLowerCase()))).collect(Collectors.toList());
            Emoji[] array = new Emoji[9];
            int i = 0;
            Iterator iterator = emojis.iterator();
            while (iterator.hasNext()) {
                Emoji emoji2;
                array[i] = emoji2 = (Emoji)iterator.next();
                if (++i < array.length) continue;
                this.filteredEmojis.add(array);
                array = new Emoji[9];
                i = 0;
            }
            if (i > 0) {
                this.filteredEmojis.add(array);
            }
        }
    }

    public int getLineAmount() {
        return this.fieldWidget.method_1882().isEmpty() ? ClientEmojiHandler.lineAmount : this.filteredEmojis.size();
    }

    public EmojiCategory getCategory(int line) {
        for (EmojiCategory category : ClientEmojiHandler.SORTED_EMOJIS_FOR_SELECTION.keySet()) {
            if (--line == 0) {
                return category;
            }
            for (Emoji[] emojis : ClientEmojiHandler.SORTED_EMOJIS_FOR_SELECTION.get(category)) {
                if (--line != 0) continue;
                return category;
            }
        }
        return null;
    }

    public class_408 getChatScreen() {
        return this.chatScreen;
    }

    public class_342 getFieldWidget() {
        return this.fieldWidget;
    }
}

