/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.explorerscompass.workers;

import com.chaosthedude.explorerscompass.config.ExplorersCompassConfig;
import com.chaosthedude.explorerscompass.workers.StructureSearchWorker;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_4076;
import net.minecraft.class_6871;

public class ConcentricRingsSearchWorker
extends StructureSearchWorker<class_6871> {
    private List<class_1923> potentialChunks;
    private int chunkIndex = 0;
    private double minDistance = Double.MAX_VALUE;
    private Pair<class_2338, class_3195> closest;

    public ConcentricRingsSearchWorker(class_3218 level, class_1657 player, class_1799 stack, class_2338 startPos, class_6871 placement, List<class_3195> structureSet, String managerId) {
        super(level, player, stack, startPos, placement, structureSet, managerId);
        this.potentialChunks = level.method_14178().method_12129().method_40147(placement, level.method_14178().method_41248());
        this.finished = !level.method_8503().method_27728().method_28057().method_28029() || this.potentialChunks == null || this.potentialChunks.isEmpty();
    }

    @Override
    public boolean hasWork() {
        return !this.finished && this.samples < ExplorersCompassConfig.maxSamples && this.chunkIndex < this.potentialChunks.size();
    }

    @Override
    public boolean doWork() {
        super.doWork();
        if (this.hasWork()) {
            Pair<class_2338, class_3195> pair;
            class_1923 chunkPos = this.potentialChunks.get(this.chunkIndex);
            this.currentPos = new class_2338(class_4076.method_32205((int)chunkPos.field_9181, (int)8), 0, class_4076.method_32205((int)chunkPos.field_9180, (int)8));
            double distance = this.startPos.method_10262((class_2382)this.currentPos);
            if ((this.closest == null || distance < this.minDistance) && (pair = this.getStructureGeneratingAt(chunkPos)) != null) {
                this.minDistance = distance;
                this.closest = pair;
            }
            ++this.samples;
            ++this.chunkIndex;
        }
        if (this.hasWork()) {
            return true;
        }
        if (this.closest != null) {
            this.succeed((class_2338)this.closest.getFirst(), (class_3195)this.closest.getSecond());
        } else if (!this.finished) {
            this.fail();
        }
        return false;
    }

    @Override
    protected String getName() {
        return "ConcentricRingsSearchWorker";
    }

    @Override
    public boolean shouldLogRadius() {
        return false;
    }

    private Pair<class_2338, class_3195> getClosest() {
        List list = this.level.method_14178().method_12129().method_40147((class_6871)this.placement, this.level.method_14178().method_41248());
        if (list == null) {
            return null;
        }
        Pair<class_2338, class_3195> closestPair = null;
        double minDistance = Double.MAX_VALUE;
        class_2338.class_2339 sampleBlockPos = new class_2338.class_2339();
        for (class_1923 chunkPos : list) {
            Pair<class_2338, class_3195> pair;
            sampleBlockPos.method_10103(class_4076.method_32205((int)chunkPos.field_9181, (int)8), 32, class_4076.method_32205((int)chunkPos.field_9180, (int)8));
            double distance = sampleBlockPos.method_10262((class_2382)this.startPos);
            if (closestPair != null && !(distance < minDistance) || (pair = this.getStructureGeneratingAt(chunkPos)) == null) continue;
            closestPair = pair;
            minDistance = distance;
        }
        return closestPair;
    }
}

