/*
 * Decompiled with CFR 0.152.
 */
package io.github.mattidragon.extendeddrawers;

import com.kneelawk.graphlib.GraphLib;
import com.kneelawk.graphlib.graph.BlockGraphController;
import io.github.mattidragon.extendeddrawers.block.base.NetworkComponent;
import io.github.mattidragon.extendeddrawers.config.ClientConfig;
import io.github.mattidragon.extendeddrawers.config.CommonConfig;
import io.github.mattidragon.extendeddrawers.misc.DrawerContentsLootFunction;
import io.github.mattidragon.extendeddrawers.network.NetworkRegistry;
import io.github.mattidragon.extendeddrawers.networking.CompressionOverrideSyncPacket;
import io.github.mattidragon.extendeddrawers.registry.ModBlocks;
import io.github.mattidragon.extendeddrawers.registry.ModItems;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.itemgroup.FabricItemGroupBuilder;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerChunkEvents;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1761;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3695;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendedDrawers
implements ModInitializer {
    public static final String MOD_ID = "extended_drawers";
    public static final class_1761 MOD_GROUP = FabricItemGroupBuilder.create((class_2960)ExtendedDrawers.id("main")).icon(() -> ModItems.SHADOW_DRAWER.method_7854()).build();
    public static final ModContainer MOD_CONTAINER = (ModContainer)FabricLoader.getInstance().getModContainer("extended_drawers").orElseThrow();
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"extended_drawers");

    public static class_2960 id(String path) {
        return new class_2960(MOD_ID, path);
    }

    public void onInitialize() {
        ModBlocks.register();
        ModItems.register();
        DrawerContentsLootFunction.register();
        NetworkRegistry.register();
        CompressionOverrideSyncPacket.register();
        ClientConfig.HANDLE.load();
        CommonConfig.HANDLE.load();
        ResourceManagerHelper.registerBuiltinResourcePack((class_2960)ExtendedDrawers.id("alt"), (ModContainer)MOD_CONTAINER, (String)"ED: Alternative Textures", (ResourcePackActivationType)ResourcePackActivationType.NORMAL);
        ResourceManagerHelper.registerBuiltinResourcePack((class_2960)ExtendedDrawers.id("dev"), (ModContainer)MOD_CONTAINER, (String)"ED: Programmer Art", (ResourcePackActivationType)ResourcePackActivationType.NORMAL);
        ServerChunkEvents.CHUNK_LOAD.register((world, chunk) -> {
            if (!((CommonConfig)CommonConfig.HANDLE.get()).automaticNetworkHealing()) {
                return;
            }
            class_3695 profiler = world.method_16107();
            profiler.method_15396("extended_drawers:update_chunks");
            class_1923 chunkPos = chunk.method_12004();
            BlockGraphController controller = GraphLib.getController((class_3218)world);
            Iterable area = class_2338.method_10094((int)chunkPos.method_8326(), (int)chunk.method_31607(), (int)chunkPos.method_8328(), (int)chunkPos.method_8327(), (int)chunk.method_31600(), (int)chunkPos.method_8329());
            for (class_2338 pos : area) {
                class_2680 state = chunk.method_8320(pos);
                if (!(state.method_26204() instanceof NetworkComponent) || !controller.getGraphsAt(pos).findAny().isEmpty()) continue;
                LOGGER.info("Scheduling graph refresh at " + pos.method_10263() + ", " + pos.method_10264() + ", " + pos.method_10260());
                class_2338 pos1 = pos.method_10062();
                GraphLib.getController((class_3218)world).updateNodes(pos1);
            }
            profiler.method_15407();
        });
    }
}

